/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;

public class TypeLenExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "\u7c7b\u578b\u5b9a\u957f";
    protected static final String DATA_FORMAT_DEFAULT_FILL_STYLE = "defFillStyle";
    protected static final String DATA_FORMAT_DEFAULT_FILLER = "defFiller";
    private static final String ITEM_ATTRIBUTE_TYPE = "itemType";
    private static final String ITEM_ATTRIBUTE_LENGTH = "itemLength";
    private static final String ITEM_TYPE_INT = "int";
    private static final String ITEM_TYPE_LONG = "long";
    private static final String ITEM_TYPE_SHORT = "short";
    private static final String ITEM_TYPE_BYTE = "byte";
    private static final String ITEM_TYPE_STRING = "string";
    private int searchIndex;
    private int dataLength;
    private String defDataFillStyle;
    private byte[] defDataFiller;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private ByteArrayOutputStream byteOut;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        this.defDataFillStyle = property.get(DATA_FORMAT_DEFAULT_FILL_STYLE);
        String fillchar = property.get(DATA_FORMAT_DEFAULT_FILLER);
        this.defDataFiller = ExecutorHelper.parserFiller(fillchar);
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.byteOut = new ByteArrayOutputStream(256);
            this.outputStream = new DataOutputStream(this.byteOut);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.dataLength = inputData.length;
        this.inputStream = new DataInputStream(new ByteArrayInputStream(inputData));
        this.searchIndex = 0;
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.byteOut.toByteArray();
        this.byteOut.reset();
        this.outputStream.close();
        return data;
    }

    @Override
    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String dataType = paras.get(ITEM_ATTRIBUTE_TYPE);
        if (ITEM_TYPE_STRING.equals(dataType)) {
            String fLen = paras.get(ITEM_ATTRIBUTE_LENGTH);
            return ExecutorHelper.defFillData(this.getExecutorName(), item, data, fLen, this.defDataFillStyle, this.defDataFiller, this.getRootContext(), true);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String type = paras.get(ITEM_ATTRIBUTE_TYPE);
        if (ITEM_TYPE_STRING.equals(type)) {
            this.outputStream.write(data);
        } else if (ITEM_TYPE_SHORT.equals(type)) {
            short val = Short.parseShort(new String(data));
            this.outputStream.writeShort(val);
        } else if (ITEM_TYPE_BYTE.equals(type)) {
            byte val = Byte.parseByte(new String(data));
            this.outputStream.writeByte(val);
        } else if (ITEM_TYPE_INT.equals(type)) {
            int val = Integer.parseInt(new String(data));
            this.outputStream.writeInt(val);
        } else if (ITEM_TYPE_LONG.equals(type)) {
            long val = Long.parseLong(new String(data));
            this.outputStream.writeLong(val);
        } else {
            throw new Exception("\u7c7b\u578b\u5b9a\u957f\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b[" + type + "]\u65e0\u6548\uff01");
        }
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String type = paras.get(ITEM_ATTRIBUTE_TYPE);
        byte[] dataValue = new byte[]{};
        if (ITEM_TYPE_STRING.equals(type)) {
            String str = paras.get(ITEM_ATTRIBUTE_LENGTH);
            int intLen = ExecutorHelper.parseItemLen(this.getExecutorName(), item, str, this.getRootContext(), this.dataLength, this.searchIndex);
            ExecutorHelper.validataMaxLen(this.getExecutorName(), item, intLen);
            this.searchIndex += intLen;
            byte[] data = new byte[intLen];
            int temp = this.inputStream.read(data);
            if (temp < 0) {
                this.setDataFormatEnd();
            } else if (temp == data.length) {
                dataValue = data;
            } else {
                dataValue = new byte[temp];
                System.arraycopy(data, 0, dataValue, 0, temp);
            }
        } else if (ITEM_TYPE_SHORT.equals(type)) {
            short data = this.inputStream.readShort();
            dataValue = Short.toString(data).getBytes();
            this.searchIndex += 2;
        } else if (ITEM_TYPE_BYTE.equals(type)) {
            int data = this.inputStream.read();
            dataValue = Integer.toString(data).getBytes();
            ++this.searchIndex;
        } else if (ITEM_TYPE_INT.equals(type)) {
            int data = this.inputStream.readInt();
            dataValue = Integer.toString(data).getBytes();
            this.searchIndex += 4;
        } else if (ITEM_TYPE_LONG.equals(type)) {
            long data = this.inputStream.readLong();
            dataValue = Long.toString(data).getBytes();
            this.searchIndex += 8;
        } else {
            throw new Exception("\u7c7b\u578b\u5b9a\u957f\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b[" + type + "]\u65e0\u6548\uff01");
        }
        if (this.searchIndex >= this.dataLength) {
            this.setDataFormatEnd();
        }
        return dataValue;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLength) {
            return -1;
        }
        return this.searchIndex;
    }
}

