/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBody;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Body;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.BodyItem;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "JSON";
    private static final String ITEM_ATTRIBUTE_DATA_TYPE = "type";
    private static final String ITEM_ATTRIBUTE_DATA_VARIABLE = "varName";
    private static final String ITEM_ATTRIBUTE_ESCAPE = "escape";
    private static final String DATA_TYPE_STRING = "string";
    private static final String DATA_TYPE_BOOLEAN = "boolean";
    private static final String DATA_TYPE_NUMBER = "number";
    private static final String ESCAPE_TRUE = "true";
    private static final String ESCAPE_FALSE = "false";
    private static final String DATA_TYPE_INT = "int";
    private ByteArrayOutputStream output;
    private Map<String, Object> jsonData;
    private static final byte[] digits = new byte[]{123, 125, 91, 93, 58, 34, 44};

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.output = new ByteArrayOutputStream();
            this.output.write(digits[0]);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            this.jsonData = this.parserJson(inputData);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u62c6\u5305\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        this.output.write(digits[1]);
        return this.output.toByteArray();
    }

    @Override
    protected void packBody(Body body) throws Exception {
        BodyItem[] item;
        if (body != null && (item = body instanceof CacheBody ? ((CacheBody)body).getBodyItemArr() : body.getBodyItem()) != null) {
            byte[] bytes;
            boolean pack = false;
            boolean packDot = false;
            for (int i = 0; i < item.length; ++i) {
                if (pack) {
                    this.output.write(digits[6]);
                    packDot = true;
                }
                pack = this.packBodyItem(item[i].getChoiceValue());
            }
            if (!pack && packDot && (bytes = this.output.toByteArray()).length > 1 && bytes[bytes.length - 1] == digits[6]) {
                this.output.reset();
                this.output.write(bytes, 0, bytes.length - 1);
            }
        }
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            dataVar = item.getName();
        }
        String dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE);
        this.writeKey(dataVar);
        String escape = paras.get(ITEM_ATTRIBUTE_ESCAPE);
        if (StringTools.isEmpty(escape)) {
            escape = ESCAPE_FALSE;
        }
        if (DATA_TYPE_BOOLEAN.equals(dataType)) {
            String ret = new String(data, this.getEncoding());
            if (Boolean.parseBoolean(ret)) {
                this.output.write(ESCAPE_TRUE.getBytes());
            } else {
                this.output.write(ESCAPE_FALSE.getBytes());
            }
        } else if (DATA_TYPE_STRING.equals(dataType)) {
            if (ESCAPE_TRUE.endsWith(escape)) {
                data = StringTools.escapeStringToCharArray(data);
            }
            this.writeValue(data);
        } else {
            this.output.write(data);
        }
    }

    private void writeKey(String dataVar) throws IOException, UnsupportedEncodingException {
        this.output.write(digits[5]);
        this.output.write(dataVar.getBytes(this.getEncoding()));
        this.output.write(digits[5]);
        this.output.write(digits[4]);
    }

    private void writeValue(byte[] data) throws IOException, UnsupportedEncodingException {
        this.output.write(digits[5]);
        this.output.write(data);
        this.output.write(digits[5]);
    }

    @Override
    public void packGroup(Group group) throws Exception {
        String name = group.getName();
        this.writeKey(name);
        this.output.write(digits[0]);
        this.packBody(group.getBody());
        this.output.write(digits[1]);
    }

    @Override
    public void packWhile(While _while) throws Exception {
        String name = _while.getName();
        String varname = _while.getVar();
        this.writeKey(name);
        this.output.write(digits[2]);
        int nCount = this.parseLoopCount(_while);
        for (int i = 0; i < nCount; ++i) {
            this.output.write(digits[0]);
            this.rootContext.put(varname, new Integer(i));
            this.packBody(_while.getBody());
            this.output.write(digits[1]);
            if (i >= nCount - 1) continue;
            this.output.write(digits[6]);
        }
        this.rootContext.remove(varname);
        this.output.write(digits[3]);
    }

    @Override
    public byte[] autoPack(Map<String, Object> map) throws Exception {
        this.output.reset();
        this.autoPackMap(map, new ArrayList<String>());
        byte[] data = this.output.toByteArray();
        this.output.close();
        return data;
    }

    private void autoPackMap(Map<String, Object> map, List<String> path) throws Exception {
        Object obj = null;
        this.output.write(digits[0]);
        boolean boo = false;
        for (String key : map.keySet()) {
            obj = map.get(key);
            if (boo) {
                this.output.write(digits[6]);
            } else {
                boo = true;
            }
            if (obj instanceof Map) {
                this.writeKey(key);
                path.add(key);
                this.autoPackMap((Map)obj, path);
                path.remove(path.size() - 1);
                continue;
            }
            if (obj instanceof List) {
                this.writeKey(key);
                this.autoPackList(key, (List)obj, path);
                continue;
            }
            if (obj instanceof String && ((String)obj).indexOf(digits[5]) != -1) {
                obj = StringTools.escapeStringToCharArray(((String)obj).getBytes());
            }
            boo = this.autoPackValue(key, obj, path);
        }
        this.output.write(digits[1]);
    }

    private void autoPackList(String key, List<Object> list, List<String> path) throws Exception {
        this.output.write(digits[2]);
        Object obj = null;
        boolean boo = false;
        for (int i = 0; i < list.size(); ++i) {
            obj = list.get(i);
            path.add(key + "[" + i + "]");
            if (boo) {
                this.output.write(digits[6]);
            } else {
                boo = true;
            }
            if (obj instanceof Map) {
                this.autoPackMap((Map)obj, path);
            } else if (obj instanceof List) {
                this.autoPackList("", (List)obj, path);
            } else {
                boo = this.autoPackValue(null, obj, path);
            }
            path.remove(path.size() - 1);
        }
        this.output.write(digits[3]);
    }

    private boolean autoPackValue(String key, Object value, List<String> path) throws Exception {
        byte[] valueByte;
        if (value instanceof byte[] || value instanceof String) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
            if (this.isFilterEmpty() && valueByte.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ \u81ea\u62fc:{},\u8fc7\u6ee4\u7a7a\u4e32", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
                }
                return false;
            }
        } else if (value instanceof Integer) {
            valueByte = ByteTools.getBytes(value);
        } else if (value instanceof Boolean) {
            valueByte = ((Boolean)value).booleanValue() ? ESCAPE_TRUE.getBytes() : ESCAPE_FALSE.getBytes();
        } else if (value != null) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ \u81ea\u62fc:{},\u5ffd\u7565(\u503c\u4e3anull)", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
            }
            return false;
        }
        valueByte = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), valueByte, 1);
        if (!StringTools.isEmpty(key)) {
            this.writeKey(key);
        }
        this.writeValue(valueByte);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} @ \u81ea\u62fc:{}=[{}]", new Object[]{this.getExecutorName(), this.pathToString(path, key), StringTools.getString(value, this.getEncoding())});
        }
        return true;
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        return this.jsonData;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u6570\u636e\u53d8\u91cf\u4e3a\u7a7a\u3002");
        }
        dataVar = OgnlTools.parseXPath(dataVar, this.getRootContext());
        Object obj = OgnlTools.getValue(dataVar, this.jsonData);
        return ByteTools.getBytes(obj, this.getEncoding());
    }

    @Override
    protected void unPackWhile(While _while) throws Exception {
        String name = _while.getName();
        String varname = _while.getVar();
        int nCount = this.parseLoopCount(_while, this.jsonData);
        this.logger.debug("{} @ \u5faa\u73af\u62c6\u62a5\u6587,\u5faa\u73af\u540d\u79f0:{},\u6b21\u6570:{},\u53d8\u91cf:{}", new Object[]{this.getExecutorName(), name, nCount, varname});
        super.unPackWhile(nCount, name, varname, _while);
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    private Map<String, Object> parserJson(byte[] inputData) throws Exception {
        JSONObject json = JSONObject.parseObject((String)new String(inputData, this.getEncoding()));
        Map map = (Map)JSONObject.toJavaObject((JSON)json, Map.class);
        if (this.getGlobalParseMethod() != null) {
            this.parserDataByGlobalMethod(map, 2, this.getGlobalParseMethod());
        }
        return map;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

