/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.resources.core.BspTools;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class BitmapExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "Bitmap";
    protected static final String DATA_FORMAT_BITMAP_TYPE = "bitmapType";
    private static final String DATA_FORMAT_BITMAP_LENGTH = "bitmapLen";
    protected static final String DATA_FORMAT_DEFAULT_FILL_STYLE = "defFillStyle";
    protected static final String DATA_FORMAT_DEFAULT_FILLER = "defFiller";
    protected static final String ITEM_ATTRIBUTE_DATA_POSITION = "position";
    protected static final String ITEM_ATTRIBUTE_FILTER_EMPTY = "filterEmpty";
    protected static final String ITEM_ATTRIBUTE_DATA_FIELD_TYPE = "fieldType";
    protected static final String ITEM_ATTRIBUTE_DATA_LENGTH = "length";
    protected static final String ITEM_ATTRIBUTE_DATA_TYPE = "type";
    protected static final String ITEM_ATTRIBUTE_DATA_FILLER = "dataFiller";
    protected static final String ITEM_ATTRIBUTE_DATA_FILL_STYLE = "dataFillStyle";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH = "lenFieldLength";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE = "lenFieldType";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER = "lenFieldFiller";
    protected static final String ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE = "lenFieldFillStyle";
    protected static final String DATA_TYPE_ASCII = "ascii";
    protected static final String DATA_TYPE_BCD = "bcd";
    protected static final String DATA_TYPE_BINARY_ASCII = "binaryAscii";
    protected static final String DATA_TYPE_BINARY_BCD = "binaryBcd";
    protected static final String DATA_TYPE_HEXASCII = "hexascii";
    protected static final String DATA_TYPE_HEXBCD = "hexbcd";
    protected static final String FILL_STYLE_LEFT = "left";
    protected static final String FILL_STYLE_RIGHT = "right";
    protected static final String FIELD_TYPE_FIX = "fix";
    protected static final String FIELD_TYPE_UNFIX = "unfix";
    protected String bitmapType;
    private int bitmapLen;
    protected int searchIndex = 0;
    protected String defDataFillStyle;
    protected byte[] defDataFiller;
    protected int bitmapMinPos;
    protected int bitmapMaxPos;
    private boolean isISO8583;
    protected ByteArrayOutputStream output;
    protected int[] bitmap;
    protected LinkedList<Integer> listPosition;
    protected int dataLength;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        this.bitmapType = property.get(DATA_FORMAT_BITMAP_TYPE);
        this.defDataFillStyle = property.get(DATA_FORMAT_DEFAULT_FILL_STYLE);
        this.defDataFiller = ExecutorHelper.parserFiller(property.get(DATA_FORMAT_DEFAULT_FILLER));
        String str = property.get(DATA_FORMAT_BITMAP_LENGTH);
        try {
            this.bitmapLen = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u4e2dbitmap\u957f\u5ea6[" + this.bitmapLen + "]\u8bbe\u7f6e\u6709\u8bef\uff01");
        }
        this.isISO8583 = false;
        this.searchIndex = 0;
        this.bitmapMinPos = 1;
        this.bitmapMaxPos = this.bitmapLen * 8;
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.output = new ByteArrayOutputStream();
            this.bitmap = new int[this.bitmapLen * 8];
        } else {
            this.listPosition = new LinkedList();
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        this.setInputData(inputData);
        this.dataLength = inputData.length;
        this.unpackBitmap();
    }

    protected void setInputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.output.toByteArray();
        this.output.reset();
        this.packBitmap();
        this.output.write(data);
        data = this.output.toByteArray();
        this.output.reset();
        return data;
    }

    protected void packBitmap() throws Exception {
        if (DATA_TYPE_ASCII.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isISO8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            int intBitmap = 0;
            int intTemp = 0;
            for (int i = 0; i < index; ++i) {
                intTemp = (i + 1) % 4;
                if (intTemp != 0) {
                    intTemp = -(intTemp - 3);
                    intBitmap += 2 * this.bitmap[i] << intTemp;
                } else {
                    intBitmap += this.bitmap[i] == 0 ? 0 : 1;
                }
                if ((i + 1) % 4 != 0) continue;
                intBitmap = intBitmap > 9 ? intBitmap + 55 : intBitmap + 48;
                this.output.write(intBitmap);
                intBitmap = 0;
            }
        } else if (DATA_TYPE_BCD.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isISO8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            int intBitmap = 0;
            int intTemp = 0;
            for (int i = 0; i < index; ++i) {
                intTemp = (i + 1) % 8;
                if (intTemp != 0) {
                    intTemp = -(intTemp - 7);
                    intBitmap += 2 * this.bitmap[i] << intTemp;
                } else {
                    intBitmap += this.bitmap[i] == 0 ? 0 : 1;
                }
                if ((i + 1) % 8 != 0) continue;
                this.output.write(intBitmap);
                intBitmap = 0;
            }
        } else if (DATA_TYPE_BINARY_ASCII.equals(this.bitmapType)) {
            int index = this.bitmap.length;
            if (this.isISO8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            int intTemp = 0;
            for (int i = 0; i < index; ++i) {
                intTemp = this.bitmap[i] + 48;
                this.output.write(intTemp);
            }
        } else if (DATA_TYPE_BINARY_BCD.equals(this.bitmapType)) {
            int intBitmap = 0;
            int index = this.bitmap.length;
            if (this.isISO8583 && this.bitmap[0] == 0) {
                index /= 2;
            }
            for (int i = 0; i < index; i += 2) {
                intBitmap = this.bitmap[i] * 16 + this.bitmap[i + 1];
                this.output.write(intBitmap);
            }
        } else {
            throw new Exception("Bitmap\u7684bitmap\u7c7b\u578b[" + this.bitmapType + "]\u4e0d\u6b63\u786e\uff01");
        }
    }

    @Override
    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        if (StringTools.isEmpty(fieldType)) {
            throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FIELD_TYPE_FIX.equals(fieldType)) {
            String strDataLen = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
            return ExecutorHelper.defFillData(this.getExecutorName(), item, data, strDataLen, this.defDataFillStyle, this.defDataFiller, this.getRootContext(), false);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String str = paras.get(ITEM_ATTRIBUTE_DATA_POSITION);
        if (StringTools.isEmpty(str)) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int position = 0;
        try {
            position = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d[" + str + "]\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
        }
        if (position < this.bitmapMinPos || position > this.bitmapMaxPos) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d[" + position + "]\u4e0d\u6b63\u786e\uff01");
        }
        if (this.isISO8583 && position > 64) {
            this.bitmap[0] = 1;
        }
        if (this.bitmap[position - 1] != 0) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d" + position + "\u91cd\u590d\uff0c\u4e4b\u524d\u5df2\u7ecf\u6709\u503c\uff01");
        }
        this.bitmap[position - 1] = 1;
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        String dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE);
        if (StringTools.isEmpty(dataType)) {
            throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILLER);
        String dataFiller = StringTools.isEmpty(str) ? "0" : str;
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILL_STYLE);
        String dataFillType = StringTools.isEmpty(str) ? FILL_STYLE_LEFT : str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH);
        int lenFieldLength = StringTools.isEmpty(str) ? 0 : Integer.parseInt(str);
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE);
        if (StringTools.isEmpty(str)) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String lenFieldType = str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER);
        String lenFieldFiller = StringTools.isEmpty(str) ? "0" : str;
        String lenFieldFillStyle = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE);
        if (FIELD_TYPE_UNFIX.equals(fieldType)) {
            int lenFieldValue = data.length;
            str = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
            int maxLen = -1;
            if (!StringTools.isEmpty(str)) {
                maxLen = Integer.parseInt(str);
            }
            if (maxLen > 0 && maxLen < lenFieldValue) {
                throw new Exception(this.getExecutorName() + " @ \u5b57\u6bb5[" + this.getRealItemPath(item) + "]\u7684\u5b9e\u9645\u6570\u636e\u957f\u5ea6[" + lenFieldValue + "]\u5927\u4e8e\u6570\u636e\u6700\u5927\u957f\u5ea6[" + maxLen + "]");
            }
            byte[] lenField = null;
            if (DATA_TYPE_ASCII.equals(lenFieldType)) {
                lenField = ByteTools.int2DecAsciiByte(lenFieldValue);
                if (lenField.length < lenFieldLength) {
                    lenField = FILL_STYLE_LEFT.equals(lenFieldFillStyle) ? ByteTools.leftPad(lenField, lenFieldLength, lenFieldFiller.getBytes()) : ByteTools.rightPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                }
            } else if (DATA_TYPE_BCD.equals(lenFieldType)) {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u957f\u5ea6\u57df\u586b\u5145\u7b26\u5728BCD\u7c7b\u578b\u65f6\u5fc5\u987b\u4e3a0-9\u6216\u8005a-f");
                }
                lenField = ByteTools.int2DecBcdByte(lenFieldValue, true, 0, lenFieldLength);
            } else if (DATA_TYPE_HEXASCII.equals(lenFieldType)) {
                lenField = ByteTools.int2HexAsciiByte(lenFieldValue);
                if (lenField.length < lenFieldLength) {
                    lenField = FILL_STYLE_LEFT.equals(lenFieldFillStyle) ? ByteTools.leftPad(lenField, lenFieldLength, lenFieldFiller.getBytes()) : ByteTools.rightPad(lenField, lenFieldLength, lenFieldFiller.getBytes());
                }
            } else if (DATA_TYPE_HEXBCD.equals(lenFieldType)) {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u957f\u5ea6\u57df\u586b\u5145\u7b26\u5728HEXBCD\u7c7b\u578b\u65f6\u5fc5\u987b\u4e3a0-9\u6216\u8005a-f");
                }
                lenField = ByteTools.int2HexBcdByte(lenFieldValue, true, 0, lenFieldLength);
            } else {
                throw new Exception("Bitmap\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u957f\u5ea6\u57df\u7c7b\u578b[" + lenFieldType + "]\u6709\u8bef\uff01");
            }
            this.output.write(lenField);
            if (DATA_TYPE_BCD.equals(dataType)) {
                int intFiller = this.parserFiller(dataFiller, item.getName());
                data = ByteTools.asc2Bcd(data, intFiller, FILL_STYLE_LEFT.equals(dataFillType));
            }
        } else if (FIELD_TYPE_FIX.equals(fieldType) && DATA_TYPE_BCD.equals(dataType)) {
            int intFiller = this.parserFiller(dataFiller, item.getName());
            data = ByteTools.asc2Bcd(data, intFiller, FILL_STYLE_LEFT.equals(dataFillType));
        }
        this.output.write(data);
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String str = paras.get(ITEM_ATTRIBUTE_DATA_POSITION);
        if (StringTools.isEmpty(str)) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int position = Integer.parseInt(str);
        if (position < this.bitmapMinPos || position > this.bitmapMaxPos) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684Bitmap\u4f4d[" + position + "]\u4e0d\u6b63\u786e\uff01");
        }
        if (this.listPosition.isEmpty() || this.listPosition.getFirst() != position) {
            return null;
        }
        this.listPosition.removeFirst();
        if (this.listPosition.isEmpty()) {
            this.setDataFormatEnd();
        }
        String fieldType = paras.get(ITEM_ATTRIBUTE_DATA_FIELD_TYPE);
        String strDataLen = paras.get(ITEM_ATTRIBUTE_DATA_LENGTH);
        String dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE);
        if (StringTools.isEmpty(dataType)) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILLER);
        String dataFiller = StringTools.isEmpty(str) ? "0" : str;
        str = paras.get(ITEM_ATTRIBUTE_DATA_FILL_STYLE);
        String dataFillType = StringTools.isEmpty(str) ? FILL_STYLE_LEFT : str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_LENGTH);
        int lenFieldLength = StringTools.isEmpty(str) ? 0 : Integer.parseInt(str);
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_TYPE);
        if (StringTools.isEmpty(str)) {
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String lenFieldType = str;
        str = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILLER);
        String lenFieldFiller = StringTools.isEmpty(str) ? "0" : str;
        String lenFieldFillStyle = paras.get(ITEM_ATTRIBUTE_LENGTH_FIELD_FILL_STYLE);
        if (FIELD_TYPE_UNFIX.equals(fieldType)) {
            byte[] byteLenField;
            byte[] tempField;
            int intDataLen = 0;
            if (DATA_TYPE_ASCII.equals(lenFieldType)) {
                byte[] byteLenField2 = new byte[lenFieldLength];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField2, 0, lenFieldLength);
                this.searchIndex += lenFieldLength;
                tempField = null;
                tempField = FILL_STYLE_RIGHT.equals(lenFieldFillStyle) ? ByteTools.stripEnd(byteLenField2, lenFieldFiller.getBytes()) : ByteTools.stripStart(byteLenField2, lenFieldFiller.getBytes());
                if (tempField.length == 0) {
                    this.logger.warn("{} @ \u5b57\u6bb5[{}]\u7684\u957f\u5ea6\u57df[{}]\u79fb\u9664\u5206\u9694\u7b26[{}]\u540e\u957f\u5ea6\u4e3a0", new Object[]{this.getExecutorName(), this.getRealItemPath(item), new String(byteLenField2), lenFieldFiller});
                    return new byte[0];
                }
                intDataLen = ByteTools.decAsciiByte2int(tempField);
            } else if (DATA_TYPE_BCD.equals(lenFieldType)) {
                if (!ExecutorHelper.isHexChar(lenFieldFiller)) {
                    throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u957f\u5ea6\u57df\u586b\u5145\u7b26\u5728HEXBCD\u7c7b\u578b\u65f6\u5fc5\u987b\u4e3a0-9\u6216\u8005a-f");
                }
                int len = lenFieldLength % 2 == 0 ? lenFieldLength / 2 : lenFieldLength / 2 + 1;
                byteLenField = new byte[len];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, len);
                this.searchIndex += len;
                intDataLen = ByteTools.decBcdByte2int(byteLenField, true, 0);
            } else if (DATA_TYPE_HEXASCII.equals(lenFieldType)) {
                byte[] byteLenField3 = new byte[lenFieldLength];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField3, 0, lenFieldLength);
                this.searchIndex += lenFieldLength;
                tempField = null;
                tempField = FILL_STYLE_RIGHT.equals(lenFieldFillStyle) ? ByteTools.stripEnd(byteLenField3, lenFieldFiller.getBytes()) : ByteTools.stripStart(byteLenField3, lenFieldFiller.getBytes());
                if (tempField.length == 0) {
                    this.logger.warn("{} @ \u5b57\u6bb5[{}]\u7684\u957f\u5ea6\u57df[{}]\u79fb\u9664\u5206\u9694\u7b26[{}]\u540e\u957f\u5ea6\u4e3a0", new Object[]{this.getExecutorName(), this.getRealItemPath(item), new String(byteLenField3), lenFieldFiller});
                    return null;
                }
                intDataLen = ByteTools.decAsciiByte2int(tempField);
            } else if (DATA_TYPE_HEXBCD.equals(lenFieldType)) {
                int len = lenFieldLength % 2 == 0 ? lenFieldLength / 2 : lenFieldLength / 2 + 1;
                byteLenField = new byte[len];
                System.arraycopy(this.getInputData(), this.searchIndex, byteLenField, 0, len);
                this.searchIndex += len;
                intDataLen = ByteTools.hexBcdByte2int(byteLenField, true, 0);
            } else {
                throw new Exception("Bitmap\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u957f\u5ea6\u57df\u7c7b\u578b[" + lenFieldType + "]\u6709\u8bef\uff01");
            }
            if (DATA_TYPE_BCD.equals(dataType)) {
                int intTemp = intDataLen % 2 == 0 ? intDataLen / 2 : intDataLen / 2 + 1;
                byte[] dataValue = new byte[intTemp];
                System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intTemp);
                this.searchIndex += intTemp;
                if (intDataLen % 2 == 0) {
                    dataValue = ByteTools.bcd2Asc(dataValue);
                } else {
                    int intFiller = this.parserFiller(dataFiller, item.getName());
                    dataValue = ByteTools.bcd2Asc(dataValue, intFiller, FILL_STYLE_LEFT.equals(dataFillType), intDataLen);
                }
                return dataValue;
            }
            if (DATA_TYPE_ASCII.equals(dataType)) {
                byte[] dataValue = new byte[intDataLen];
                System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intDataLen);
                this.searchIndex += intDataLen;
                return dataValue;
            }
            throw new Exception("Bitmap\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u6570\u636e\u7c7b[" + dataType + "]\u578b\u6709\u8bef\uff01");
        }
        if (FIELD_TYPE_FIX.equals(fieldType)) {
            byte[] dataValue;
            if (StringTools.isEmpty(strDataLen)) {
                throw new Exception("Bitmap\u4e2d" + item.getName() + "\u7684\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int intDataLen = Integer.parseInt(strDataLen);
            if (DATA_TYPE_BCD.equals(dataType)) {
                int intTemp = intDataLen % 2 == 0 ? intDataLen / 2 : intDataLen / 2 + 1;
                dataValue = new byte[intTemp];
                System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intTemp);
                this.searchIndex += intTemp;
                if (intDataLen % 2 != 0) {
                    int intFiller = this.parserFiller(dataFiller, item.getName());
                    dataValue = ByteTools.bcd2Asc(dataValue, intFiller, FILL_STYLE_LEFT.equals(dataFillType), intDataLen);
                } else {
                    dataValue = ByteTools.bcd2Asc(dataValue);
                }
            } else {
                dataValue = new byte[intDataLen];
                System.arraycopy(this.getInputData(), this.searchIndex, dataValue, 0, intDataLen);
                this.searchIndex += intDataLen;
            }
            return dataValue;
        }
        return null;
    }

    @Override
    public void log(int logLevel, Item item, String value, Map<String, String> params, String appendStr) throws Exception {
        String logStr = null;
        Object[] logParams = null;
        String packTypeStr = null;
        if (this.packType == DATAFORMAT_PACK) {
            packTypeStr = "\u62fc\u5305";
            if (value == null) {
                logStr = "{} @ {}:[{}]{},\u5ffd\u7565 {}";
                logParams = new String[]{this.getExecutorName(), packTypeStr, params.get(ITEM_ATTRIBUTE_DATA_POSITION), OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext), appendStr};
                this.log(logLevel, logStr, logParams);
                return;
            }
        } else {
            packTypeStr = "\u62c6\u5305";
        }
        if (item.isPwd() && value != null) {
            this.setHiddenInfo(true);
            value = BspTools.pwdTransfer(value);
        }
        logStr = "{} @ {}:[{}]{}=[{}] {}";
        logParams = new String[]{this.getExecutorName(), packTypeStr, params.get(ITEM_ATTRIBUTE_DATA_POSITION), OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext), value, appendStr};
        this.log(logLevel, logStr, logParams);
    }

    private void unpackBitmap() {
        if (DATA_TYPE_ASCII.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 2;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserAsciiBitmap(bitmap, 4);
        } else if (DATA_TYPE_BCD.equals(this.bitmapType)) {
            byte[] bitmap = new byte[this.bitmapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, this.bitmapLen);
            this.searchIndex += this.bitmapLen;
            this.parserBcdBitmap(bitmap, 8);
        } else if (DATA_TYPE_BINARY_ASCII.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 8;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserAsciiBitmap(bitmap, 1);
        } else if (DATA_TYPE_BINARY_BCD.equals(this.bitmapType)) {
            int tempLen = this.bitmapLen * 4;
            byte[] bitmap = new byte[tempLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, tempLen);
            this.searchIndex += tempLen;
            this.parserBcdBitmap(bitmap, 2);
        }
        Collections.sort(this.listPosition);
    }

    protected void parserAsciiBitmap(byte[] bitmap, int len) {
        int i = 0;
        int res = 0;
        int intTemp = 0;
        for (byte b : bitmap) {
            int n = res = b > 57 ? b - 55 : b - 48;
            if (res == 0) {
                i += len;
                continue;
            }
            for (int j = len; j > 0; --j) {
                intTemp = res % 2;
                res /= 2;
                if (intTemp != 1) continue;
                this.listPosition.add(i + j);
            }
            i += len;
        }
    }

    protected void parserBcdBitmap(byte[] bitmap, int len) {
        int i = 0;
        int res = 0;
        int intTemp = 0;
        for (int n : bitmap) {
            int j;
            int n2 = res = n < 0 ? 256 + n : n;
            if (res == 0) {
                i += len;
                continue;
            }
            if (len == 8) {
                for (j = len; j > 0; --j) {
                    intTemp = res % 2;
                    res /= 2;
                    if (intTemp != 1) continue;
                    this.listPosition.add(i + j);
                }
            } else if (len == 2) {
                for (j = len; j > 0; --j) {
                    intTemp = res % 16;
                    res /= 16;
                    if (intTemp != 1) continue;
                    this.listPosition.add(i + j);
                }
            }
            i += len;
        }
    }

    private int parserFiller(String filler, String itemName) throws Exception {
        if (ExecutorHelper.isHexChar(filler)) {
            return Integer.parseInt(filler, 16);
        }
        throw new Exception("Bitmap\u4e2d" + itemName + "\u5b57\u6bb5\u7684\u6570\u636e\u586b\u5145\u7b26[" + filler + "]\u9519\u8bef\uff0c\u53ea\u5141\u8bb8\u57280-f\u4e4b\u95f4");
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    protected void setISO8583(boolean isISO8583) {
        this.isISO8583 = isISO8583;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLength) {
            return -1;
        }
        return this.searchIndex;
    }
}

