/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.communication.out.IOutAdapter;
import cn.com.yusys.yusp.bsp.method.impl.StringMethodTool;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.IService;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.component.impl.dataformat.DataFormatPacker;
import cn.com.yusys.yusp.bsp.workflow.component.impl.dataformat.DataFormatUnPacker;
import cn.com.yusys.yusp.bsp.workflow.mapping.DefaultMappingStrategy;
import cn.com.yusys.yusp.bsp.workflow.mapping.MappingParam;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractWorker;
import cn.com.yusys.yusp.commons.util.SpringContextUtil;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class BizWorker
extends AbstractWorker {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BIZ_TYPE_BIZTEMPLATE = "biz";
    private static final String BIZ_TYPE_SERVICE = "service";
    public static final String ACTION_EXCH = "Exchange";
    public static final String ACTION_RECV = "Receive";
    public static final String ACTION_SEND = "Send";
    public static final String COMM_ADAPTER_TYPE_IN = "InAdapter";
    public static final String COMM_ADAPTER_TYPE_OUT = "OutAdapter";
    protected static final String PARA_TIMEOUT = "timeout";
    protected static final String PARA_RESTORE_CONNECTION = "restoreConnection";

    @Override
    protected boolean executeJob() throws Exception {
        block23: {
            Session session = this.getSession();
            Map<String, Object> context = session.getContext();
            IRequest request = null;
            String adapterType = COMM_ADAPTER_TYPE_IN;
            try {
                request = (IRequest)session.getSessionObject("SESSION_INREQUEST");
                StreamRequest srt = (StreamRequest)request;
                int _timeout = this.parseTimeout(context);
                Socket socket = this.parseDatasourceWrapper(srt);
                IComm comm = session.getIComm();
                if (null != socket && null != comm) {
                    int soTimeOut = socket.getSoTimeout();
                    this.logger.info("{} @ \u8fde\u63a5:{}", new Object[]{"\u4ea4\u6613\u5904\u7406", socket});
                    if (!request.isTimeStart()) {
                        socket.setSoTimeout(0);
                    } else if (_timeout > 0) {
                        socket.setSoTimeout(_timeout);
                    }
                    try {
                        if (srt.getSocketWrapper().getBis() == null) {
                            throw new ComponentException("\u4e0d\u652f\u6301\u6570\u636e\u63a5\u6536\u64cd\u4f5c,\u8f93\u5165\u6d41\u4e3a\u7a7a");
                        }
                        comm.processRecv(context, srt);
                        MappingParam param = session.getMappingParam();
                        String msgPath = "";
                        msgPath = null == param ? "auto_unpack_xml.mfd" : param.getUnpackMsgNm();
                        DataFormatUnPacker unpacker = new DataFormatUnPacker();
                        context.put("unpackVarName", context.get("recvVar"));
                        context.put("messageName", msgPath);
                        unpacker.executeComponent(context);
                        AbstractInAdapter adapter = (AbstractInAdapter)request.getInAdapter();
                        if (null != adapter && adapter.getStrategy() instanceof DefaultMappingStrategy) {
                            comm.processMapping(context, srt, (Map)OgnlTools.getValue("Message.Sys_Head", context));
                        }
                        if (null == param) {
                            param = session.getMappingParam();
                        }
                        String invokeType = param.getInvokeType();
                        this.logger.info("\u8c03\u7528\u7c7b\u578b\u4e3a[{}]", (Object)invokeType);
                        if (!BIZ_TYPE_SERVICE.equals(invokeType)) {
                            throw new ComponentException("\u8c03\u7528\u7c7b\u578b\u975e\u6cd5\uff0c\u53ea\u652f\u6301biz\u6216\u8005service\u8c03\u7528\uff01");
                        }
                        this.logger.info("beanId\u4e3a[{}],\u5f00\u59cbservice\u8c03\u7528", (Object)param.getBeanId());
                        context = this.invokeService(param.getBeanId(), context);
                        DataFormatPacker packer = new DataFormatPacker();
                        msgPath = param.getPackMsgNm();
                        context.put("messageName", msgPath);
                        packer.executeComponent(context);
                        if (null != adapter && adapter.getStrategy() instanceof DefaultMappingStrategy) {
                            byte[] bsend = ByteTools.getBytes(context.get("packVarName"));
                            this.logger.info("\u6dfb\u52a06\u4f4d\u62a5\u6587\u957f\u5ea6");
                            context.put("sendVar", this.addMsgLength(bsend, 6));
                        } else {
                            context.put("sendVar", context.get("packVarName"));
                        }
                        if (srt.getSocketWrapper().getBos() == null) {
                            throw new ComponentException("\u4e0d\u652f\u6301\u6570\u636e\u53d1\u9001\u64cd\u4f5c,\u8f93\u51fa\u6d41\u4e3a\u7a7a");
                        }
                        comm.processSend(context, srt);
                        this.finish(request, session, adapterType, false);
                        break block23;
                    }
                    catch (Throwable e) {
                        srt.setCloseFlag(true);
                        this.finish(request, session, adapterType, true);
                        throw new Exception(e);
                    }
                    finally {
                        if (!(request.isTimeStart() && _timeout <= 0 || socket.isClosed())) {
                            socket.setSoTimeout(soTimeOut);
                        }
                    }
                }
                throw new ComponentException("Socket\u4e3a\u7a7a");
            }
            catch (Exception e) {
                this.finish(request, session, adapterType, true);
                this.logger.error("\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                throw e;
            }
            finally {
                if (session.getTradeDeadlineTime() == 0L) {
                    request.setTimeStart(true);
                    long current = System.currentTimeMillis();
                    session.setTradeStartTime(current);
                    session.setTradeDeadlineTime(-1L);
                }
            }
        }
        return true;
    }

    @Transactional
    private Map<String, Object> invokeService(String beanId, Map<String, Object> context) {
        IService service = (IService)SpringContextUtil.getBean((String)beanId);
        try {
            context = service.execute(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return context;
    }

    protected IRequest getUseRequest(Map<String, Object> context, Session session, String adapterType) throws Exception {
        if (COMM_ADAPTER_TYPE_IN.equals(adapterType)) {
            return (IRequest)session.getSessionObject("SESSION_INREQUEST");
        }
        String adapterName = (String)context.get("outAdaptor");
        if (StringTools.isEmpty(adapterName)) {
            throw new Exception("[\u9002\u914d\u5668\u540d\u79f0]\u7684\u503c\u4e3a\u7a7a");
        }
        BspAppContext xc = ResourcePortal.getInstance().getSpringContextRegistry().getModuleContext();
        IRequest request = null;
        try {
            IOutAdapter outAdapter = (IOutAdapter)xc.getBean(adapterName);
            request = outAdapter.borrowRequest(session);
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u8fde\u63a5\u5f02\u5e38", e);
        }
        return request;
    }

    private int parseTimeout(Map<String, Object> context) {
        int _intTimeOut = -1;
        try {
            String timeout = StringTools.getString(context.get(PARA_TIMEOUT));
            _intTimeOut = Integer.parseInt(timeout);
        }
        catch (Exception e) {
            this.logger.warn("\u8d85\u65f6\u8bbe\u7f6e\u65e0\u6548,\u4f7f\u7528\u9ed8\u8ba4\u503c:{}", (Object)"60*1000", (Object)e);
        }
        return _intTimeOut;
    }

    private byte[] addMsgLength(byte[] src, int length) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("signChar", Character.valueOf(' '));
        paras.put("direction", "LEFT");
        paras.put("targetLength", 6);
        byte[] len = StringMethodTool.fillWord(src.length, paras, null);
        return ByteTools.addBytes(len, src);
    }

    protected Socket parseDatasourceWrapper(StreamRequest srt) throws Exception {
        Object o = srt.getDatasourceWrapper();
        Socket socket = null;
        if (o instanceof SocketWrapper) {
            socket = ((SocketWrapper)o).getSocket();
        } else if (o instanceof Socket) {
            socket = (Socket)o;
        } else {
            throw new Exception("StreamRequest\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u7c7b\u578b[" + o.getClass().getName() + "]");
        }
        return socket;
    }

    protected void finish(IRequest request, Session session, String adapterType, boolean immediate) throws Exception {
        boolean isRestoreConnection = false;
        if (adapterType.equals(COMM_ADAPTER_TYPE_OUT)) {
            if (isRestoreConnection || immediate) {
                request.returnToOutAdapter();
                request.setOutAdapter(null);
                session.removeOutRequest(request);
            }
        } else if (adapterType.equals(COMM_ADAPTER_TYPE_IN) && (isRestoreConnection || immediate)) {
            request.returnToInAdapter();
            request.setInAdapter(null);
        }
    }
}

