/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.LoggerTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import cn.com.yusys.yusp.bsp.workflow.worker.IWorker;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorker
implements IWorker {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWorker.class);
    private static final Logger f5Logger = LoggerFactory.getLogger((String)"cn.com.bankit.bsp.workflow.worker.F5Logger");
    protected Session session;
    protected String publicIn;
    protected String publicOut;

    @Override
    public void run() {
        if (this.session.isPushLogInfo()) {
            LogbackUtil.putSingleInfo("contentlog", StringTools.getString(this.session.getContext().get("G_CONTENTLOG")));
        }
        boolean over = true;
        try {
            over = this.executeJob();
        }
        catch (Throwable t) {
            over = true;
            if (!logger.isDebugEnabled()) {
                LoggerTools.contextLog("\u4ea4\u6613\u4e0a\u4e0b\u6587", this.session.getContext(), logger, 2);
            }
        }
        finally {
            if (this.session.isRemoveLogInfo()) {
                LogbackUtil.clearAllInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean f5Check() {
        IRequest request = (IRequest)this.session.getSessionObject("SESSION_INREQUEST");
        if (request.getRequestType() == 1) {
            StreamRequest streamRequest = (StreamRequest)request;
            Object datasourceWrapper = streamRequest.getDatasourceWrapper();
            SocketWrapper socketWrapper = null;
            if (datasourceWrapper instanceof SocketWrapper) {
                socketWrapper = (SocketWrapper)datasourceWrapper;
                if (!socketWrapper.isFirst()) {
                    return false;
                }
            } else {
                return false;
            }
            socketWrapper.setFirst(false);
            Socket socket = socketWrapper.getSocket();
            int timeout = -1;
            try {
                timeout = socket.getSoTimeout();
                socket.setSoTimeout(10000);
                if (this.f5Check(socketWrapper)) {
                    request.setCloseFlag(true);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
            }
        }
        return false;
    }

    private boolean f5Check(SocketWrapper socketWrapper) throws IOException {
        BufferedInputStream bis = socketWrapper.getBis();
        bis.mark(1);
        int c = bis.read();
        if (c == -1) {
            f5Logger.debug("\u63a2\u6d4b\u5305\u68c0\u6d4b:{}", (Object)socketWrapper.getSocket());
            return true;
        }
        bis.reset();
        return false;
    }

    protected abstract boolean executeJob() throws Exception;

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void setPublicIn(String publicIn) {
        this.publicIn = publicIn;
    }

    @Override
    public String getPublicIn() {
        return this.publicIn;
    }

    @Override
    public String getPublicOut() {
        return this.publicOut;
    }

    @Override
    public void setPublicOut(String publicOut) {
        this.publicOut = publicOut;
    }
}

