/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.SocketTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.mapping.DefaultMappingStrategy;
import cn.com.yusys.yusp.bsp.workflow.mapping.MappingParam;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnFixComm
implements IComm,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UnFixComm.class);
    protected String unitName = "Socket\u901a\u8baf";
    protected static final String PARA_CLOSE_SND_CHANNEL = "closeSndChannel";
    protected static final String PARA_END_MARK = "endMark";
    protected static final String PARA_FILTER_MARK = "filterMark";

    @Override
    public void processSend(Map<String, Object> context, AbstractRequest request) throws Exception {
        byte[] bsend = ByteTools.getBytes(context.get("sendVar"));
        if (bsend == null) {
            throw new ComponentException("\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getRequestType() == 1) {
            StreamRequest req = (StreamRequest)request;
            req.getSocketWrapper().getBos().write(bsend);
            req.getSocketWrapper().getBos().flush();
            String closeSndChannel = "true";
            if ("true".equals(closeSndChannel)) {
                req.getSocketWrapper().getSocket().shutdownOutput();
            }
        } else {
            throw new ComponentException("unknow request type:" + request.getRequestType());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.toHexTable(bsend)});
        }
    }

    @Override
    public void processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        byte[] recv = null;
        AbstractInAdapter adapter = (AbstractInAdapter)request.getInAdapter();
        if (request.getRequestType() == 1) {
            StreamRequest req = (StreamRequest)request;
            if (null != adapter) {
                if (!(adapter.getStrategy() instanceof DefaultMappingStrategy)) {
                    this.processMapping(context, request, null);
                } else {
                    byte[] bLength = SocketTools.readInputStream((InputStream)req.getSocketWrapper().getBis(), Integer.parseInt("6"));
                    String length = new String(bLength, "UTF-8");
                    logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), 6, StringTools.toHexTable(bLength)});
                    context.put("REQ_MSG_LENGTH", length);
                }
            }
            Object endObject = context.get(PARA_END_MARK);
            byte[] endMarkBt = null;
            if (endObject != null) {
                String inputEndMark = StringTools.getString(endObject);
                if (inputEndMark.startsWith("0x") || inputEndMark.startsWith("0X")) {
                    inputEndMark = inputEndMark.substring(2);
                    endMarkBt = StringTools.string2Byte(inputEndMark);
                } else {
                    endMarkBt = inputEndMark.getBytes();
                }
            }
            if (endMarkBt == null || endMarkBt.length == 0) {
                recv = SocketTools.readInputStreamInBuffer(req.getSocketWrapper().getBis());
            } else {
                boolean bfm = true;
                String sfm = StringTools.getString(context.get(PARA_FILTER_MARK));
                bfm = Boolean.valueOf(sfm);
                recv = SocketTools.readInputStream(req.getSocketWrapper().getBis(), endMarkBt, !bfm);
            }
        } else {
            throw new ComponentException("unknow request type:" + request.getRequestType());
        }
        int len = recv.length;
        OgnlTools.setValue("recvVar", recv, context);
        if (logger.isInfoEnabled()) {
            logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), len, StringTools.toHexTable(recv)});
        }
    }

    @Override
    public void processExch(Map<String, Object> context, AbstractRequest request) throws Exception {
        this.processSend(context, request);
        this.processRecv(context, request);
    }

    @Override
    public void processMapping(Map<String, Object> context, AbstractRequest request, Map<String, String> headers) throws Exception {
        Session session = (Session)context.get("T_SESSION");
        AbstractInAdapter adapter = (AbstractInAdapter)request.getInAdapter();
        if (request.getInAdapter() != null) {
            String mappingId = adapter.getStrategy().calcMappingId(request, headers);
            MappingParam mappingParam = ResourcePortal.getInstance().getMappingRegistry().fetchMappingParam(adapter.getBeanName() + mappingId);
            if (mappingParam == null) {
                throw new Exception("\u6570\u636e\u6620\u5c04[" + mappingId + "]\u4e0d\u5b58\u5728");
            }
            session.setMappingParam(mappingParam);
            context.putAll(BeanUtils.describe((Object)mappingParam));
        }
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
}

