/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.mapping.DefaultMappingStrategy;
import cn.com.yusys.yusp.bsp.workflow.mapping.MappingParam;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComm
implements IComm,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String COMM_ATTRIBUTE_URI = "uri";
    protected static final String COMM_ATTRIBUTE_METHOD = "method";
    protected static final String COMM_ATTRIBUTE_MODE = "contentType";
    protected static final String COMM_ATTRIBUTE_SOAPACTION = "soapAction";
    private static final String COMM_ATTRIBUTE_USERAGENT = "userAgent";
    protected static final String COMM_ATTRIBUTE_RECEIVE_HEAD = "recvHead";
    protected static final String COMM_ATTRIBUTE_SEND_HEAD = "sendHead";
    protected static final String HTTP_HEADER_SOAPACTION = "SoapAction";
    protected static final String DEFAULT_VALUE_CONTENT_TYPE = "text/xml; charset=UTF-8";
    protected HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
    HttpService httpService = null;
    protected volatile HttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
    protected static final String HTTP_REQUEST_METHOD_POST = "POST";
    protected static final String HTTP_REQUEST_METHOD_GET = "GET";
    public static final String PARA_CHUNKED_FLAG = "chunkedFlag";
    private static final String BSPBIS = "_BSPBIS";
    protected static final String PARA_TIMEOUT = "timeout";
    protected String unitName = null;
    private String method;
    private String contentType;

    @Override
    public void processSend(Map<String, Object> context, AbstractRequest request) throws Exception {
        HttpResponse httpResponse;
        HttpContext httpContext = (HttpContext)context.remove("T_HTTP_CONTEXT");
        if (httpContext == null) {
            throw new ComponentException("HttpContext\u5bf9\u8c61\u5728context\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u5148\u4f7f\u7528Http\u901a\u8baf\u7ec4\u4ef6\u63a5\u6536");
        }
        String contentType = StringTools.getString(context.get(COMM_ATTRIBUTE_MODE));
        HttpParams httpParams = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpServerProcessor();
        DefaultConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
        DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
        if (!conn.isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                conn.bind(socket, httpParams);
            }
        }
        if ((httpResponse = (HttpResponse)httpContext.getAttribute("http.response")) == null) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, httpContext);
            httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
        }
        Object obj = context.get(COMM_ATTRIBUTE_SEND_HEAD);
        Map<Object, Object> headers = new HashMap();
        if (obj != null) {
            if (obj instanceof Map) {
                headers = (Map)obj;
            } else {
                this.logger.debug("{} @ \u53d1\u9001\u62a5\u6587\u5934\u4e0d\u4e3aMap:{}", new Object[]{this.getUnitName(), obj});
                headers = StringTools.string2Map(StringTools.getString(obj));
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            httpResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        byte[] bsend = ByteTools.getBytes(context.get("sendVar"), HttpProtocolParams.getContentCharset((HttpParams)httpParams));
        if (bsend != null) {
            int dataLen = bsend.length;
            InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bsend), (long)dataLen);
            if (this.logger.isInfoEnabled()) {
                if (VarDef.LOGMESSAGE) {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.toHexTable(bsend, HttpProtocolParams.getContentCharset((HttpParams)httpParams))});
                } else {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), bsend.length});
                }
            }
            httpResponse.setEntity((HttpEntity)entity);
            String flag = StringTools.getString(context.get(PARA_CHUNKED_FLAG));
            if (!StringTools.isEmpty(flag) && "true".equals(flag)) {
                entity.setChunked(true);
            }
            entity.setContentType(contentType);
            httpProc.process(httpResponse, httpContext);
        }
        conn.sendResponseHeader(httpResponse);
        conn.sendResponseEntity(httpResponse);
        conn.flush();
        if (!connStrategy.keepAlive(httpResponse, httpContext)) {
            conn.close();
        }
    }

    @Override
    public void processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        DefaultHttpServerConnection conn;
        String contentType = StringTools.getString(context.get(COMM_ATTRIBUTE_MODE));
        HttpParams httpParams = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpServerProcessor();
        BasicHttpContext httpContext = new BasicHttpContext(null);
        Object datasourceWrapper = request.getDatasourceWrapper();
        SocketWrapper socketWrapper = null;
        if (datasourceWrapper instanceof SocketWrapper) {
            socketWrapper = (SocketWrapper)datasourceWrapper;
            httpParams.setParameter(BSPBIS, (Object)socketWrapper.getBis());
        }
        if (!(conn = new DefaultHttpServerConnection()).isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                if (httpParams.getParameter("http.socket.timeout") == null) {
                    httpParams.setIntParameter("http.socket.timeout", socket.getSoTimeout());
                }
                conn.bind(socket, httpParams);
            }
        }
        httpContext.setAttribute("http.connection", (Object)conn);
        HttpResponse httpResponse = null;
        try {
            HttpRequest httpRequest = conn.receiveRequestHeader();
            ProtocolVersion ver = httpRequest.getRequestLine().getProtocolVersion();
            if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)httpRequest).expectContinue()) {
                    httpResponse = this.responseFactory.newHttpResponse(ver, 100, (HttpContext)httpContext);
                    httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
                    if (httpResponse.getStatusLine().getStatusCode() < 200) {
                        conn.sendResponseHeader(httpResponse);
                        conn.flush();
                        httpResponse = null;
                        conn.receiveRequestEntity((HttpEntityEnclosingRequest)httpRequest);
                    }
                } else {
                    conn.receiveRequestEntity((HttpEntityEnclosingRequest)httpRequest);
                }
            }
            if (httpResponse == null) {
                httpResponse = this.responseFactory.newHttpResponse(ver, 200, (HttpContext)httpContext);
                httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
            }
            httpContext.setAttribute("http.request", (Object)httpRequest);
            httpContext.setAttribute("http.response", (Object)httpResponse);
            httpProc.process(httpRequest, (HttpContext)httpContext);
            context.put("T_HTTP_CONTEXT", httpContext);
            Map<String, String> headers = this.parserHeader((HttpMessage)httpRequest);
            AbstractInAdapter adapter = (AbstractInAdapter)request.getInAdapter();
            if (null != adapter && !(adapter.getStrategy() instanceof DefaultMappingStrategy)) {
                this.processMapping(context, request, headers);
            }
            context.put(COMM_ATTRIBUTE_RECEIVE_HEAD, headers);
            this.logHeader(httpRequest);
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                byte[] data = EntityUtils.toByteArray((HttpEntity)((HttpEntityEnclosingRequest)httpRequest).getEntity());
                context.put("recvVar", data);
                if (this.logger.isInfoEnabled()) {
                    if (VarDef.LOGMESSAGE) {
                        this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), data.length, StringTools.toHexTable(data, HttpProtocolParams.getContentCharset((HttpParams)httpParams))});
                    } else {
                        this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), data.length});
                    }
                }
                HttpEntity entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                EntityUtils.consume((HttpEntity)entity);
            } else {
                int index;
                RequestLine requestLine = httpRequest.getRequestLine();
                String uri = requestLine.getUri();
                context.put("recvVar", uri);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ \u8bf7\u6c42\u7684URL:{}", new Object[]{this.getUnitName(), requestLine});
                }
                if ((index = uri.indexOf("?")) != -1) {
                    String subStr = uri.substring(index + 1);
                    String[] params = StringUtils.split((String)subStr, (String)"&");
                    HashMap<String, String> para = new HashMap<String, String>();
                    for (String str : params) {
                        String[] temp = StringUtils.split((String)str, (String)"=");
                        if (temp.length == 1) {
                            para.put(temp[0], "");
                            continue;
                        }
                        if (temp.length != 2) continue;
                        para.put(temp[0], temp[1]);
                    }
                    headers.putAll(para);
                    this.logParams(para, COMM_ATTRIBUTE_SEND_HEAD);
                }
            }
        }
        catch (HttpException e) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)httpContext);
            httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
            this.handleException(e, httpResponse);
            httpProc.process(httpResponse, (HttpContext)httpContext);
            conn.sendResponseHeader(httpResponse);
            conn.sendResponseEntity(httpResponse);
            conn.flush();
            throw e;
        }
    }

    @Override
    public void processExch(Map<String, Object> context, AbstractRequest request) throws Exception {
        String contentType;
        String method;
        String uri = StringTools.getString(context.get(COMM_ATTRIBUTE_URI));
        if (StringTools.isEmpty(uri)) {
            uri = "/";
        }
        if (StringTools.isEmpty(method = StringTools.getString(context.get(COMM_ATTRIBUTE_METHOD)))) {
            method = HTTP_REQUEST_METHOD_POST;
        }
        if (StringTools.isEmpty(contentType = StringTools.getString(context.get(COMM_ATTRIBUTE_MODE)))) {
            contentType = DEFAULT_VALUE_CONTENT_TYPE;
        }
        String soapAction = StringTools.getString(context.get(COMM_ATTRIBUTE_SOAPACTION));
        Object obj = context.get(COMM_ATTRIBUTE_SEND_HEAD);
        Map<String, String> headers = new HashMap<String, String>();
        if (obj != null) {
            if (obj instanceof Map) {
                headers = (Map)obj;
            } else {
                this.logger.debug("{} @ \u53d1\u9001\u62a5\u6587\u5934\u4e0d\u4e3aMap[{}]:{}", new Object[]{this.getUnitName(), COMM_ATTRIBUTE_SEND_HEAD, obj});
                headers = StringTools.string2Map(obj.toString());
            }
        }
        if (soapAction != null) {
            headers.put(HTTP_HEADER_SOAPACTION, soapAction);
        }
        HttpParams params = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpClientProcessor();
        BasicHttpContext httpContext = new BasicHttpContext(null);
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        DefaultConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
        httpContext.setAttribute("http.connection", (Object)conn);
        if (!conn.isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                if (params.getParameter("http.socket.timeout") == null) {
                    params.setIntParameter("http.socket.timeout", socket.getSoTimeout());
                }
                conn.bind(socket, params);
            }
        }
        HttpHost host = new HttpHost(conn.getRemoteAddress().getHostAddress(), conn.getRemotePort());
        httpContext.setAttribute("http.connection", (Object)conn);
        httpContext.setAttribute("http.target_host", (Object)host);
        BasicHttpEntityEnclosingRequest httpRequest = null;
        StringEntity httpEntity = null;
        if (HTTP_REQUEST_METHOD_POST.equals(method)) {
            httpRequest = new BasicHttpEntityEnclosingRequest(HTTP_REQUEST_METHOD_POST, uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
            Object valueObj = context.get("sendVar");
            if (valueObj instanceof String) {
                httpEntity = new StringEntity((String)valueObj, HttpProtocolParams.getContentCharset((HttpParams)params));
            } else if (valueObj instanceof byte[]) {
                httpEntity = new ByteArrayEntity((byte[])valueObj);
            }
            ((AbstractHttpEntity)httpEntity).setContentType(contentType);
            httpRequest.setEntity((HttpEntity)httpEntity);
        } else if (HTTP_REQUEST_METHOD_GET.equals(method)) {
            httpRequest = new BasicHttpRequest(HTTP_REQUEST_METHOD_GET, uri);
        }
        httpRequest.setHeaders(this.buildHeader(headers));
        httpRequest.setParams(params);
        this.httpexecutor.preProcess((HttpRequest)httpRequest, httpProc, (HttpContext)httpContext);
        this.logHeader((HttpRequest)httpRequest);
        if (this.logger.isInfoEnabled()) {
            if (VarDef.LOGMESSAGE) {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), "sendVar", httpEntity == null ? "" : EntityUtils.toString((HttpEntity)httpEntity)});
            } else {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), "sendVar"});
            }
        }
        HttpResponse httpResponse = this.httpexecutor.execute((HttpRequest)httpRequest, (HttpClientConnection)conn, (HttpContext)httpContext);
        httpResponse.setParams(params);
        this.httpexecutor.postProcess(httpResponse, httpProc, (HttpContext)httpContext);
        headers = this.parserHeader((HttpMessage)httpResponse);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new ComponentException("\u8fd4\u56de\u72b6\u6001\u9519\u8bef:" + httpResponse + "\n" + EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
        }
        context.put(COMM_ATTRIBUTE_RECEIVE_HEAD, headers);
        this.logHeader(httpResponse);
        HttpEntity responseEntity = httpResponse.getEntity();
        if (responseEntity != null) {
            byte[] rspData = EntityUtils.toByteArray((HttpEntity)responseEntity);
            context.put("recvVar", rspData);
            if (this.logger.isInfoEnabled()) {
                if (VarDef.LOGMESSAGE) {
                    String charset = EntityUtils.getContentCharSet((HttpEntity)responseEntity);
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    this.logger.info("{} @ \u8fd4\u56de\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), "recvVar", StringTools.toHexTable(rspData, charset)});
                } else {
                    this.logger.info("{} @ \u8fd4\u56de\u6570\u636e[{}],\u62a5\u6587\u6570\u636e\u4e0d\u4e88\u8bb0\u5f55!", new Object[]{this.getUnitName(), "recvVar"});
                }
            }
        }
        if (!connStrategy.keepAlive(httpResponse, (HttpContext)httpContext)) {
            request.setCloseFlag(true);
        }
    }

    @Override
    public void processMapping(Map<String, Object> context, AbstractRequest request, Map<String, String> headers) throws Exception {
        Session session = (Session)context.get("T_SESSION");
        if (request.getInAdapter() != null) {
            AbstractInAdapter adapter = (AbstractInAdapter)request.getInAdapter();
            String mappingId = adapter.getStrategy().calcMappingId(request, headers);
            MappingParam mappingParam = ResourcePortal.getInstance().getMappingRegistry().fetchMappingParam(adapter.getBeanName() + mappingId);
            if (mappingParam == null) {
                throw new Exception("\u6570\u636e\u6620\u5c04[" + mappingId + "]\u4e0d\u5b58\u5728");
            }
            session.setMappingParam(mappingParam);
            context.putAll(BeanUtils.describe((Object)mappingParam));
            context.put(PARA_CHUNKED_FLAG, adapter.getChunkedFlag());
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    protected Map<String, String> parserHeader(HttpMessage httpMessage) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpMessage;
            map.put(COMM_ATTRIBUTE_METHOD, req.getRequestLine().getMethod());
            map.put(COMM_ATTRIBUTE_URI, req.getRequestLine().getUri());
            map.put("protocol", req.getRequestLine().getProtocolVersion().getProtocol());
        }
        for (Header h : httpMessage.getAllHeaders()) {
            map.put(h.getName(), h.getValue());
        }
        return map;
    }

    private void logParams(Map<String, String> map, String headkey) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append(headkey + "." + key);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
            this.logger.debug(sb.toString());
        }
    }

    protected void logHeader(HttpRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ \u8bf7\u6c42HTTP\u5934:\n{}", (Object)this.getUnitName(), (Object)request);
        }
    }

    protected void logHeader(HttpResponse response) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ \u8fd4\u56deHTTP\u5934:\n{}", (Object)this.getUnitName(), (Object)response);
        }
    }

    protected Header[] buildHeader(Map<String, String> headers) {
        Header[] heads = new Header[headers.size()];
        int i = 0;
        for (String key : headers.keySet()) {
            BasicHeader head = new BasicHeader(key, headers.get(key));
            heads[i] = head;
            ++i;
        }
        return heads;
    }

    protected HttpParams getHttpParams(String contentType, Map<String, Object> context) throws Exception {
        NameValuePair param;
        BasicHeader header;
        HeaderElement[] values;
        String charset = "UTF-8";
        if (contentType != null && (values = (header = new BasicHeader("Content-Type", contentType)).getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)charset);
        String userAgent = StringTools.getString(context.get(COMM_ATTRIBUTE_USERAGENT));
        if (userAgent == null || userAgent.length() == 0) {
            userAgent = "BSP-HttpClient/1.1";
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        params.setParameter("http.origin-server", (Object)"BSP-HttpServer/1.1");
        String _timeout = StringTools.getString(context.get(PARA_TIMEOUT));
        if (Integer.parseInt(_timeout) > 0) {
            params.setIntParameter("http.socket.timeout", Integer.parseInt(_timeout));
        }
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true);
        params.setIntParameter("http.connection.timeout", 10000);
        return params;
    }

    protected HttpProcessor getHttpClientProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(), new RequestDate()});
        return httpProc;
    }

    protected HttpProcessor getHttpServerProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseContent(), new ResponseConnControl(), new ResponseServer(), new ResponseDate()});
        return httpProc;
    }

    protected void handleException(HttpException ex, HttpResponse response) throws UnsupportedEncodingException {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        byte[] msg = ByteTools.getBytes(StringTools.printExceptionStackTrace(ex), "UTF-8");
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=UTF-8");
        response.setEntity((HttpEntity)entity);
    }
}

