/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;

public class CastorTools {
    public static final String ENCODING_UTF8 = "utf-8";

    public static Object unmarshaller(String filename, Class<?> clazzObject, ClassLoader classLoader) throws Exception {
        return CastorTools.unmarshaller(new File(filename), clazzObject, classLoader);
    }

    public static Object unmarshaller(File file, Class<?> clazzObject, ClassLoader classLoader) throws Exception {
        Reader r = null;
        Object object = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_UTF8);
            Unmarshaller unmarshaller = new Unmarshaller(clazzObject);
            if (classLoader != null) {
                unmarshaller.getInternalContext().setClassLoader(classLoader);
            }
            object = unmarshaller.unmarshal(r);
        }
        catch (Exception e) {
            throw new Exception("unmarshaller\u6587\u4ef6\u5f02\u5e38:" + file.getAbsolutePath(), e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshaller(InputStream inputStream, Class<?> clazzObject) throws Exception {
        InputStreamReader r = null;
        Object object = null;
        try {
            r = new InputStreamReader(inputStream, ENCODING_UTF8);
            Unmarshaller unmarshaller = new Unmarshaller(clazzObject);
            object = unmarshaller.unmarshal((Reader)r);
        }
        finally {
            if (r != null) {
                try {
                    ((Reader)r).close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshaller(Object topObject, ClassLoader classLoader) throws Exception {
        String xmlConent = null;
        StringWriter w = new StringWriter();
        try {
            Marshaller marshaller = new Marshaller((Writer)w);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.setEncoding(ENCODING_UTF8);
            marshaller.marshal(topObject);
            xmlConent = w.toString();
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException iOException) {}
        }
        return xmlConent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshaller(Object topObject, boolean isFormat, ClassLoader classLoader) throws Exception {
        if (!isFormat) {
            return CastorTools.marshaller(topObject, classLoader);
        }
        String xmlConent = null;
        StringWriter w = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", ENCODING_UTF8, true);
            XMLSerializer serializer = new XMLSerializer((Writer)w, format);
            DocumentHandler handler = serializer.asDocumentHandler();
            Marshaller marshaller = new Marshaller(handler);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.marshal(topObject);
            xmlConent = w.toString();
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException iOException) {}
        }
        return xmlConent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] marshaller2Byte(Object topObject, ClassLoader classLoader) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, ENCODING_UTF8);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.marshal(topObject);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                    outputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void marshaller(Object topObject, String targetFilePath, ClassLoader classLoader) throws Exception {
        CastorTools.marshaller(topObject, new File(targetFilePath), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshaller(Object topObject, File targetFile, ClassLoader classLoader) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), ENCODING_UTF8);
        try {
            OutputFormat format = new OutputFormat("xml", ENCODING_UTF8, true);
            XMLSerializer serializer = new XMLSerializer((Writer)fw, format);
            DocumentHandler handler = serializer.asDocumentHandler();
            Marshaller marshaller = new Marshaller(handler);
            if (classLoader == null) {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                marshaller.getInternalContext().getXMLClassDescriptorResolver().setClassLoader(classLoader);
            }
            marshaller.marshal(topObject);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void genSourceCode(String dir, String schemaFile, String packageName) throws IOException {
        SourceGenerator generator = new SourceGenerator();
        generator.setDestDir(dir);
        generator.setDescriptorCreation(true);
        generator.setCreateMarshalMethods(false);
        generator.generateSource(schemaFile, packageName);
    }

    public static String formatXML(Reader reader) throws IOException {
        try {
            Document document = CastorTools.parseXmlFile(reader);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Document parseXmlFile(Reader reader) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return db.parse(is);
    }
}

