/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class StringTools {
    private static final String CHAR_SPACE = " ";
    private static final String DOT_16 = "................";
    public static final String defaultCharset = System.getProperty("file.encoding", "UTF-8");
    private static final char CHAR_BLANK = ' ';
    private static final char CHAR_ZERROR = '0';
    private static final String STR_COLON = ": ";
    private static final char CHAR_SEMICOLON = ';';
    private static final char CHAR_DOT = '.';
    private static final String STR_EMPTY = "";
    private static final char CHAR_NEWLINE = '\n';
    public static final int MAX_OUTPUT_LENGTH_SINGLE_VAR = 10240;
    public static final int MAX_LIMIT_LENGTH = 38912;
    public static final String CHARSET_GBK = "GBK";
    public static final String CHARSET_GB2312 = "GB2312";
    public static final String CHARSET_GB18030 = "GB18030";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_UTF8 = "UTF8";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int ALL = 3;
    public static final String BLANK = "";
    public static final boolean G_PRINTHEX = Boolean.valueOf(System.getProperty("printHex", "true"));

    public static String byte2String(byte[] data) {
        return StringTools.byte2String(data, false);
    }

    public static String byte2String(byte[] data, boolean lowercase) {
        if (data == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String tmpStr = Integer.toHexString(data[i] & 0xFF);
            tmpStr = StringUtils.leftPad((String)tmpStr, (int)2, (char)'0');
            builder.append(tmpStr);
        }
        if (!lowercase) {
            return StringUtils.upperCase((String)builder.toString());
        }
        return builder.toString();
    }

    public static byte[] escString2Byte(String strData) throws NumberFormatException {
        byte[] srcData = strData.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int dataLength = srcData.length;
        for (int i = 0; i < dataLength; ++i) {
            if (srcData[i] == 48 && dataLength >= i + 4 && (srcData[i + 1] == 120 || srcData[i + 1] == 88)) {
                baos.write((byte)Integer.parseInt(new String(srcData, i + 2, 2), 16));
                i += 3;
                continue;
            }
            if (srcData[i] == 92) {
                if (i + 1 < dataLength) {
                    if (srcData[i + 1] == 114) {
                        baos.write(13);
                    } else if (srcData[i + 1] == 116) {
                        baos.write(9);
                    } else if (srcData[i + 1] == 110) {
                        baos.write(10);
                    } else if (srcData[i + 1] == 98) {
                        baos.write(8);
                    } else if (srcData[i + 1] == 102) {
                        baos.write(12);
                    } else if (srcData[i + 1] == 39) {
                        baos.write(39);
                    } else if (srcData[i + 1] == 34) {
                        baos.write(34);
                    } else if (srcData[i + 1] == 92) {
                        baos.write(92);
                    } else if (srcData[i + 1] == 48) {
                        baos.write(0);
                    } else {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff1a[" + strData + "]");
                    }
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff1a[" + strData + "]");
            }
            baos.write(srcData[i]);
        }
        return baos.toByteArray();
    }

    public static String exception2String(Exception e) {
        if (e == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(os));
        byte[] msg = os.toByteArray();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(msg);
    }

    public static String fillStr(String source, char cIn, int len) {
        return StringTools.fillStr(source, cIn, len, 2);
    }

    public static String fillStr(String source, char cIn, int len, int align) {
        return StringTools.fillStr(source, StringTools.getString(Character.valueOf(cIn)), len, align);
    }

    public static String fillStr(String source, int len) {
        return StringTools.fillStr(source, CHAR_SPACE, len, 2);
    }

    public static String fillStr(String source, int len, int align) {
        return StringTools.fillStr(source, CHAR_SPACE, len, align);
    }

    public static String fillStr(String source, String sIn, int len, int align) {
        if (source == null || sIn == null) {
            return source;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (source.getBytes().length < len) {
            if (align == 0) {
                stringBuilder.append(source).append(StringTools.getBlankStr(sIn, len - source.getBytes().length));
            } else if (align == 1) {
                int iTmp = (len - source.getBytes().length) / 2;
                stringBuilder.append(StringTools.getBlankStr(sIn, iTmp)).append(source).append(StringTools.getBlankStr(sIn, len - source.getBytes().length - iTmp));
            } else if (align == 2) {
                stringBuilder.append(StringTools.getBlankStr(sIn, len - source.getBytes().length)).append(source);
            } else {
                stringBuilder.append(source);
            }
        } else {
            stringBuilder.append(source);
        }
        return stringBuilder.toString();
    }

    public static String getBlankStr(char cIn, int iLen) {
        return StringTools.getBlankStr(StringTools.getString(Character.valueOf(cIn)), iLen);
    }

    public static String getBlankStr(int iLen) {
        return StringTools.getBlankStr(CHAR_SPACE, iLen);
    }

    public static String getBlankStr(String sIn, int iLen) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringTools.isEmpty(sIn)) {
            sIn = CHAR_SPACE;
        }
        while (stringBuilder.length() < iLen) {
            stringBuilder.append(sIn);
        }
        return stringBuilder.toString();
    }

    public static Integer getInt(Object obj) throws Exception {
        if (obj == null) {
            throw new Exception("\u503c\u4e3anull");
        }
        int i_obj = obj instanceof Integer ? (Integer)obj : (obj instanceof String ? Integer.parseInt((String)obj) : (obj instanceof byte[] ? Integer.parseInt(new String((byte[])obj)) : (obj instanceof Byte ? (Byte)obj & 0xFF : (obj instanceof Short ? (int)((Short)obj).shortValue() : (obj instanceof Long ? ((Long)obj).intValue() : (obj instanceof Double ? ((Double)obj).intValue() : Integer.parseInt(obj.toString())))))));
        return i_obj;
    }

    public static String getString(Object obj) {
        try {
            return StringTools.getString(obj, defaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getString(Object obj, String charset) throws UnsupportedEncodingException {
        if (obj == null || obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj, charset);
        }
        return obj.toString();
    }

    private static String hex2String(byte[] hex, String charset) {
        int length = hex.length;
        StringBuilder sb = new StringBuilder(32);
        try {
            for (int j = 0; j < length; ++j) {
                char ch1 = (char)hex[j];
                if (ch1 <= ' ') {
                    ch1 = '.';
                } else if (ch1 > '\u0080') {
                    char ch2;
                    if (charset.equalsIgnoreCase(CHARSET_GB2312) && j + 1 <= length - 1) {
                        ch2 = (char)hex[j + 1];
                        if ((byte)ch1 > -80 && (byte)ch1 < -9 && (byte)ch2 > -96 && (byte)ch2 < -16) {
                            sb.append(new String(hex, j, 2, charset));
                            ++j;
                            continue;
                        }
                    }
                    if (charset.equalsIgnoreCase(CHARSET_GBK) || charset.equalsIgnoreCase(CHARSET_GB18030)) {
                        if (j + 1 <= length - 1) {
                            ch2 = (char)hex[j + 1];
                            if ((byte)ch1 >= -127 && (byte)ch1 <= -2 && ((byte)ch2 & 0xFF) >= 64 && (byte)ch2 <= -2) {
                                sb.append(new String(hex, j, 2, charset));
                                ++j;
                                continue;
                            }
                        }
                    } else if ((charset.equalsIgnoreCase(CHARSET_UTF8) || charset.equalsIgnoreCase(CHARSET_UTF_8)) && j + 2 <= length - 1) {
                        ch2 = (char)hex[j + 1];
                        char ch3 = (char)hex[j + 2];
                        if ((byte)ch1 >= -32 && (byte)ch2 >= -128) {
                            String tmpStr = "";
                            if ((byte)ch3 >= -128) {
                                tmpStr = new String(hex, j, 3, charset);
                                j += 2;
                            } else {
                                tmpStr = new String(hex, j, 2, charset);
                                ++j;
                            }
                            sb.append(tmpStr);
                            continue;
                        }
                    }
                }
                sb.append(ch1);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static byte[] hexTableString2Byte(String srcData) throws Exception {
        if (srcData == null) {
            return null;
        }
        int hexStartIndex = 0;
        if (srcData.indexOf(32) == 4) {
            hexStartIndex = 6;
        }
        String[] lineStrArray = StringUtils.split((String)srcData, (char)'\n');
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lineStrArray.length; ++i) {
            int hexEndIndex = StringUtils.indexOf((CharSequence)lineStrArray[i], (int)59);
            String hexPart = StringUtils.substring((String)lineStrArray[i], (int)hexStartIndex, (int)(hexEndIndex - 1));
            String[] byte2StringArray = StringUtils.split((String)hexPart, (char)' ');
            for (int j = 0; j < byte2StringArray.length; ++j) {
                builder.append(byte2StringArray[j]);
            }
        }
        return StringTools.string2Byte(builder.toString());
    }

    public static boolean isEmpty(String src) {
        return src == null || src.length() == 0;
    }

    public static void main(String[] args) throws Throwable {
        long max = 4L;
        String s = "1";
        int i = 0;
        while ((long)i < max) {
            s = s + "\u4e2d\u6587";
            ++i;
        }
        System.out.println(s);
        System.out.println(StringTools.toHexTable(s.getBytes()));
        System.out.println(StringTools.toHexTable(StringTools.escString2Byte("\\00x33\\r\\t")));
        byte[] b = new byte[]{-106, -121, -28, -72, -83};
        char c = (char)b[0];
        System.out.println((byte)c > -32);
        String str = "AAAA3F";
        byte[] b2 = StringTools.string2Byte(str);
        System.out.println(StringTools.toHexTable(b2));
        str = "asdfkljjkl;;;;;";
        System.out.println(StringTools.byte2String(b2));
    }

    public static String printExceptionStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(writer);
            t.printStackTrace(printWriter);
            printWriter.flush();
        }
        return writer.toString();
    }

    public static String replace(String source, String from, String to) {
        if (StringTools.isEmpty(source) || StringTools.isEmpty(from) || to == null) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source);
        Stack<String> stack = new Stack<String>();
        int index = source.indexOf(from);
        while (index >= 0) {
            stack.push(String.valueOf(index));
            index = source.indexOf(from, index + from.length());
        }
        while (!stack.empty()) {
            index = Integer.parseInt(((String)stack.pop()).toString());
            sb.replace(index, index + from.length(), to);
        }
        return sb.toString();
    }

    public static String[] split(String source, String s) {
        if (StringTools.isEmpty(source)) {
            return null;
        }
        return StringUtils.split((String)source, (String)s);
    }

    public static byte[] string2Byte(String srcData) throws Exception {
        if (srcData == null) {
            return null;
        }
        if (srcData.length() % 2 != 0) {
            throw new Exception("\u6e90\u6570\u636e\u7684\u957f\u5ea6\u4e3a\u5947\u6570:" + srcData.length());
        }
        int len = srcData.length() / 2;
        byte[] newData = new byte[len];
        for (int i = 0; i < len; ++i) {
            newData[i] = (byte)(Character.digit(srcData.charAt(i * 2), 16) << 4 ^ Character.digit(srcData.charAt(i * 2 + 1), 16));
        }
        return newData;
    }

    public static Map<String, String> string2Map(String mapStr) {
        String[] entrys;
        HashMap<String, String> map = new HashMap<String, String>();
        String split = ",";
        for (String entry : entrys = mapStr.split(split)) {
            int index = entry.indexOf("=");
            if (index == -1) continue;
            String key = entry.substring(0, index);
            String value = entry.substring(index + 1);
            map.put(key, value);
        }
        return map;
    }

    public static String toHexString(byte[] bt) {
        return StringTools.byte2String(bt);
    }

    public static String toHexTable(byte[] data) {
        if (!G_PRINTHEX) {
            return StringTools.printStr(data, defaultCharset);
        }
        return StringTools.toHexTable(data, defaultCharset);
    }

    public static String printStr(byte[] data, String charset) {
        try {
            if (StringTools.isEmpty(charset)) {
                charset = defaultCharset;
            }
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String toHexTable(byte[] data, int numOfLine, int column) {
        if (!G_PRINTHEX) {
            return StringTools.printStr(data, defaultCharset);
        }
        return StringTools.toHexTable(data, numOfLine, column, defaultCharset);
    }

    public static String toHexTable(byte[] data, int numOfLine, int outputColumn, String charset) {
        if (data == null) {
            return null;
        }
        if (!G_PRINTHEX) {
            return StringTools.printStr(data, charset);
        }
        StringBuilder builder = new StringBuilder(2048);
        int lines = data.length % numOfLine == 0 ? data.length / numOfLine : data.length / numOfLine + 1;
        int columnLeft = outputColumn & 4;
        int columnMid = outputColumn & 2;
        int columnRight = outputColumn & 1;
        for (int i = 0; i < lines; ++i) {
            if (columnLeft == 4) {
                String lineCountPart = String.valueOf(i);
                lineCountPart = StringUtils.leftPad((String)lineCountPart, (int)4, (char)'0');
                builder.append(lineCountPart);
                builder.append(STR_COLON);
            }
            int length = data.length - i * numOfLine > numOfLine ? numOfLine : data.length - i * numOfLine;
            byte[] hexPartArray = new byte[length];
            System.arraycopy(data, i * numOfLine, hexPartArray, 0, length);
            if (columnMid == 2) {
                StringBuilder hsb = new StringBuilder();
                for (int j = 0; j < length; ++j) {
                    String tmpStr = StringUtils.leftPad((String)Integer.toHexString(hexPartArray[j] & 0xFF), (int)2, (char)'0');
                    hsb.append(tmpStr);
                    if (j >= numOfLine - 1) continue;
                    hsb.append(' ');
                }
                String hexPart = StringUtils.rightPad((String)hsb.toString(), (int)47, (char)' ');
                builder.append(hexPart);
                builder.append(';');
                builder.append(' ');
            }
            if (columnRight == 1) {
                builder.append(StringTools.hex2String(hexPartArray, charset));
            }
            if (i == lines - 1) break;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String toHexTable(byte[] data, String charset) {
        if (!G_PRINTHEX) {
            return StringTools.printStr(data, charset);
        }
        if (data.length <= 38912) {
            return StringTools.toHexTable(data, 16, 7, charset);
        }
        byte[] outData = new byte[38928];
        System.arraycopy(data, 0, outData, 0, 38912);
        System.arraycopy((data.length + DOT_16).getBytes(), 0, outData, 38912, 16);
        return StringTools.toHexTable(outData, 16, 7, charset);
    }

    public static String toLimitString(String srcData) {
        return StringTools.toLimitString(srcData, 38912);
    }

    protected static String toLimitString(String srcData, int maxLen) {
        if (maxLen == -1 || srcData.length() <= maxLen) {
            return srcData;
        }
        return srcData.substring(0, maxLen) + DOT_16;
    }

    public static byte[] escapeStringToCharArray(byte[] str) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == 10) {
                bout.write(92);
                bout.write(110);
                continue;
            }
            if (str[i] == 9) {
                bout.write(92);
                bout.write(116);
                continue;
            }
            if (str[i] == 13) {
                bout.write(92);
                bout.write(114);
                continue;
            }
            if (str[i] == 12) {
                bout.write(92);
                bout.write(102);
                continue;
            }
            if (str[i] == 0) {
                bout.write(92);
                bout.write(48);
                continue;
            }
            if (str[i] == 34) {
                bout.write(92);
                bout.write(34);
                continue;
            }
            if (str[i] == 8) {
                bout.write(92);
                bout.write(98);
                continue;
            }
            if (str[i] == 92) {
                bout.write(92);
                bout.write(92);
                continue;
            }
            bout.write(str[i]);
        }
        return bout.toByteArray();
    }
}

