/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FileTools {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static Logger logger = LoggerFactory.getLogger(FileTools.class);

    public static void appendContentToFile(String fileName, byte[] content) throws Exception {
        try (OutputStream fos = null;){
            fos = FileTools.openOutputStream(new File(fileName), true);
            fos.write(content, 0, content.length);
            fos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String srcFile, String destFile) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = FileTools.openInputStream(srcFile);
            out = FileTools.openOutputStream(new File(destFile));
            FileTools.copyStream(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static boolean fetchFileExists(String relativePath) {
        ClassPathResource resource;
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        return file.exists() || (resource = new ClassPathResource(relativePath)).exists();
    }

    public static File fetchFile(String relativePath) throws Exception {
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static InputStream fetchFileStreatm(String relativePath) throws Exception {
        File file = new File(VarDef.BSP_WORKSPACE, relativePath);
        if (!file.isFile()) {
            ClassPathResource resource = new ClassPathResource(relativePath);
            return resource.getInputStream();
        }
        return new FileInputStream(file);
    }

    public static long fetchFileLength(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileName);
        }
        return file.length();
    }

    public static byte[] fetchFileMd5(String fileName) throws Exception {
        byte[] bTemp = FileTools.readFileContent(fileName);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        byte[] md = mdTemp.digest();
        return md;
    }

    public static byte[] fetchFileMd5(File file) throws Exception {
        byte[] bTemp = FileTools.readFileContent(file);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        byte[] md = mdTemp.digest();
        return md;
    }

    public static byte[] fetchMd5(byte[] data) throws Exception {
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(data);
        byte[] md = mdTemp.digest();
        return md;
    }

    private static void findDir(File file, String rootdir, List<String> list, String[] prefix, String[] postfix, boolean containfix) {
        String[] dirList = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String dn) {
                File file = new File(dir + "/" + dn);
                return file.isDirectory();
            }
        });
        if (dirList != null) {
            for (String name : dirList) {
                String fn = null;
                fn = rootdir.endsWith("/") ? rootdir + name : rootdir + "/" + name;
                FileTools.findFileByNamefix(fn, prefix, postfix, containfix, list);
            }
        }
    }

    private static void findFile(File file, String rootdir, List<String> list, final String[] prefix, final String[] postfix, final boolean containfix) {
        if (!file.exists()) {
            return;
        }
        String[] fileList = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fn) {
                File file = new File(dir + "/" + fn);
                if (file.isDirectory()) {
                    return false;
                }
                if (containfix) {
                    boolean postfixFlag = false;
                    boolean prefixFlag = false;
                    if (postfix != null && postfix.length > 0) {
                        for (String pf : postfix) {
                            if (!fn.endsWith(pf)) continue;
                            postfixFlag = true;
                        }
                    } else {
                        postfixFlag = true;
                    }
                    if (prefix != null && prefix.length > 0) {
                        for (String pf : prefix) {
                            if (!fn.startsWith(pf)) continue;
                            prefixFlag = true;
                        }
                    } else {
                        prefixFlag = true;
                    }
                    return postfixFlag && prefixFlag;
                }
                boolean postfixFlag = true;
                boolean prefixFlag = true;
                if (postfix != null && postfix.length > 0) {
                    for (String pf : postfix) {
                        if (!fn.endsWith(pf)) continue;
                        postfixFlag = false;
                    }
                } else {
                    postfixFlag = true;
                }
                if (prefix != null && prefix.length > 0) {
                    for (String pf : prefix) {
                        if (!fn.startsWith(pf)) continue;
                        prefixFlag = false;
                    }
                } else {
                    prefixFlag = true;
                }
                return postfixFlag || prefixFlag;
            }
        });
        if (fileList != null) {
            for (String name : fileList) {
                String fName = null;
                fName = rootdir.endsWith("/") ? rootdir + name : rootdir + "/" + name;
                list.add(fName);
            }
        } else {
            logger.warn("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38,\u8def\u5f84\uff1a{}", (Object)rootdir);
        }
    }

    public static String[] findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix) {
        ArrayList<String> list = new ArrayList<String>();
        FileTools.findFileByNamefix(rootdir, prefix, postfix, containfix, list);
        return list.toArray(new String[0]);
    }

    private static void findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix, List<String> list) {
        File file = new File(rootdir);
        FileTools.findFile(file, rootdir, list, prefix, postfix, containfix);
        FileTools.findDir(file, rootdir, list, prefix, postfix, containfix);
    }

    private static void getDirList(File file, List<String> list) {
        list.add(file.getPath());
        if (file.isDirectory()) {
            File[] subFile = file.listFiles();
            for (int i = 0; i < subFile.length; ++i) {
                FileTools.getDirList(subFile[i], list);
            }
        }
    }

    public static List<String> getAllDirList(String dir) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(dir);
        if (file.exists()) {
            FileTools.getDirList(file, list);
        }
        return list;
    }

    public static int getHexValue(byte byte1, byte byte2) {
        int num = 0;
        if (byte2 == 32 || byte2 == 9 || byte2 == 10 || byte2 == 13 || byte2 == 12 || byte2 == -1) {
            String tmpStr = String.valueOf((char)byte1);
            num = Integer.parseInt(tmpStr, 16);
        } else {
            String tmpStr = String.valueOf((char)byte1) + String.valueOf((char)byte2);
            num = Integer.parseInt(tmpStr, 16);
        }
        return num;
    }

    public static InputStream openInputStream(String fileName) throws IOException {
        File file = new File(VarDef.BSP_WORKSPACE, fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
            return new FileInputStream(file);
        }
        ClassPathResource resource = new ClassPathResource(fileName);
        if (!resource.exists()) {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return resource.getInputStream();
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileTools.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static File openFileDir(String dirPath) throws IOException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            if (!dirFile.mkdirs() && !dirFile.isDirectory()) {
                throw new IOException("Directory '" + dirFile + "' could not be created");
            }
        } else if (!dirFile.isDirectory()) {
            throw new IOException("File '" + dirFile + "' exists but is not a directory");
        }
        return dirFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContent(String fileName) throws IOException {
        byte[] fileContent = null;
        InputStream fis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            fis = FileTools.openInputStream(fileName);
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContent(File file) throws IOException {
        byte[] fileContent = null;
        FileInputStream fis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            fis = FileTools.openInputStream(file);
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                ((InputStream)fis).close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readHexFile(String fileName) throws NumberFormatException, IOException {
        byte[] result = null;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            byte[] hexData = FileTools.readFileContent(fileName);
            int length = hexData.length;
            for (int i = 0; i < length; ++i) {
                int frist = hexData[i] & 0xFF;
                if (!(frist >= 97 && frist <= 102 || frist >= 46 && frist <= 57) && (frist < 65 || frist > 70)) continue;
                int second = -1;
                if (length > i + 1) {
                    second = hexData[i + 1];
                }
                if (second == 9 || second == 10 || second == 13 || second == 12 || second == 32 || second == -1) {
                    out.write(Integer.parseInt(String.valueOf((char)frist), 16));
                } else {
                    out.write(Integer.parseInt(String.valueOf((char)frist) + String.valueOf((char)second), 16));
                }
                ++i;
            }
            result = out.toByteArray();
            out.reset();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropFile(String fileName) throws Exception {
        Properties config = new Properties();
        try (InputStream in = null;){
            in = FileTools.openInputStream(fileName);
            config.load(in);
            Properties properties = config;
            return properties;
        }
    }

    public static void recursiveCopy(String srcFileName, String destFileName) throws Exception {
        FileTools.recursiveCopy(srcFileName, destFileName, false);
    }

    public static void recursiveCopy(String srcFileName, String destFileName, boolean filtrateSvn) throws Exception {
        File srcDir = new File(srcFileName);
        File destDir = new File(destFileName);
        if (!srcDir.isDirectory() || !srcDir.canRead()) {
            throw new Exception("Source directory must be a readable directory " + srcDir);
        }
        if (srcDir.equals(destDir)) {
            throw new Exception("Source and destination directory are the same " + srcDir);
        }
        destDir.mkdirs();
        if (!destDir.exists()) {
            throw new Exception("Could not create destination directory " + destDir);
        }
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (int i = 0; i < srcFiles.length; ++i) {
                File srcFile = srcFiles[i];
                File destFile = new File(destDir, srcFile.getName());
                if (srcFile.isDirectory()) {
                    if (filtrateSvn && srcFile.getName().equals(".svn")) continue;
                    FileTools.recursiveCopy(srcFile.getPath(), destFile.getPath(), filtrateSvn);
                    continue;
                }
                if (!srcFile.isFile()) continue;
                FileTools.copyFile(srcFile.getPath(), destFile.getPath());
            }
        }
    }

    public static boolean recursiveRmFile(String fileName) throws Exception {
        File[] files;
        File root = new File(fileName);
        if (!root.exists()) {
            throw new Exception("\u76ee\u5f55\u6216\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileName);
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileTools.recursiveRmFile(file.getPath());
                    continue;
                }
                FileTools.rmFile(file.getPath());
            }
        }
        return root.delete();
    }

    public static boolean renameFile(String srcFile, String destFile) throws Exception {
        File sFile = new File(srcFile);
        if (!sFile.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728:" + srcFile);
        }
        return sFile.renameTo(new File(destFile));
    }

    public static boolean rmFile(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileName);
        }
        return file.delete();
    }

    public static void writeContentToFile(String fileName, byte[] content) throws Exception {
        try (FileOutputStream fos = null;){
            fos = FileTools.openOutputStream(new File(fileName));
            ((OutputStream)fos).write(content, 0, content.length);
            fos.flush();
        }
    }
}

