/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ByteTools {
    private static final char CHAR_4 = 'x';
    private static final char CHAR_3 = ';';
    private static final char CHAR_2 = '#';
    private static final char CHAR_1 = '&';
    private static byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static byte[] digits2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] DigitOnes2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitTens2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};

    public static byte[] addBytes(byte[] srcBytes, byte[] addBytes) {
        if (srcBytes == null || addBytes == null) {
            return srcBytes;
        }
        int srcLength = srcBytes.length;
        int addLength = addBytes.length;
        byte[] retBytes = new byte[srcLength + addLength];
        System.arraycopy(srcBytes, 0, retBytes, 0, srcLength);
        System.arraycopy(addBytes, 0, retBytes, srcLength, addLength);
        return retBytes;
    }

    public static byte[] asc2Bcd(byte[] srcData) {
        int len = srcData.length;
        if (len % 2 == 1) {
            byte[] tmpArrray = new byte[len + 1];
            System.arraycopy(srcData, 0, tmpArrray, 0, len - 1);
            tmpArrray[len] = srcData[len - 1];
            srcData = tmpArrray;
        }
        int size = srcData.length / 2;
        byte[] retArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            int high = 0;
            high = srcData[2 * i] >= 97 && srcData[2 * i] <= 102 ? srcData[2 * i] - 97 + 10 : (srcData[2 * i] >= 65 && srcData[2 * i] <= 70 ? srcData[2 * i] - 65 + 10 : srcData[2 * i] & 0xF);
            int low = 0;
            low = srcData[2 * i + 1] >= 97 && srcData[2 * i + 1] <= 102 ? srcData[2 * i + 1] - 97 + 10 : (srcData[2 * i + 1] >= 65 && srcData[2 * i + 1] <= 70 ? srcData[2 * i + 1] - 65 + 10 : srcData[2 * i + 1] & 0xF);
            retArray[i] = (byte)((high << 4) + low);
        }
        return retArray;
    }

    public static byte[] asc2Bcd(byte[] srcData, int fillChar, boolean isLeft) throws Exception {
        if (srcData == null || srcData.length == 0) {
            return null;
        }
        if (srcData.length % 2 == 1) {
            byte[] ascArray = new byte[srcData.length + 1];
            byte fill = 0;
            if (fillChar >= 0 && fillChar <= 9) {
                fill = (byte)(fillChar + 48);
            } else if (fillChar >= 10 && fillChar <= 15) {
                fill = (byte)(fillChar - 10 + 97);
            } else {
                throw new Exception("\u5b57\u8282\u5de5\u5177\u7c7b @ \u586b\u5145\u5143\u7d20\u975e\u6cd5,\u5fc5\u987b\u662f0-15");
            }
            if (isLeft) {
                ascArray[0] = fill;
                System.arraycopy(srcData, 0, ascArray, 1, srcData.length);
            } else {
                System.arraycopy(srcData, 0, ascArray, 0, srcData.length);
                ascArray[ascArray.length - 1] = fill;
            }
            return ByteTools.asc2Bcd(ascArray);
        }
        return ByteTools.asc2Bcd(srcData);
    }

    public static byte[] asc2Bcd(byte[] srcData, int fillChar, boolean isLeft, int len) throws Exception {
        if (srcData == null || srcData.length == 0) {
            return null;
        }
        len = len % 2 != 0 ? len + 1 : len;
        byte[] srcBcdArray = ByteTools.asc2Bcd(srcData, fillChar, isLeft);
        if (srcData.length > len) {
            return srcBcdArray;
        }
        int fillSize = len - srcBcdArray.length * 2;
        if (fillSize > 0) {
            byte[] bcdArray = new byte[srcBcdArray.length + fillSize / 2];
            byte[] fillBcdArray = new byte[fillSize / 2];
            byte fill = (byte)(fillChar + fillChar * 16);
            for (int i = 0; i < fillSize / 2; ++i) {
                fillBcdArray[i] = fill;
            }
            if (isLeft) {
                System.arraycopy(fillBcdArray, 0, bcdArray, 0, fillBcdArray.length);
                System.arraycopy(srcBcdArray, 0, bcdArray, fillBcdArray.length, srcBcdArray.length);
            } else {
                System.arraycopy(srcBcdArray, 0, bcdArray, 0, srcBcdArray.length);
                System.arraycopy(fillBcdArray, 0, bcdArray, srcBcdArray.length, fillBcdArray.length);
            }
            return bcdArray;
        }
        return srcBcdArray;
    }

    public static byte[] bcd2Asc(byte[] srcData) {
        return ByteTools.bcd2Asc(srcData, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return null;
        }
        int length = srcData.length;
        byte[] ascArray = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            byte high;
            int bcd = srcData[i];
            if (bcd < 0) {
                bcd += 256;
            }
            high = 0 <= (high = (byte)(bcd >>> 4)) && high <= 9 ? (byte)(high + 48) : (lowercase ? (byte)(high + 87) : (byte)(high + 55));
            ascArray[i * 2] = high;
            byte low = (byte)(bcd & 0xF);
            low = 0 <= low && low <= 9 ? (byte)(low + 48) : (lowercase ? (byte)(low + 87) : (byte)(low + 55));
            ascArray[i * 2 + 1] = low;
        }
        return ascArray;
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft) {
        return ByteTools.bcd2Asc(srcData, stripChar, isLeft, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return null;
        }
        byte[] ascArray = ByteTools.bcd2Asc(srcData);
        byte[] tmpArray = null;
        stripChar = 0 <= stripChar && stripChar <= 9 ? (stripChar += 48) : (lowercase ? (stripChar += 87) : (stripChar += 55));
        tmpArray = isLeft ? ByteTools.stripStart(ascArray, (byte)stripChar) : ByteTools.stripEnd(ascArray, (byte)stripChar);
        return tmpArray;
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, int len) {
        return ByteTools.bcd2Asc(srcData, stripChar, isLeft, len, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, int len, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return null;
        }
        byte[] ascArray = ByteTools.bcd2Asc(srcData);
        stripChar = 0 <= stripChar && stripChar <= 9 ? (stripChar += 48) : (lowercase ? (stripChar += 87) : (stripChar += 55));
        byte[] tmpArray = null;
        if (ascArray != null) {
            tmpArray = new byte[len];
            if (ascArray.length > len) {
                if (isLeft) {
                    System.arraycopy(ascArray, ascArray.length - len, tmpArray, 0, len);
                } else {
                    System.arraycopy(ascArray, 0, tmpArray, 0, len);
                }
            } else {
                tmpArray = isLeft ? ByteTools.leftPad(ascArray, len, (byte)stripChar) : ByteTools.rightPad(ascArray, len, (byte)stripChar);
            }
        }
        return tmpArray;
    }

    public static int byte2int(byte[] bytes) {
        if (bytes == null || bytes.length > 4) {
            return 0;
        }
        int intVal = 0;
        for (int i = 0; i < bytes.length; ++i) {
            intVal <<= 8;
            intVal ^= bytes[i] & 0xFF;
        }
        return intVal;
    }

    public static long byte2long(byte[] bytes) {
        if (bytes == null || bytes.length > 8) {
            return 0L;
        }
        long longVal = 0L;
        for (int i = 0; i < 8; ++i) {
            longVal <<= 8;
            longVal ^= (long)(bytes[i] & 0xFF);
        }
        return longVal;
    }

    public static short byte2short(byte[] byteDate) {
        if (byteDate == null || byteDate.length > 2) {
            return 0;
        }
        short shortVal = 0;
        for (int i = 0; i < byteDate.length; ++i) {
            shortVal = (short)(shortVal << 8);
            shortVal = (short)(shortVal ^ byteDate[i] & 0xFF);
        }
        return shortVal;
    }

    public static Number bytes2num(byte[] byteData) {
        long num = 0L;
        for (int i = 0; i < byteData.length; ++i) {
            num <<= 8;
            num ^= (long)(byteData[i] & 0xFF);
        }
        return num;
    }

    public static byte[] centerPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int left = srcLen / 2;
        int right = srcLen - left;
        System.arraycopy(bytes, 0, byRet, 0, left);
        for (int i = left; i < left + len - srcLen; ++i) {
            byRet[i] = padByte;
        }
        System.arraycopy(bytes, left, byRet, left + len - srcLen, right);
        return byRet;
    }

    public static byte[] centerPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int left = srcLen / 2;
        int right = srcLen - left;
        System.arraycopy(bytes, 0, byRet, 0, left);
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, left + i * length, length);
        }
        int surplus = padSzie % length;
        System.arraycopy(padBytes, 0, byRet, left + count * length, surplus);
        System.arraycopy(bytes, left, byRet, left + len - srcLen, right);
        return byRet;
    }

    public static boolean contains(byte[] bytes, byte indexByte) {
        boolean containFlag = false;
        if (bytes == null) {
            return containFlag;
        }
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] != indexByte) continue;
            containFlag = true;
            break;
        }
        return containFlag;
    }

    public static boolean contrastBytes(byte[] source, int index, byte[] target) {
        int len = target.length;
        if (source.length - index < len || len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (source[index + i] == target[i]) continue;
            return false;
        }
        return true;
    }

    public static int decAsciiByte2int(byte[] byteArray) throws Exception {
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = byteArray.length;
        if (max > 0) {
            int digit;
            int limit;
            if (byteArray[0] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(byteArray[i++], radix)) < 0) {
                    throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(byteArray[i++], radix)) < 0) {
                    throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
                }
                if (result < multmin) {
                    throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
                }
                if ((result *= radix) < limit + digit) {
                    throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
                }
                result -= digit;
            }
        } else {
            throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new Exception("\u5c06\u6570\u636e[" + new String(byteArray) + "]\u8f6c\u6362\u6210int\u578b\u5f02\u5e38\u3002");
        }
        return -result;
    }

    public static int decBcdByte2int(byte[] byteArray, boolean isLeftFill, int fillchar) {
        int val = 0;
        int pow = 1;
        int tmpVal = 0;
        int tmpRes = 0;
        int length = byteArray.length;
        for (int i = length - 1; i >= 0; --i) {
            tmpRes = byteArray[i] & 0xFF;
            do {
                tmpVal = tmpRes % 16;
                val += tmpVal * pow;
                pow *= 10;
            } while ((tmpRes /= 16) != 0);
        }
        return val;
    }

    public static int decByte2int(byte[] byteArray) {
        int val = 0;
        int length = byteArray.length;
        int pow = 1;
        for (int i = length - 1; i >= 0; --i) {
            val += byteArray[i] * pow;
            pow *= 10;
        }
        return val;
    }

    public static boolean equals(byte[] srcData, byte[] destData) {
        if (srcData == null && destData == null) {
            return true;
        }
        if (srcData != null && destData != null) {
            int srcLength = srcData.length;
            int destLength = destData.length;
            if (srcLength == destLength) {
                for (int i = 0; i < destLength; ++i) {
                    if (srcData[i] == destData[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static byte[] getBytes(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return object.toString().getBytes();
    }

    public static byte[] getBytes(Object object, String charset) throws UnsupportedEncodingException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes(charset);
        }
        if (object instanceof Character) {
            return ((Character)object).toString().getBytes(charset);
        }
        return object.toString().getBytes();
    }

    public static int hexAsciiByte2int(byte[] byteArray) {
        int val = 0;
        int length = byteArray.length;
        int pow = 1;
        int tmpVal = 0;
        for (int i = length - 1; i >= 0; --i) {
            tmpVal = byteArray[i] > 57 ? byteArray[i] - 55 : byteArray[i] - 48;
            val += tmpVal * pow;
            pow *= 16;
        }
        return val;
    }

    public static int hexBcdByte2int(byte[] byteArray, boolean isLeftFill, int fillchar) {
        int val = 0;
        int pow = 1;
        int tmpVal = 0;
        int tmpRes = 0;
        int length = byteArray.length;
        for (int i = length - 1; i >= 0; --i) {
            tmpRes = byteArray[i] & 0xFF;
            do {
                tmpVal = tmpRes % 16;
                val += tmpVal * pow;
                pow *= 16;
            } while ((tmpRes /= 16) != 0);
        }
        return val;
    }

    public static int indexOf(byte[] bytes, byte indexByte) {
        int index = -1;
        if (bytes == null) {
            return index;
        }
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] != indexByte) continue;
            index = i;
            break;
        }
        return index;
    }

    public static byte[] int2byte(int val) {
        return new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
    }

    public static byte[] int2DecAsciiByte(int val) {
        int r;
        int q;
        int size = val < 0 ? ByteTools.stringSize(-val) + 1 : ByteTools.stringSize(val);
        byte[] buf = new byte[size];
        int charPos = size;
        int sign = 0;
        if (val < 0) {
            sign = 45;
            val = -val;
        }
        while (val >= 65536) {
            q = val / 100;
            r = val - ((q << 6) + (q << 5) + (q << 2));
            val = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = val * 52429 >>> 19;
            r = val - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((val = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
        return buf;
    }

    public static byte[] int2DecBcdByte(int value, boolean isLeftFill, int fillchar, int len) throws Exception {
        int r;
        int q;
        if (value < 0) {
            throw new Exception("\u6570\u636e[" + value + "]\u4e3a\u8d1f\u6570\uff0cint2DecBcdByte\u4e0d\u652f\u6301\u8d1f\u6570");
        }
        int size = ByteTools.stringSize(value);
        if (len < size) {
            throw new Exception("\u76ee\u6807\u957f\u5ea6[" + len + "]\u5c0f\u4e8e\u5b9e\u9645\u957f\u5ea6[" + size + "]");
        }
        byte[] buf = new byte[size];
        int charPos = size;
        while (value >= 65536) {
            q = value / 100;
            r = value - ((q << 6) + (q << 5) + (q << 2));
            value = q;
            buf[--charPos] = DigitOnes2[r];
            buf[--charPos] = DigitTens2[r];
        }
        do {
            q = value * 52429 >>> 19;
            r = value - ((q << 3) + (q << 1));
            buf[--charPos] = digits2[r];
        } while ((value = q) != 0);
        byte[] bt = new byte[(len + 1) / 2];
        int btLen = bt.length;
        if (isLeftFill) {
            for (int i = 0; i < btLen; ++i) {
                int n1 = fillchar;
                if (2 * i < size) {
                    n1 = buf[size - 2 * i - 1];
                }
                int n2 = fillchar;
                if (2 * i + 1 < size) {
                    n2 = buf[size - (2 * i + 2)];
                }
                bt[btLen - i - 1] = (byte)(16 * n2 + n1);
            }
        } else {
            for (int i = 0; i < btLen; ++i) {
                int n1 = fillchar;
                if (2 * i < size) {
                    n1 = buf[2 * i];
                }
                int n2 = fillchar;
                if (2 * i + 1 < size) {
                    n2 = buf[2 * i + 1];
                }
                bt[i] = (byte)(16 * n1 + n2);
            }
        }
        return bt;
    }

    public static byte[] int2DecByte(int val) {
        ArrayList<Integer> byteList = new ArrayList<Integer>();
        int comprared = 1;
        int tmpVal = val;
        while (true) {
            byteList.add(tmpVal % 10);
            if ((comprared *= 10) > Math.abs(val)) break;
            tmpVal /= 10;
        }
        int size = byteList.size();
        byte[] retByte = new byte[size];
        for (int i = 0; i < size; ++i) {
            retByte[size - i - 1] = ((Integer)byteList.get(i)).byteValue();
        }
        return retByte;
    }

    public static byte[] int2HexAsciiByte(int val) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[val & mask];
        } while ((val >>>= 4) != 0);
        int len = 32 - charPos;
        byte[] res = new byte[len];
        System.arraycopy(buf, charPos, res, 0, len);
        return res;
    }

    public static byte[] int2HexBcdByte(int value, boolean isLeftFill, int fillchar, int len) throws Exception {
        if (value < 0) {
            throw new Exception("\u6570\u636e[" + value + "]\u4e3a\u8d1f\u6570\uff0cint2HexBcdByte\u4e0d\u652f\u6301\u8d1f\u6570");
        }
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits2[value & mask];
        } while ((value >>>= 4) != 0);
        int resLen = 32 - charPos;
        if (len < resLen) {
            throw new Exception("\u76ee\u6807\u957f\u5ea6[" + len + "]\u5c0f\u4e8e\u5b9e\u9645\u957f\u5ea6[" + resLen + "]");
        }
        byte[] bt = new byte[(len + 1) / 2];
        int btLen = bt.length;
        if (isLeftFill) {
            for (int i = 0; i < btLen; ++i) {
                int n1 = fillchar;
                if (2 * i < resLen) {
                    n1 = buf[resLen - 2 * i - 1 + charPos];
                }
                int n2 = fillchar;
                if (2 * i + 1 < resLen) {
                    n2 = buf[resLen - (2 * i + 2) + charPos];
                }
                bt[btLen - i - 1] = (byte)(16 * n2 + n1);
            }
        } else {
            for (int i = 0; i < btLen; ++i) {
                int n1 = fillchar;
                if (2 * i < resLen) {
                    n1 = buf[2 * i + charPos];
                }
                int n2 = fillchar;
                if (2 * i + 1 < resLen) {
                    n2 = buf[2 * i + 1 + charPos];
                }
                bt[i] = (byte)(16 * n1 + n2);
            }
        }
        return bt;
    }

    public static byte[] leftPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        for (int i = 0; i < len - srcLen; ++i) {
            byRet[i] = padByte;
        }
        System.arraycopy(bytes, 0, byRet, len - srcLen, srcLen);
        return byRet;
    }

    public static byte[] leftPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, i * length, length);
        }
        int surplus = padSzie % length;
        for (int i = 0; i < surplus; ++i) {
            System.arraycopy(padBytes, 0, byRet, count * length, surplus);
        }
        System.arraycopy(bytes, 0, byRet, len - srcLen, srcLen);
        return byRet;
    }

    public static byte[] long2byte(long val) {
        return new byte[]{(byte)(val >> 56), (byte)(val >> 48), (byte)(val >> 40), (byte)(val >> 32), (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
    }

    public static void main(String[] args) {
        try {
            String ss = "aaaaa&#20013;&#x56fd;bbbb&#20013;&#x56fd;1";
            byte[] bt = ByteTools.unicode2Asc(ss.getBytes("gbk"), "gbk");
            System.out.println(new String(bt, "gbk"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] rightPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        System.arraycopy(bytes, 0, byRet, 0, srcLen);
        for (int i = srcLen; i < len; ++i) {
            byRet[i] = padByte;
        }
        return byRet;
    }

    public static byte[] rightPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        System.arraycopy(bytes, 0, byRet, 0, srcLen);
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, srcLen + i * length, length);
        }
        int surplus = padSzie % length;
        System.arraycopy(padBytes, 0, byRet, srcLen + count * length, surplus);
        return byRet;
    }

    public static byte[] short2byte(short shortData) {
        byte b1 = (byte)shortData;
        shortData = (short)(shortData >> 8);
        byte b0 = (byte)shortData;
        return new byte[]{b0, b1};
    }

    private static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] strip(byte[] bytes, byte stripByte) {
        byte[] byStart = ByteTools.stripStart(bytes, stripByte);
        byte[] byEnd = ByteTools.stripEnd(byStart, stripByte);
        return byEnd;
    }

    public static byte[] strip(byte[] bytes, byte[] stripArray) {
        byte[] byStart = ByteTools.stripStart(bytes, stripArray);
        byte[] byEnd = ByteTools.stripEnd(byStart, stripArray);
        return byEnd;
    }

    public static byte[] stripEnd(byte[] bytes, byte stripByte) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        for (i = bySize - 1; i > 0 && bytes[i] == stripByte; --i) {
            if (i != 0 || bytes[i] != stripByte) continue;
            return new byte[0];
        }
        byte[] byRet = new byte[i + 1];
        System.arraycopy(bytes, 0, byRet, 0, i + 1);
        return byRet;
    }

    public static byte[] stripEnd(byte[] bytes, byte[] stripArray) {
        if (bytes == null || bytes.length == 0 || stripArray == null || stripArray.length == 0) {
            return bytes;
        }
        int bytesLength = bytes.length;
        int stripLength = stripArray.length;
        int i = bytesLength - 1;
        int j = stripLength - 1;
        int index = ByteTools.indexOf(stripArray, bytes[i]);
        if (index == -1) {
            return bytes;
        }
        int count = 0;
        for (j = index; i >= 0 && j >= 0 && bytes[i] == stripArray[j]; --i, --j) {
            if (j != 0) continue;
            ++count;
            j = stripLength;
        }
        byte[] byRet = new byte[]{};
        if (count == 0) {
            return bytes;
        }
        int length = index + 1 + (count - 1) * stripLength;
        byRet = new byte[bytesLength - length];
        System.arraycopy(bytes, 0, byRet, 0, byRet.length);
        return byRet;
    }

    public static byte[] stripStart(byte[] bytes, byte stripByte) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        for (i = 0; i < bySize && bytes[i] == stripByte; ++i) {
            if (i != bySize - 1 || bytes[i] != stripByte) continue;
            return new byte[0];
        }
        byte[] byRet = new byte[bySize - i];
        System.arraycopy(bytes, i, byRet, 0, bySize - i);
        return byRet;
    }

    public static byte[] stripStart(byte[] bytes, byte[] stripArray) {
        if (bytes == null || bytes.length == 0 || stripArray == null || stripArray.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        int stripSize = stripArray.length;
        int i = 0;
        for (int j = 0; i < bySize && j < stripSize && bytes[i] == stripArray[j]; ++i, ++j) {
            if (j != stripSize - 1) continue;
            j = -1;
        }
        byte[] byRet = new byte[bySize - i];
        System.arraycopy(bytes, i, byRet, 0, bySize - i);
        return byRet;
    }

    public static byte[] stripZero(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int startPos = 0;
        int endPos = bytes.length - 1;
        for (i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) {
                startPos = i;
                break;
            }
            if (i != bytes.length - 1 || bytes[i] != 0) continue;
            return null;
        }
        for (i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] != 0) {
                endPos = i;
                break;
            }
            if (i != 0 || bytes[i] != 0) continue;
            return null;
        }
        byte[] byRet = new byte[endPos - startPos + 1];
        System.arraycopy(bytes, startPos, byRet, 0, endPos - startPos + 1);
        return byRet;
    }

    public static byte[] subBytes(byte[] srcData, int startPos, boolean startPosException, int length, boolean lengthException) throws Exception {
        byte[] retArray = null;
        if (srcData == null) {
            throw new Exception("\u5b57\u8282\u5de5\u5177\u7c7b\u6309\u5f02\u5e38\u89c4\u5219\u622a\u53d6\u5b57\u8282\u6570\u7ec4\u65b9\u6cd5 @ \u6e90\u6570\u636e\u4e3a\u7a7a");
        }
        int srcLength = srcData.length;
        if (startPosException) {
            if (startPos < 0 || startPos > srcLength) {
                throw new Exception("\u5b57\u8282\u5de5\u5177\u7c7b\u6309\u5f02\u5e38\u89c4\u5219\u622a\u53d6\u5b57\u8282\u6570\u7ec4\u65b9\u6cd5 @ \u8d77\u59cb\u70b9[" + startPos + "]\u5c0f\u4e8e0\u6216\u8005\u5927\u4e8e\u6e90\u6570\u636e\u957f\u5ea6[" + srcLength + "]");
            }
        } else {
            if (startPos < 0) {
                startPos = 0;
            }
            if (startPos > srcLength) {
                return new byte[0];
            }
        }
        int surplus = srcLength - startPos;
        if (lengthException) {
            if (length < 0 || length > surplus) {
                throw new Exception("\u5b57\u8282\u5de5\u5177\u7c7b\u6309\u5f02\u5e38\u89c4\u5219\u622a\u53d6\u5b57\u8282\u6570\u7ec4\u65b9\u6cd5 @ \u622a\u53d6\u957f\u5ea6[" + length + "]\u5c0f\u4e8e0\u6216\u8005\u5927\u4e8e\u53ef\u4ee5\u622a\u53d6\u7684\u6700\u5927\u957f\u5ea6[" + surplus + "");
            }
        } else if (length < 0 || length > surplus) {
            length = surplus;
        }
        retArray = new byte[length];
        System.arraycopy(srcData, startPos, retArray, 0, length);
        return retArray;
    }

    public static byte[] unicode2Asc(byte[] srcData, String encoding) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = null;
        boolean exist = false;
        int len = srcData.length;
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            if (i > len - 7 || srcData[i] != 38 || srcData[i + 1] != 35 || srcData[i + 7] != 59) continue;
            if (!exist) {
                baos = new ByteArrayOutputStream(len);
                exist = true;
            }
            baos.write(srcData, pos, i - pos);
            pos = i + 8;
            if (srcData[i + 2] == 120) {
                baos.write(ByteTools.unicode2String(new String(srcData, i + 3, 4), true).getBytes(encoding));
            } else {
                baos.write(ByteTools.unicode2String(new String(srcData, i + 2, 5), false).getBytes(encoding));
            }
            i += 7;
        }
        if (exist) {
            baos.write(srcData, pos, len - pos);
            return baos.toByteArray();
        }
        return srcData;
    }

    public static byte[] unicodeTransfer(byte[] data, String encoding) throws Exception {
        return ByteTools.unicode2Asc(data, encoding);
    }

    public static String unicode2String(String unicodeCode, boolean hex) {
        if (hex) {
            return String.valueOf((char)Integer.parseInt(unicodeCode, 16));
        }
        return String.valueOf((char)Integer.parseInt(unicodeCode));
    }
}

