/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.core;

import cn.com.yusys.yusp.bsp.resources.core.BeanLifeCycle;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractBean
implements BeanLifeCycle,
BeanNameAware {
    protected boolean alive;
    protected String bundlerId;
    protected String moduleId;
    protected String beanName;
    transient String sid;

    @Override
    public void start() throws Exception {
        this.setAlive(true);
        this.sid = Thread.currentThread().getName();
        int index = this.sid.indexOf("/");
        if (index > 0) {
            this.setBundlerId(this.sid.substring(0, index));
            this.setModuleId(this.sid.substring(index + 1));
        } else {
            this.setBundlerId(this.sid);
        }
        String moduleLog = this.sid.replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        try {
            this.doStart();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            LogbackUtil.removeLogInfo();
        }
    }

    public abstract void doStart() throws Exception;

    @Override
    public void stop() throws Exception {
        this.setAlive(false);
        String moduleLog = this.sid.replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        try {
            this.doStop();
        }
        finally {
            LogbackUtil.removeLogInfo();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public abstract void doStop() throws Exception;

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public String getBundlerId() {
        return this.bundlerId;
    }

    public void setBundlerId(String bundlerId) {
        this.bundlerId = bundlerId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getSid() {
        if (this.sid == null) {
            this.sid = this.moduleId == null ? this.bundlerId : this.bundlerId + "/" + this.moduleId;
        }
        return this.sid;
    }
}

