/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method;

import cn.com.yusys.yusp.bsp.schema.method.Group;
import cn.com.yusys.yusp.bsp.schema.method.Method;
import cn.com.yusys.yusp.bsp.schema.method.MethodDefinition;
import cn.com.yusys.yusp.bsp.toolkit.xml.CastorTools;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static String getShortMethodClassName(String className) {
        if (className.startsWith("cn.com.yusys.yusp.bsp.method.impl")) {
            return className.substring("cn.com.yusys.yusp.bsp.method.impl".length() + 1);
        }
        return className;
    }

    public static String getFullMethodClassName(String shortClassName) {
        return "cn.com.yusys.yusp.bsp.method.impl." + shortClassName;
    }

    public static MethodDefinition loadDefinitionFile(String filePath) throws Exception {
        return (MethodDefinition)CastorTools.unmarshaller(filePath, MethodDefinition.class, Utils.class.getClassLoader());
    }

    public static MethodDefinition loadDefinitionFile(File file) throws Exception {
        return (MethodDefinition)CastorTools.unmarshaller(file, MethodDefinition.class, Utils.class.getClassLoader());
    }

    public static MethodDefinition loadDefinitionFile(InputStream inputStream) throws Exception {
        return (MethodDefinition)CastorTools.unmarshaller(inputStream, MethodDefinition.class);
    }

    public static List<Method> getAllComponent(MethodDefinition def) {
        Group[] gs;
        Method[] cs;
        ArrayList<Method> compList = new ArrayList<Method>();
        for (Method c : cs = def.getMethod()) {
            compList.add(c);
        }
        for (Group g : gs = def.getGroup()) {
            Utils.getComponent(g, compList);
        }
        return compList;
    }

    private static void getComponent(Group group, List<Method> compList) {
        Group[] gs;
        Method[] ms;
        for (Method m : ms = group.getMethod()) {
            compList.add(m);
        }
        for (Group g : gs = group.getGroup()) {
            Utils.getComponent(g, compList);
        }
    }

    public static Class<?> loadMethodClass(ClassLoader classLoader, String shortClassName) throws Exception {
        return classLoader.loadClass(Utils.getFullMethodClassName(shortClassName));
    }
}

