/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method;

import cn.com.yusys.yusp.bsp.method.MethodException;
import cn.com.yusys.yusp.bsp.method.MethodRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastMethodInvoker {
    private static final Logger logger = LoggerFactory.getLogger(FastMethodInvoker.class);
    private static FastMethodInvoker instance = new FastMethodInvoker();
    private Map<String, FastClass> clazzCache = new ConcurrentHashMap<String, FastClass>();
    private Map<String, Object> clazzInstanceCache = new ConcurrentHashMap<String, Object>();
    private Map<String, FastMethod> methodCache = new ConcurrentHashMap<String, FastMethod>();

    public static FastMethodInvoker getInstance() {
        return instance;
    }

    public void clear() {
        this.methodCache.clear();
        this.clazzCache.clear();
        this.clazzInstanceCache.clear();
    }

    public void clear(String _clazzName) {
        this.clazzCache.remove(_clazzName);
        this.clazzInstanceCache.remove(_clazzName);
        Set<String> methodKeys = this.methodCache.keySet();
        String[] methodKeysStr = new String[methodKeys.size()];
        methodKeys.toArray(methodKeysStr);
        for (String methodKey : methodKeysStr) {
            if (!methodKey.contains(_clazzName)) continue;
            this.methodCache.remove(methodKey);
            logger.info("\u6e05\u7a7a\u65b9\u6cd5\u7f13\u5b58\uff1a{}", (Object)methodKey);
        }
    }

    private FastClass getClazz(String domain, String clazzName) throws Exception {
        FastClass clazz = null;
        String _clazzName = null;
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            _clazzName = "plat:" + clazzName;
        } else if ("bank".equals(domain)) {
            _clazzName = domain + ":" + clazzName;
        }
        clazz = this.clazzCache.get(_clazzName);
        if (clazz == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u65b9\u6cd5\u8c03\u7528 @ \u52a0\u8f7d\u7c7b:" + _clazzName);
            }
            Class<?> clazz0 = MethodRegistry.getMethod(domain, clazzName);
            clazz = FastClass.create(clazz0);
            this.clazzCache.put(_clazzName, clazz);
            this.clazzInstanceCache.put(_clazzName, clazz.newInstance());
        }
        return clazz;
    }

    private FastMethod getMethod(FastClass clazz, String clazzName, String methodName) throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(clazzName);
        sb.append('@');
        sb.append(methodName);
        String key = sb.toString();
        FastMethod method = this.methodCache.get(key);
        if (method == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u65b9\u6cd5\u8c03\u7528\u7ec4\u4ef6 @ \u52a0\u8f7d\u65b9\u6cd5:" + methodName);
            }
            Class<?>[] type = null;
            Method[] m = clazz.getJavaClass().getMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(methodName)) continue;
                type = m[i].getParameterTypes();
                break;
            }
            if (type == null) {
                throw new Exception("\u65b9\u6cd5\u4e0d\u5b58\u5728:" + key);
            }
            method = clazz.getMethod(methodName, type);
            this.methodCache.put(key, method);
        }
        return method;
    }

    public Object invokeFormatMethod(String _clazzName, String _methodName, Map<String, String> paras, Object data, Map<String, Object> context) throws Exception {
        String clazzName = null;
        String domain = null;
        int index = _clazzName.indexOf(":");
        if (index != -1) {
            domain = _clazzName.substring(0, index);
            _clazzName = clazzName = _clazzName.substring(index + 1);
        }
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazzName = "plat:" + _clazzName;
        } else if ("bank".equals(domain)) {
            clazzName = domain + ":" + _clazzName;
        }
        FastClass fastClazz = this.getClazz(domain, _clazzName);
        FastMethod fastMethod = this.getMethod(fastClazz, clazzName, _methodName);
        Object instance = this.clazzInstanceCache.get(clazzName);
        try {
            return fastMethod.invoke(instance, new Object[]{data, paras, context});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ClassCastException) {
                throw new Exception("\u65b9\u6cd5[" + _clazzName + "." + _methodName + "]\u5165\u53c2\u7c7b\u578b\u4e0d\u6b63\u786e", e.getTargetException());
            }
            if (e.getTargetException() instanceof MethodException) {
                throw new Exception(e.getTargetException());
            }
            throw e;
        }
    }
}

