/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.util.Map;

public class ExecutorHelper {
    public static final String FILL_STYLE_LEFT = "left";
    public static final String FILL_STYLE_RIGHT = "right";
    public static final String REGEX_HEX_CHAR = "[0-9]|[A-F]|[a-f]";

    public static boolean isHexChar(String str) {
        return str.matches(REGEX_HEX_CHAR);
    }

    public static byte[] defFillData(String executorName, Item item, byte[] data, String fLen, String fillStyle, byte[] filler, Map<String, Object> rootContext, boolean exprEnabled) throws Exception {
        if (StringTools.isEmpty(fLen)) {
            throw new Exception(executorName + "\u4e2d" + item.getName() + "\u5b57\u6bb5\u7684\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int len = 0;
        try {
            if (exprEnabled) {
                Object obj = OgnlTools.getValue(fLen, rootContext);
                len = StringTools.getInt(obj);
            } else {
                len = Integer.parseInt(fLen);
            }
        }
        catch (Exception e) {
            throw new Exception("[" + executorName + "]\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u7684\u6570\u636e\u957f\u5ea6\u7c7b\u578b\u4e0d\u6b63\u786e\uff01" + fLen, e);
        }
        int dataLen = data.length;
        if (len > dataLen) {
            if (filler.length == 0) {
                throw new Exception("[" + executorName + "]\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u503c\u7684\u957f\u5ea6\u4e0d\u8db3\uff01");
            }
            data = ExecutorHelper.isLeftFill(fillStyle) ? ByteTools.leftPad(data, len, filler) : ByteTools.rightPad(data, len, filler);
        } else if (len != -1 && len < dataLen) {
            throw new Exception("[" + executorName + "]\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u503c[" + new String(data) + "]\u957f\u5ea6[" + dataLen + "]\u8d85\u8fc7\u4e86\u5b9a\u4e49\u7684\u957f\u5ea6[" + len + "]\uff01");
        }
        return data;
    }

    public static void validataMaxLen(String executorName, Item item, int dataLen) throws Exception {
        if ((long)dataLen > 0xA00000L) {
            throw new Exception("[" + executorName + "]\u5b57\u6bb5[" + item.getName() + "]\u914d\u7f6e\u7684\u6570\u636e\u957f\u5ea6[" + dataLen + "]\u592a\u5927\uff0c\u8d85\u8fc7\u7f13\u51b2\u533a\u6700\u5927\u503c[" + 0xA00000L + "]");
        }
    }

    public static boolean isLeftFill(String fillStyle) {
        if (StringTools.isEmpty(fillStyle)) {
            return true;
        }
        return FILL_STYLE_LEFT.equals(fillStyle);
    }

    public static int searchSeparatorPosition(int index, byte[] data, byte[] sep, String encoding) {
        boolean isChar = false;
        if ("UTF-8".equalsIgnoreCase(encoding) || "GB18030".equalsIgnoreCase(encoding)) {
            int n = data.length;
            for (int i = index; i < n; ++i) {
                if (!ExecutorHelper.contrastBytes(data, i, sep)) continue;
                return i;
            }
        } else {
            int n = data.length;
            for (int i = index; i < n; ++i) {
                if (!isChar && data[i] < -1) {
                    isChar = true;
                    continue;
                }
                if (isChar || data[i] < -1) {
                    isChar = false;
                    continue;
                }
                if (!ExecutorHelper.contrastBytes(data, i, sep)) continue;
                return i;
            }
        }
        return data.length;
    }

    public static boolean contrastBytes(byte[] source, int index, byte[] target) {
        int len = target.length;
        if (source.length - index < len || len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (source[index + i] == target[i]) continue;
            return false;
        }
        return true;
    }

    public static int parseItemLen(String executorName, Item item, String lenExpr, Map<String, Object> rootContext, int msgLen, int position) throws Exception {
        if (StringTools.isEmpty(lenExpr)) {
            throw new DataFormatException("[" + executorName + "]\u5b57\u6bb5'" + item.getName() + "'\u7f3a\u5c11\u914d\u7f6e\u9879:\u5b57\u6bb5\u957f\u5ea6");
        }
        int nLength = Integer.MIN_VALUE;
        try {
            nLength = Integer.parseInt(lenExpr);
        }
        catch (NumberFormatException nfe) {
            nLength = Integer.MIN_VALUE;
        }
        if (nLength == Integer.MIN_VALUE) {
            Object obj = null;
            try {
                obj = OgnlTools.getValue(lenExpr, rootContext);
                nLength = StringTools.getInt(obj);
            }
            catch (Exception e) {
                throw new DataFormatException("[" + executorName + "]\u89e3\u6790\u5b57\u6bb5[" + item.getName() + "]\u957f\u5ea6\u8868\u8fbe\u5f0f\u5f02\u5e38,\u8868\u8fbe\u5f0f:" + lenExpr + ",\u89e3\u6790\u540e\u7684\u503c\u4e3a:" + obj, e);
            }
        }
        if (nLength < -1) {
            throw new DataFormatException("[" + executorName + "]\u5b57\u6bb5[" + item.getName() + "]\u957f\u5ea6\u503c\u4e3a\u8d1f\u6570");
        }
        if (nLength == -1) {
            nLength = msgLen - position;
        }
        return nLength;
    }

    public static byte[] parserFiller(String filler) {
        byte[] defDataFiller = null;
        defDataFiller = StringTools.isEmpty(filler) ? new byte[]{} : StringTools.escString2Byte(filler);
        return defDataFiller;
    }
}

