/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.dataformat.Utils;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.lib.Dataformat;
import cn.com.yusys.yusp.bsp.schema.dataformat.lib.DataformatDefinition;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatRegistry {
    private static Logger logger = LoggerFactory.getLogger(DataFormatRegistry.class);
    private static final String EP_DF_PACKAGE = "cn.com.yusys.yusp.bsp.dataformat.impl.";
    private static Map<String, Map<String, Class<?>>> _registry = new HashMap();

    public static void addPlatDataFormat(Class<?> clazz) {
        DataFormatRegistry.addDataFormat("plat", clazz);
    }

    public static void addBankDataFormat(Class<?> clazz) {
        DataFormatRegistry.addDataFormat("bank", clazz);
    }

    public static void addAppDataFormat(String appPath, Class<?> clazz) {
        DataFormatRegistry.addDataFormat(appPath, clazz);
    }

    public static void addDataFormat(String type, Class<?> clazz) {
        Map<String, Class<?>> entryMap = _registry.get(type);
        if (entryMap == null) {
            entryMap = new HashMap();
            _registry.put(type, entryMap);
        }
        String simpleName = clazz.getName().substring(EP_DF_PACKAGE.length());
        entryMap.put(simpleName, clazz);
    }

    public static void registryDataFormat(File dataformatDefinition, Class<?> clazz, String appPath) throws Exception {
        DataformatDefinition dd = Utils.loadDefinitionFile(dataformatDefinition);
        List<Dataformat> ds = Utils.getAllComponent(dd);
        for (Dataformat d : ds) {
            Class<?> clazzTM = Utils.loadDataformatClass(clazz.getClassLoader(), d.getClazz());
            if (DataFormatRegistry.isExist(d, appPath)) {
                logger.warn("\u62a5\u6587\u683c\u5f0f\u91cd\u590d\u6ce8\u518c\uff1a{}\u5df2\u7ecf\u5b58\u5728\u5e76\u5ffd\u7565,\u8bf7\u786e\u8ba4\u540e\u6ce8\u518c", (Object)d.getClazz());
                continue;
            }
            String clazzName = clazzTM.getName();
            int index = clazzName.indexOf(EP_DF_PACKAGE);
            if (index == -1) {
                logger.warn("\u6570\u636e\u683c\u5f0f\u5305\u540d\u4e0d\u5408\u6cd5\uff1a{}", (Object)clazzName);
                continue;
            }
            if (StringTools.isEmpty(d.getDomain()) || "plat".equals(d.getDomain())) {
                DataFormatRegistry.addPlatDataFormat(clazzTM);
            } else if ("bank".equals(d.getDomain())) {
                DataFormatRegistry.addBankDataFormat(clazzTM);
            } else {
                logger.error("\u62a5\u6587\u57df\u540d\u4e0d\u5408\u6cd5\uff1a{}:{}", (Object)d.getDomain(), (Object)clazzName);
                throw new Exception("\u62a5\u6587\u57df\u540d\u4e0d\u5408\u6cd5:[" + d.getDomain() + ":" + clazzName + "]");
            }
            logger.info("\u6570\u636e\u683c\u5f0f\u6ce8\u518c\u6210\u529f:{},{}", (Object)(d.getDomain() == null ? "plat" : d.getDomain()), (Object)d.getClazz());
        }
    }

    public static void registryDataFormat(InputStream dataformatStream, Class<?> clazz, String appPath) throws Exception {
        DataformatDefinition dd = Utils.loadDefinitionFile(dataformatStream);
        List<Dataformat> ds = Utils.getAllComponent(dd);
        for (Dataformat d : ds) {
            Class<?> clazzTM = Utils.loadDataformatClass(clazz.getClassLoader(), d.getClazz());
            if (DataFormatRegistry.isExist(d, appPath)) {
                logger.warn("\u62a5\u6587\u683c\u5f0f\u91cd\u590d\u6ce8\u518c\uff1a{}\u5df2\u7ecf\u5b58\u5728\u5e76\u5ffd\u7565,\u8bf7\u786e\u8ba4\u540e\u6ce8\u518c", (Object)d.getClazz());
                continue;
            }
            String clazzName = clazzTM.getName();
            int index = clazzName.indexOf(EP_DF_PACKAGE);
            if (index == -1) {
                logger.warn("\u6570\u636e\u683c\u5f0f\u5305\u540d\u4e0d\u5408\u6cd5\uff1a{}", (Object)clazzName);
                continue;
            }
            if (StringTools.isEmpty(d.getDomain()) || "plat".equals(d.getDomain())) {
                DataFormatRegistry.addPlatDataFormat(clazzTM);
            } else if ("bank".equals(d.getDomain())) {
                DataFormatRegistry.addBankDataFormat(clazzTM);
            } else {
                logger.error("\u62a5\u6587\u57df\u540d\u4e0d\u5408\u6cd5\uff1a{}:{}", (Object)d.getDomain(), (Object)clazzName);
                throw new Exception("\u62a5\u6587\u57df\u540d\u4e0d\u5408\u6cd5:[" + d.getDomain() + ":" + clazzName + "]");
            }
            logger.info("\u6570\u636e\u683c\u5f0f\u6ce8\u518c\u6210\u529f:{},{}", (Object)(d.getDomain() == null ? "plat" : d.getDomain()), (Object)d.getClazz());
        }
    }

    public static void unRegistryDataFormat(String domain, String name) {
        Map<String, Class<?>> entryMap = _registry.get(domain);
        if (entryMap != null) {
            entryMap.remove(name);
            logger.info("\u6269\u5c55\u7ec4\u4ef6\u5378\u8f7d\u6210\u529f[" + domain + ":" + name + "]");
        }
    }

    public static Class<?> getPlatDataFormat(String shortClassName) {
        Map<String, Class<?>> entry = _registry.get("plat");
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getBankDataFormat(String shortClassName) {
        Map<String, Class<?>> entry = _registry.get("bank");
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getAppDataFormat(String appPath, String shortClassName) {
        Map<String, Class<?>> entry = _registry.get(appPath);
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getProjDataFormat(String type, String shortClassName) {
        Map<String, Class<?>> entry = _registry.get(type);
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    @Deprecated
    public static AbstractExecutor getDataFormatExecutor(String appPath, String name) throws Exception {
        Class<?> clazz = null;
        String type = null;
        int index = name.indexOf(":");
        if (index != -1) {
            type = name.substring(0, index);
            name = name.substring(index + 1);
        }
        if (StringTools.isEmpty(type) || "plat".equals(type)) {
            clazz = DataFormatRegistry.getPlatDataFormat(name);
        } else if ("bank".equals(type)) {
            clazz = DataFormatRegistry.getBankDataFormat(name);
        } else if ("proj".equals(type)) {
            appPath = appPath.substring(0, appPath.indexOf("."));
            appPath = appPath + "/plugins";
            clazz = DataFormatRegistry.getProjDataFormat(appPath, name);
        } else if ("app".equals(type)) {
            appPath = appPath.substring(0, appPath.lastIndexOf("/"));
            appPath = appPath + "/plugins";
            clazz = DataFormatRegistry.getAppDataFormat(appPath, name);
        }
        if (clazz == null) {
            throw new DataFormatException("\u6570\u636e\u683c\u5f0f\u672a\u6ce8\u518c " + name);
        }
        return (AbstractExecutor)clazz.newInstance();
    }

    public static AbstractExecutor getDataFormatExecutor(String name) throws Exception {
        Class<?> clazz = null;
        String type = null;
        int index = name.indexOf(":");
        if (index != -1) {
            type = name.substring(0, index);
            name = name.substring(index + 1);
        }
        if (StringTools.isEmpty(type) || "plat".equals(type)) {
            clazz = DataFormatRegistry.getPlatDataFormat(name);
        } else if ("bank".equals(type)) {
            clazz = DataFormatRegistry.getBankDataFormat(name);
        }
        if (clazz == null) {
            throw new DataFormatException("\u6570\u636e\u683c\u5f0f\u672a\u6ce8\u518c " + name);
        }
        return (AbstractExecutor)clazz.newInstance();
    }

    public static boolean isExist(Dataformat c, String appPath) {
        Map<String, Class<?>> entry = null;
        if (StringTools.isEmpty(c.getDomain()) || "plat".equals(c.getDomain())) {
            entry = _registry.get("plat");
        } else if ("bank".equals(c.getDomain())) {
            entry = _registry.get("bank");
        } else if (appPath != null) {
            entry = _registry.get(appPath);
        }
        if (entry != null) {
            return entry.containsKey(c.getClazz());
        }
        return false;
    }
}

