/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.in;

import cn.com.yusys.yusp.bsp.communication.AbstractAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.IInAdapter;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ExecutorWrapper;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.worker.BizWorker;
import cn.com.yusys.yusp.bsp.workflow.worker.IWorker;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractInAdapter
extends AbstractAdapter
implements IInAdapter {
    private String inAdapterNm;
    private String chunkedFlag;
    private int maximumPoolSize;
    private int corePoolSize;
    private ExecutorWrapper executorWrapper;
    protected Map<String, IRequest> usedRequestMap = new ConcurrentHashMap<String, IRequest>();

    public Map<String, IRequest> getUsedRequestMap() {
        return this.usedRequestMap;
    }

    public void setUsedRequestMap(Map<String, IRequest> usedRequestMap) {
        this.usedRequestMap = usedRequestMap;
    }

    @Override
    public void putRequest(String sessionId, IRequest request) {
        this.usedRequestMap.put(sessionId, request);
        request.setSessionId(sessionId);
        Object object = request.getDatasourceWrapper();
        if (object instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)object;
            wrapper.setSessionId(sessionId);
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.executorWrapper = new ExecutorWrapper();
        this.executorWrapper.setCorePoolSize(this.corePoolSize);
        this.executorWrapper.setMaximumPoolSize(this.maximumPoolSize);
        this.executorWrapper.doStart();
    }

    @Override
    public void doStop() throws Exception {
        Iterator<IRequest> iter = this.getUsedRequestMap().values().iterator();
        try {
            while (iter.hasNext()) {
                IRequest req = iter.next();
                req.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getUsedRequestMap().clear();
        this.executorWrapper.doStop();
    }

    @Override
    public void run() {
        try {
            this.beforeAction();
        }
        catch (Exception e1) {
            this.logger.error("{} @ \u52a8\u4f5c\u9884\u5904\u7406\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e1);
        }
        while (this.isAlive()) {
            try {
                IRequest req = this.makeRequest();
                if (req == null) continue;
                this.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                this.logger.error("{} @ \u76d1\u542c\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            }
        }
        LogbackUtil.removeLogInfo();
    }

    public void triggerRequest(IRequest request) throws Exception {
        block11: {
            if (request instanceof StreamRequest) {
                try {
                    boolean useBspPool = true;
                    String sn = this.snGenerator.getNextSn();
                    Session session = new Session();
                    Object o = ((StreamRequest)request).getDatasourceWrapper();
                    if (o instanceof SocketWrapper) {
                        session.getContext().put("G_CLIENT_IP", ((SocketWrapper)o).getSocket().getInetAddress().getHostAddress());
                    } else if (o instanceof Socket) {
                        session.getContext().put("G_CLIENT_IP", ((Socket)o).getInetAddress().getHostAddress());
                    }
                    session.setSessionId(sn);
                    session.setTrid(this.getSid());
                    session.setHeadSessionId(sn);
                    if (session.getBsn() == null) {
                        session.setBsn(sn);
                    }
                    session.putSessionObject("SESSION_INREQUEST", request);
                    session.getContext().putAll(BeanUtils.describe((Object)request.getInAdapter()));
                    session.getContext().put("G_SN", sn);
                    session.getContext().put("G_BSN", session.getBsn());
                    session.getContext().put("T_SESSION", session);
                    request.getInAdapter().putRequest(session.getSessionId(), request);
                    IComm comm = ResourcePortal.getInstance().getCommRegistry().fetchComm(this.getBeanName());
                    session.setIComm(comm);
                    IWorker worker = this.createBizWorker(session);
                    if (useBspPool) {
                        this.executorWrapper.execute(worker);
                        break block11;
                    }
                    worker.run();
                }
                catch (Throwable e) {
                    this.logger.error("\u5904\u7406\u63a5\u5165\u9002\u914d\u5668\u8bf7\u6c42\u5f02\u5e38\uff0c\u8be5\u8bf7\u6c42\u4e0d\u5904\u7406:{}", e);
                    try {
                        request.setCloseFlag(true);
                        request.returnToInAdapter();
                    }
                    catch (Exception e1) {
                        this.logger.error("\u5f52\u8fd8\u8fde\u63a5\u5f02\u5e38", (Throwable)e1);
                    }
                }
            } else {
                throw new Exception("\u6d88\u606f\u5206\u53d1\u5668 @ \u4e0d\u652f\u6301\u8bf7\u6c42\u7c7b\u578b:" + request.getRequestType());
            }
        }
    }

    public abstract IRequest makeRequest() throws Exception;

    public abstract void unmakeRequest(IRequest var1) throws Exception;

    public void beforeAction() throws Exception {
    }

    @Override
    public void returnRequest(IRequest request) throws Exception {
        if (request.getSessionId() != null) {
            this.getUsedRequestMap().remove(request.getSessionId());
        }
        this.unmakeRequest(request);
        request.setSessionId(null);
        if (request.getDatasourceWrapper() instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
            wrapper.setSessionId(null);
        }
    }

    @Override
    public int getAdapterType() {
        return 0;
    }

    public boolean isAvalible(IRequest request) {
        StreamRequest requestStream = (StreamRequest)request;
        return !requestStream.needToClose();
    }

    protected Object getInParameterValue(String paraName, Map<String, Object> context) throws Exception {
        return this.getInParameterValue(paraName, context, true);
    }

    protected Object getInParameterValue(String paraName, Map<String, Object> context, boolean translate) throws Exception {
        return context.get(paraName);
    }

    protected IWorker createBizWorker(Session session) {
        BizWorker worker = new BizWorker();
        worker.setSession(session);
        return worker;
    }

    public String getInAdapterNm() {
        return this.inAdapterNm;
    }

    public void setInAdapterNm(String inAdapterNm) {
        this.inAdapterNm = inAdapterNm;
    }

    public String getChunkedFlag() {
        return this.chunkedFlag;
    }

    public void setChunkedFlag(String chunkedFlag) {
        this.chunkedFlag = chunkedFlag;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }
}

