/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.out.tcp.TcpOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LongClientOutAdapter
extends TcpOutAdapter {
    private static final String OUT_ADAPTER_NAME = "\u957f\u8fde\u63a5\u5ba2\u6237\u7aef\u63a5\u51fa\u9002\u914d\u5668";
    private static final String beatFromString = "string";
    private static final String beatFromFile = "file";
    protected List<SocketWrapper> requestPool = Collections.synchronizedList(new ArrayList());
    protected String localIP;
    protected String localPort;
    protected String actionType;
    private static final String ONLY_READ = "ONLY_READ";
    protected static final String ONLY_WRITE = "ONLY_WRITE";
    private static final String READ_WRITE = "READ_WRITE";
    private long sessionTimeout = 60000L;
    private boolean heartManageConnection = false;
    private int maxConnection;
    private int interval = 30000;
    private long sessionTime = 0L;
    private boolean connectionProducerFlag = false;
    private boolean autoHeartBeat = false;
    private String heartBeatSrc = "file";
    private String heartBeatMsgFile;
    private byte[] heartBeatMsg = null;
    private int beatInterval;
    private Thread connectionProducerThread = null;
    private Thread heartBeatThread = null;
    protected Thread socketReadThread;
    protected AtomicInteger currentConnection = new AtomicInteger(0);
    private Object mutex = new Object();
    protected Semaphore semaphore;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (StringTools.isEmpty(this.actionType)) {
            this.actionType = READ_WRITE;
        }
        if (this.maxConnection <= 0) {
            throw new Exception(this.getAdapterName() + " @ \u6700\u5927\u8fde\u63a5\u6570\u975e\u6cd5[" + this.maxConnection + "]");
        }
        this.semaphore = new Semaphore(this.maxConnection, true);
        this.semaphore.drainPermits();
        this.sessionTime = this.sessionTimeout - 1000L;
        if (this.sessionTime <= 0L) {
            this.sessionTime = 60000L;
        }
        if (this.connectionProducerFlag) {
            this.connectionProducerThread = new Thread((Runnable)new ConnectionProducer(), "ConnectionProducer");
            this.connectionProducerThread.setDaemon(true);
            this.connectionProducerThread.start();
        }
        if (this.autoHeartBeat) {
            if (this.beatInterval <= 0) {
                throw new Exception(this.getAdapterName() + " @ \u5fc3\u8df3\u95f4\u9694[" + this.beatInterval + "]\u5fc5\u987b\u5927\u4e8e0");
            }
            if (beatFromString.equals(this.heartBeatSrc)) {
                String dataInfo = StringTools.getString(this.heartBeatMsgFile);
                if (dataInfo.startsWith("0x") || dataInfo.startsWith("0X")) {
                    dataInfo = dataInfo.substring(2);
                    this.heartBeatMsg = StringTools.string2Byte(dataInfo);
                } else {
                    this.heartBeatMsg = dataInfo.getBytes();
                }
            } else {
                File file = FileTools.fetchFile(this.heartBeatMsgFile);
                if (file == null || !file.exists()) {
                    this.logger.error("{} @ \u5fc3\u8df3\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)this.getAdapterName(), (Object)this.heartBeatMsgFile);
                    throw new FileNotFoundException(this.getAdapterName() + " @ \u5fc3\u8df3\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + this.heartBeatMsgFile);
                }
                this.heartBeatMsg = FileTools.readHexFile(this.heartBeatMsgFile);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ \u5f85\u53d1\u9001\u7684\u5fc3\u8df3\u62a5\u6587\u957f\u5ea6\u4e3a{} bytes,\u5185\u5bb9\u4e3a\uff1a\n{}", new Object[]{this.getAdapterName(), this.heartBeatMsg.length, StringTools.toHexTable(this.heartBeatMsg)});
            }
            this.heartBeatThread = new HeartBeatThread(this.beatInterval);
            this.heartBeatThread.setName(this.getSid() + "-HeartBeatThread");
            this.heartBeatThread.start();
        }
        this.logger.debug("{} @ \u63a5\u51fa\u9002\u914d\u5668\u542f\u52a8", (Object)this.getAdapterName());
    }

    @Override
    public IRequest makeRequest(Session session) throws Exception {
        this.initConnection();
        if (!this.alive) {
            throw new Exception("\u9002\u914d\u5668\u5df2\u5173\u95ed");
        }
        boolean acquireFlag = this.semaphore.tryAcquire(this.sessionTime, TimeUnit.MILLISECONDS);
        if (acquireFlag) {
            SocketWrapper wrapper = this.requestPool.remove(0);
            StreamRequest createdRequest = new StreamRequest();
            try {
                createdRequest.setDatasourceWrapper(wrapper);
                if (wrapper.isClose()) {
                    throw new Exception("\u8fde\u63a5\u5df2\u5173\u95ed");
                }
                createdRequest.setOutAdapter(this);
                if (ONLY_WRITE.equals(this.actionType)) {
                    wrapper.setBis(null);
                } else if (ONLY_READ.equals(this.actionType)) {
                    wrapper.setBos(null);
                } else if (!READ_WRITE.equals(this.actionType)) {
                    throw new Exception("\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301[" + this.actionType + "]");
                }
            }
            catch (Throwable e) {
                createdRequest.setCloseFlag(true);
                this.unmakeRequest(createdRequest);
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception("\u521b\u5efarequest\u5f02\u5e38", e);
            }
            return createdRequest;
        }
        throw new Exception("\u83b7\u53d6\u8fde\u63a5\u8d85\u65f6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() throws Exception {
        while (this.alive && this.currentConnection.get() < this.maxConnection) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.currentConnection.get() >= this.maxConnection) {
                    break;
                }
                try {
                    this.createConnection();
                }
                catch (NullPointerException e) {
                    throw new Exception("\u5efa\u7acb\u7b2c  " + (this.requestPool.size() + 1) + " \u4e2a\u8fde\u63a5\u5931\u8d25", e);
                }
                catch (Exception e) {
                    throw e;
                }
            }
        }
    }

    public SocketWrapper createConnection() throws Exception {
        SocketWrapper wrapper = null;
        try {
            Socket socket = this.createSocket();
            wrapper = new SocketWrapper(socket);
            if (ONLY_WRITE.equals(this.actionType)) {
                this.socketReadThread = new Thread(new SocketReader(wrapper));
                this.socketReadThread.start();
            } else {
                socket.setSoTimeout(this.getTimeout());
            }
            this.requestPool.add(wrapper);
            this.semaphore.release();
            this.currentConnection.incrementAndGet();
        }
        catch (NumberFormatException e) {
            throw new Exception("\u521b\u5efa\u65b0\u8fde\u63a5\u65f6,\u4e3b\u673a[" + this.getHost() + ":" + this.getPort() + "]\u89e3\u6790\u5f02\u5e38", e);
        }
        catch (UnknownHostException e) {
            throw new Exception("\u521b\u5efa\u65b0\u8fde\u63a5\u65f6,\u672a\u77e5\u4e3b\u673a\u540d[" + this.getHost() + "]", e);
        }
        catch (IOException e) {
            throw new Exception("\u521b\u5efa\u65b0\u8fde\u63a5\u65f6,\u4e0e\u4e3b\u673a[" + this.getHost() + ":" + this.getPort() + "]\u901a\u8baf\u9519\u8bef", e);
        }
        return wrapper;
    }

    public Socket createSocket() throws Exception {
        Socket socket = new Socket();
        InetSocketAddress socketAddr = new InetSocketAddress(InetAddress.getByName(this.getHost()), Integer.parseInt(this.getPort()));
        if (!StringTools.isEmpty(this.localIP) && !StringTools.isEmpty(this.localPort)) {
            InetSocketAddress localSocketAddr = new InetSocketAddress(InetAddress.getByName(this.localIP), Integer.parseInt(this.localPort));
            socket.bind(localSocketAddr);
        }
        socket.connect(socketAddr, 10000);
        socket.setKeepAlive(true);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        StreamRequest returnRequest = (StreamRequest)request;
        SocketWrapper wrapper = (SocketWrapper)returnRequest.getDatasourceWrapper();
        if (this.isAvalible(returnRequest) && !wrapper.isClose()) {
            this.requestPool.add(wrapper);
            this.semaphore.release();
            this.logger.debug("{} @ \u5f52\u8fd8\u8fde\u63a5\u540e\u7684\u8bb8\u53ef\u6570\uff1a {},\u8fde\u63a5\u6570\uff1a {}", new Object[]{this.getAdapterName(), this.semaphore.availablePermits(), this.requestPool.size()});
            this.logger.debug("{} @ \u5f52\u8fd8\u8fde\u63a5 [{}] ", (Object)this.getAdapterName(), (Object)wrapper.getSocket());
        } else {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    returnRequest.close();
                    this.currentConnection.decrementAndGet();
                }
                catch (IOException e) {
                    this.logger.error(this.getAdapterName() + " @ \u5173\u95ed\u8fde\u63a5\u5f02\u5e38 :" + wrapper.getSocket(), (Throwable)e);
                }
            }
            this.logger.debug("{} @ \u6e05\u9664\u5f02\u5e38\u8fde\u63a5 [{}] ", (Object)this.getAdapterName(), (Object)wrapper.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.currentConnection.set(0);
        this.semaphore.drainPermits();
        if (this.connectionProducerFlag && this.connectionProducerThread != null) {
            this.connectionProducerThread.interrupt();
            this.connectionProducerThread = null;
        }
        if (this.autoHeartBeat && this.heartBeatThread != null) {
            this.heartBeatThread.interrupt();
            this.heartBeatMsg = null;
        }
        if (this.socketReadThread != null) {
            this.socketReadThread.interrupt();
            this.socketReadThread = null;
        }
        Object object = this.mutex;
        synchronized (object) {
            for (SocketWrapper wrapper : this.requestPool) {
                Socket socket = wrapper.getSocket();
                try {
                    if (socket == null || socket.isClosed()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    this.logger.error(this.getAdapterName() + " @ \u5173\u95ed\u8fde\u63a5\u6c60\u4e2d\u5269\u4f59\u8fde\u63a5[" + socket + "]\u5f02\u5e38", (Throwable)e);
                }
            }
            this.requestPool.clear();
        }
        this.logger.debug("{} @ \u957f\u8fde\u63a5\u5ba2\u6237\u7aef\u63a5\u51fa\u5173\u95ed", (Object)this.getAdapterName());
    }

    @Override
    public String getAdapterTypeName() {
        return OUT_ADAPTER_NAME;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(long sessionTime) {
        this.sessionTime = sessionTime;
    }

    public boolean isConnectionProducerFlag() {
        return this.connectionProducerFlag;
    }

    public void setConnectionProducerFlag(boolean connectionProducerFlag) {
        this.connectionProducerFlag = connectionProducerFlag;
    }

    public boolean isAutoHeartBeat() {
        return this.autoHeartBeat;
    }

    public void setAutoHeartBeat(boolean autoHeartBeat) {
        this.autoHeartBeat = autoHeartBeat;
    }

    public String getHeartBeatSrc() {
        return this.heartBeatSrc;
    }

    public void setHeartBeatSrc(String heartBeatSrc) {
        this.heartBeatSrc = heartBeatSrc;
    }

    public String getHeartBeatMsgFile() {
        return this.heartBeatMsgFile;
    }

    public void setHeartBeatMsgFile(String heartBeatMsgFile) {
        this.heartBeatMsgFile = heartBeatMsgFile;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public void setLocalIP(String localIP) {
        this.localIP = localIP;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public int getBeatInterval() {
        return this.beatInterval;
    }

    public void setBeatInterval(int beatInterval) {
        this.beatInterval = beatInterval;
    }

    public boolean isHeartManageConnection() {
        return this.heartManageConnection;
    }

    public void setHeartManageConnection(boolean heartManageConnection) {
        this.heartManageConnection = heartManageConnection;
    }

    public class SocketReader
    implements Runnable {
        private SocketWrapper wrapper;

        public SocketReader(SocketWrapper wrapper) {
            this.wrapper = wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            Socket socket = this.wrapper.getSocket();
            try {
                InputStream in = socket.getInputStream();
                int readCount = in.read();
                while (readCount >= 0) {
                    readCount = in.read();
                }
                this.removeRequest(this.wrapper);
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u5bf9\u65b9\u8fde\u63a5\u5df2\u5173\u95ed:" + socket, (Throwable)e);
                this.removeRequest(this.wrapper);
            }
            finally {
                LogbackUtil.removeLogInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRequest(SocketWrapper wrapper) {
            Socket socket = wrapper.getSocket();
            try {
                wrapper.setClose(true);
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u5173\u95ed\u8fde\u63a5[" + socket + "]\u5f02\u5e38 ", (Throwable)e);
            }
            Object object = LongClientOutAdapter.this.mutex;
            synchronized (object) {
                boolean flag = LongClientOutAdapter.this.semaphore.tryAcquire();
                if (flag) {
                    boolean remove = LongClientOutAdapter.this.requestPool.remove(wrapper);
                    if (remove) {
                        LongClientOutAdapter.this.currentConnection.decrementAndGet();
                    } else {
                        LongClientOutAdapter.this.semaphore.release();
                    }
                }
            }
            if (wrapper.getSessionId() != null) {
                LongClientOutAdapter.this.usedRequest.remove(wrapper.getSessionId());
            }
            LongClientOutAdapter.this.logger.debug("{} @ SocketReader\u6e05\u9664\u5f02\u5e38\u8fde\u63a5 [{}]", new Object[]{LongClientOutAdapter.this.getAdapterName(), socket});
        }
    }

    public class HeartBeatThread
    extends Thread {
        private int intervalTime;

        public HeartBeatThread(int intervalTime) {
            this.intervalTime = intervalTime;
        }

        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            while (LongClientOutAdapter.this.alive) {
                try {
                    Thread.sleep(this.intervalTime);
                    int count = LongClientOutAdapter.this.semaphore.availablePermits();
                    for (int i = 0; i < count && LongClientOutAdapter.this.semaphore.tryAcquire(); ++i) {
                        SocketWrapper wrapper = LongClientOutAdapter.this.requestPool.remove(0);
                        boolean result = this.sendHeartMessage(wrapper);
                        if (result) {
                            LongClientOutAdapter.this.requestPool.add(wrapper);
                            LongClientOutAdapter.this.semaphore.release();
                            continue;
                        }
                        try {
                            LongClientOutAdapter.this.currentConnection.decrementAndGet();
                            wrapper.getSocket().close();
                            continue;
                        }
                        catch (Throwable e1) {
                            LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u5fc3\u8df3\u53d1\u9001\u5931\u8d25,\u5173\u95ed\u8fde\u63a5[" + wrapper.getSocket() + "]\u5f02\u5e38:", e1);
                        }
                    }
                    if (!LongClientOutAdapter.this.isHeartManageConnection()) continue;
                    try {
                        LongClientOutAdapter.this.initConnection();
                    }
                    catch (Exception e) {
                        LongClientOutAdapter.this.logger.error("{} @ \u5fc3\u8df3\u5c1d\u8bd5\u91cd\u65b0\u5efa\u8fde\u63a5\u5f02\u5e38:{}", (Object)LongClientOutAdapter.this.getAdapterName(), (Object)e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u53d1\u9001\u5fc3\u8df3\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38 ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            LogbackUtil.removeLogInfo();
        }

        private boolean sendHeartMessage(SocketWrapper wrapper) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - wrapper.getLastUsedTime() >= (long)this.intervalTime) {
                wrapper.setLastUsedTime(currentTime);
                Socket socket = wrapper.getSocket();
                try {
                    OutputStream out = socket.getOutputStream();
                    out.write(LongClientOutAdapter.this.heartBeatMsg);
                    out.flush();
                    LongClientOutAdapter.this.logger.debug("{} @ \u8fde\u63a5[{}],\u5fc3\u8df3\u53d1\u9001\u6210\u529f", new Object[]{LongClientOutAdapter.this.getAdapterName(), socket});
                    return true;
                }
                catch (Throwable e) {
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u8fde\u63a5[" + socket + "],\u5fc3\u8df3\u53d1\u9001\u5931\u8d25:", e);
                    return false;
                }
            }
            return true;
        }
    }

    public class ConnectionProducer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            String sessionId = "AutoGeneratorID";
            HashMap<String, Object> context = new HashMap<String, Object>();
            Session session = new Session();
            session.setSessionId(sessionId);
            session.setContext(context);
            IRequest request = null;
            try {
                request = LongClientOutAdapter.this.makeRequest(session);
                SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
                request.setSessionId(sessionId);
                wrapper.setSessionId(sessionId);
                LongClientOutAdapter.this.getUsedRequest().put(sessionId, request);
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u542f\u52a8\u65f6\u5efa\u7acb\u8fde\u63a5\u5931\u8d25:", (Throwable)e);
            }
            finally {
                try {
                    if (request != null) {
                        LongClientOutAdapter.this.returnRequest(request);
                    }
                }
                catch (Exception e) {
                    SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ \u5f52\u8fd8\u8fde\u63a5[" + wrapper.getSocket() + "]\u5f02\u5e38:", (Throwable)e);
                }
                LogbackUtil.removeLogInfo();
            }
        }
    }
}

