/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.TCPInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.IpFilter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.net.Socket;
import java.util.Set;

public class ShortServerInAdapter
extends TCPInAdapter {
    private String IN_ADAPTER_NAME = "\u77ed\u8fde\u63a5\u670d\u52a1\u7aef\u63a5\u5165\u9002\u914d\u5668";
    protected Thread listenerThread;
    private String ipAddress;
    private Set<String> ipList;

    @Override
    public IRequest makeRequest() throws Exception {
        String ip;
        Socket socket = this.server.accept();
        if (this.getTimeout() > 0) {
            socket.setSoTimeout(this.timeout);
        }
        if (this.ipList != null && !IpFilter.checkIP(ip = socket.getInetAddress().getHostAddress(), this.ipList)) {
            this.logger.debug("{} @  \u8bf7\u6c42\u7aefIP[{}]\u672a\u51c6\u5165,\u4e0d\u63a5\u6536\u8bf7\u6c42\u3002", new Object[]{this.getAdapterTypeName(), ip});
            socket.close();
            return null;
        }
        SocketWrapper wrapper = new SocketWrapper(socket);
        StreamRequest request = new StreamRequest();
        request.setInAdapter(this);
        request.setDatasourceWrapper(wrapper);
        return request;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.setInAdapterNm(this.IN_ADAPTER_NAME);
        this.createServerSocket();
        if (!StringTools.isEmpty(this.ipAddress)) {
            this.ipList = IpFilter.init(this.ipAddress);
        }
        this.listenerThread = new Thread((Runnable)this, this.getSid() + "-" + this.getClass().getSimpleName() + ":" + this.getPort());
        this.listenerThread.start();
        if (this.getStrategy() == null) {
            throw new Exception(this.getAdapterTypeName() + " @ \u4ea4\u6613\u6620\u5c04\u7b56\u7565\u672a\u914d\u7f6e!");
        }
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        request.close();
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.listenerThread != null) {
                this.listenerThread.interrupt();
                this.listenerThread = null;
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ \u5173\u95ed\u5e94\u7528\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
        }
        super.doStop();
    }

    @Override
    public String getAdapterTypeName() {
        return this.IN_ADAPTER_NAME;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }
}

