/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.TCPInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.IpFilter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class LongServerInAdapter
extends TCPInAdapter {
    private String IN_ADAPTER_NAME = "\u957f\u8fde\u63a5\u670d\u52a1\u7aef\u63a5\u5165\u9002\u914d\u5668";
    protected List<SocketWrapper> requestPool = Collections.synchronizedList(new ArrayList());
    protected int maxConnection;
    protected Thread socketListenerThread;
    protected Thread socketBorrowThread;
    protected AtomicInteger currentConnection = new AtomicInteger(0);
    protected Semaphore semaphore;
    private Object mutex = new Object();
    private String ipAddress;
    private Set<String> ipList;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.maxConnection <= 0) {
            throw new Exception(this.getAdapterTypeName() + " @ \u6700\u5927\u8fde\u63a5\u6570\u975e\u6cd5[" + this.maxConnection + "]");
        }
        if (!StringTools.isEmpty(this.ipAddress)) {
            this.ipList = IpFilter.init(this.ipAddress);
        }
        this.semaphore = new Semaphore(this.maxConnection, true);
        this.semaphore.drainPermits();
        this.createServerSocket();
        this.socketListenerThread = new Thread((Runnable)new SocketListener(), this.getSid() + "-SocketListener:" + this.getPort());
        this.socketListenerThread.start();
        this.socketBorrowThread = new Thread((Runnable)this, this.getSid() + "-" + this.getClass().getSimpleName() + ":" + this.getPort());
        this.socketBorrowThread.start();
        if (this.getStrategy() == null) {
            throw new Exception(this.getAdapterTypeName() + " @ \u4ea4\u6613\u6620\u5c04\u7b56\u7565\u672a\u914d\u7f6e!");
        }
        this.logger.debug("{} @ \u63a5\u5165\u9002\u914d\u5668\u542f\u52a8", (Object)this.getAdapterTypeName());
    }

    @Override
    protected boolean checkSocketWrapper(SocketWrapper wrapper) throws Exception {
        if (this.currentConnection.get() >= this.maxConnection) {
            this.logger.warn("{} @ \u8fde\u63a5\u6570\u5df2\u8fbe\u5230\u6700\u5927\u503c,\u4e0d\u63a5\u6536\u65b0\u8fde\u63a5[{}]", (Object)this.getAdapterTypeName(), (Object)wrapper.getSocket());
            return false;
        }
        return true;
    }

    public Socket acceptSocket() throws Exception {
        Socket socket = this.server.accept();
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.getTimeout());
        return socket;
    }

    @Override
    public IRequest makeRequest() throws Exception {
        this.semaphore.acquire();
        SocketWrapper wrapper = this.requestPool.remove(0);
        StreamRequest borrowedRequest = new StreamRequest();
        borrowedRequest.setTimeStart(false);
        borrowedRequest.setDatasourceWrapper(wrapper);
        borrowedRequest.setInAdapter(this);
        return borrowedRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        StreamRequest returnRequest = (StreamRequest)request;
        SocketWrapper returnWrapper = (SocketWrapper)returnRequest.getDatasourceWrapper();
        Socket returnSocket = returnWrapper.getSocket();
        if (this.isAvalible(returnRequest)) {
            this.logger.debug("{} @ \u5f52\u8fd8\u8fde\u63a5[{}]", (Object)this.getAdapterTypeName(), (Object)returnSocket);
            this.requestPool.add(returnWrapper);
            this.semaphore.release();
        } else {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.currentConnection.decrementAndGet();
                    returnRequest.close();
                    this.logger.debug("{} @ \u5173\u95ed\u8fde\u63a5[{}]", (Object)this.getAdapterTypeName(), (Object)returnSocket);
                }
                catch (IOException e) {
                    this.logger.debug(this.getAdapterTypeName() + " @ \u5173\u95ed\u8fde\u63a5" + returnSocket + "\u65f6\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.currentConnection.set(0);
        this.semaphore.drainPermits();
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.socketListenerThread != null) {
                this.socketListenerThread.interrupt();
                this.socketListenerThread = null;
            }
            if (this.socketBorrowThread != null) {
                this.socketBorrowThread.interrupt();
                this.socketBorrowThread = null;
            }
            Object object = this.mutex;
            synchronized (object) {
                for (SocketWrapper stopWrapper : this.requestPool) {
                    Socket stopSocket = stopWrapper.getSocket();
                    if (stopSocket == null || stopSocket.isClosed()) continue;
                    stopSocket.close();
                }
                this.requestPool.clear();
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ \u63a5\u5165\u9002\u914d\u5668\u505c\u6b62\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            throw e;
        }
        this.logger.debug("{} @ \u63a5\u5165\u9002\u914d\u5668\u7ed3\u675f", (Object)this.getAdapterTypeName());
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    @Override
    public String getAdapterTypeName() {
        return this.IN_ADAPTER_NAME;
    }

    public int getRequestPoolSize() {
        return this.requestPool == null ? 0 : this.requestPool.size();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        @Override
        public void run() {
            String moduleLog = LongServerInAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongServerInAdapter.this.bundlerId, LongServerInAdapter.this.moduleId, moduleLog, "", "        ", null);
            LongServerInAdapter.this.logger.info("{} @ \u76d1\u542c\u670d\u52a1\u542f\u52a8:{}", new Object[]{LongServerInAdapter.this.getAdapterTypeName(), LongServerInAdapter.this.server});
            while (LongServerInAdapter.this.alive) {
                try {
                    String ip;
                    Socket socket = LongServerInAdapter.this.acceptSocket();
                    SocketWrapper wrapper = new SocketWrapper(socket);
                    if (!LongServerInAdapter.this.checkSocketWrapper(wrapper)) {
                        socket.close();
                        continue;
                    }
                    if (LongServerInAdapter.this.ipList != null && !IpFilter.checkIP(ip = socket.getInetAddress().getHostAddress(), LongServerInAdapter.this.ipList)) {
                        LongServerInAdapter.this.logger.debug("{} @  \u8bf7\u6c42\u7aefIP[{}]\u672a\u51c6\u5165,\u4e0d\u63a5\u6536\u8bf7\u6c42\u3002", new Object[]{LongServerInAdapter.this.getAdapterTypeName(), ip});
                        socket.close();
                        continue;
                    }
                    LongServerInAdapter.this.currentConnection.incrementAndGet();
                    LongServerInAdapter.this.requestPool.add(wrapper);
                    LongServerInAdapter.this.semaphore.release();
                }
                catch (NullPointerException e) {
                    LongServerInAdapter.this.logger.error("{} @ \u7a7a\u6307\u9488\u5f02\u5e38", (Object)LongServerInAdapter.this.getAdapterTypeName(), (Object)e);
                    break;
                }
                catch (Throwable e) {
                    if (!LongServerInAdapter.this.isAlive()) continue;
                    LongServerInAdapter.this.logger.error("{} @ \u76d1\u542c\u670d\u52a1\u5f02\u5e38 ", (Object)LongServerInAdapter.this.getAdapterTypeName(), (Object)e);
                }
            }
            LongServerInAdapter.this.logger.info("{} @ \u76d1\u542c\u670d\u52a1\u5173\u95ed", new Object[]{LongServerInAdapter.this.getAdapterTypeName()});
            LogbackUtil.removeLogInfo();
        }
    }
}

