/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication;

import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.resources.core.ResourceHolder;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMapping;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMappings;
import cn.com.yusys.yusp.bsp.resources.sn.FileSnGenerator;
import cn.com.yusys.yusp.bsp.resources.sn.ISnGenerator;
import cn.com.yusys.yusp.bsp.schema.mapping.Item;
import cn.com.yusys.yusp.bsp.schema.mapping.Items;
import cn.com.yusys.yusp.bsp.schema.mapping.Mapping;
import cn.com.yusys.yusp.bsp.schema.mapping.Property;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.comm.HttpComm;
import cn.com.yusys.yusp.bsp.workflow.comm.UnFixComm;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.mapping.IMappingStrategy;
import cn.com.yusys.yusp.bsp.workflow.mapping.MappingParam;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdapter
extends AbstractBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String commType;
    private String method;
    private String contentType;
    private static final String UNPACKMSGNM = "unpackMsgNm";
    private static final String PACKMSGNM = "packMsgNm";
    private static final String INVOKETYPE = "invokeType";
    private static final String BEANID = "beanId";
    private static final String MAPPINGID = "mappingId";
    private IMappingStrategy strategy;
    protected ISnGenerator snGenerator;
    private ResourceHolder holder;
    private Object mutex = new Object();

    @Override
    public void doStart() throws Exception {
        this.snGenerator = new FileSnGenerator();
        ((FileSnGenerator)this.snGenerator).setMaxValue(99999999L);
        ((FileSnGenerator)this.snGenerator).setMinValue(1L);
        ((FileSnGenerator)this.snGenerator).setInterval(100);
        ((FileSnGenerator)this.snGenerator).setFormatStr("00000000");
        ((FileSnGenerator)this.snGenerator).setFileName("key.ser");
        ((FileSnGenerator)this.snGenerator).doStart();
        this.dealMapping();
    }

    @Override
    public void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealMapping() throws Exception {
        CacheMappings mappings;
        CacheMapping mapping;
        if (this.holder == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.holder == null) {
                    ResourceHolder tmpHolder;
                    this.holder = tmpHolder = ResourcePortal.findMyResourceHolder();
                }
            }
        }
        if ((mapping = (CacheMapping)(mappings = (CacheMappings)this.holder.getResource("mpd", "config/datagram/mapping.mpd")).getMap().get(this.getBeanName())) == null) {
            throw new ComponentException("\u6620\u5c04\u8868\u4e0d\u5b58\u5728:" + this.getBeanName());
        }
        this.processResult(mapping);
    }

    private void processResult(Mapping mapping) throws ComponentException {
        Items items = mapping.getItems();
        Item[] itemArr = items.getItem();
        for (int i = 0; i < itemArr.length; ++i) {
            Item item = itemArr[i];
            Property[] propertyArr = item.getProperty();
            MappingParam param = new MappingParam();
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int j = 0; j < propertyArr.length; ++j) {
                Property property = propertyArr[j];
                tmp.put(property.getName(), property.getValue());
            }
            String mappingId = this.getBeanName() + (String)tmp.get(MAPPINGID);
            param.setMappingId(mappingId);
            param.setBeanId((String)tmp.get(BEANID));
            param.setInvokeType((String)tmp.get(INVOKETYPE));
            param.setPackMsgNm((String)tmp.get(PACKMSGNM));
            param.setUnpackMsgNm((String)tmp.get(UNPACKMSGNM));
            IComm comm = null;
            if ("http".equals(this.commType)) {
                comm = new HttpComm();
                ((HttpComm)comm).setMethod(this.getMethod());
                ((HttpComm)comm).setContentType(this.getContentType());
                ((HttpComm)comm).setUnitName("Http\u901a\u8baf");
            } else if ("socket".equals(this.commType)) {
                comm = new UnFixComm();
                ((UnFixComm)comm).setUnitName("Socket\u901a\u8baf");
            } else {
                this.logger.error("\u901a\u8baf\u7c7b\u578b[" + this.commType + "]\u6682\u4e0d\u652f\u6301");
                throw new ComponentException("\u901a\u8baf\u7c7b\u578b[" + this.commType + "]\u6682\u4e0d\u652f\u6301");
            }
            ResourcePortal.getInstance().getCommRegistry().registryComm(this.getBeanName(), comm);
            ResourcePortal.getInstance().getMappingRegistry().registryMapping(param);
        }
    }

    public String getCommType() {
        return this.commType;
    }

    public void setCommType(String commType) {
        this.commType = commType;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public IMappingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(IMappingStrategy strategy) {
        this.strategy = strategy;
    }

    public ISnGenerator getSnGenerator() {
        return this.snGenerator;
    }

    public void setSnGenerator(ISnGenerator snGenerator) {
        this.snGenerator = snGenerator;
    }
}

