/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sensitinfo;

import cn.com.yusys.yusp.commons.sensitinfo.SensitiveFilter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDefaultFilter
implements SensitiveFilter {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDefaultFilter.class);
    private static String SPECIAL_VALUE_CHAR = "@#$%^&*!";
    private static String START_VALUE_CHAR = "=:>";
    private static String IGNORE_VALUE_CHAR = "\" ";

    @Override
    public String doInforFilter(String jsonStr, Set<String> sensitInforSet) {
        try {
            return this.parser(jsonStr.getBytes(), sensitInforSet);
        }
        catch (Exception e) {
            log.error("Customer sensitive information filtering failed", (Throwable)e);
            return jsonStr;
        }
    }

    private String parser(byte[] bytes, Set<String> sensitInforSet) {
        byte[] bb = new byte[512];
        int length = bytes.length;
        boolean skip = false;
        boolean erase = false;
        int state = 0;
        int blength = 0;
        for (int index = 0; index < length; ++index) {
            byte b = bytes[index];
            if ((b >= 65 && b <= 90 || b >= 97 && b <= 122) && state == 0) {
                state = 1;
                if (index >= 2 && bytes[index - 2] == 60 && bytes[index - 1] == 47) {
                    state = 0;
                }
                blength = 0;
            } else if (!(b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || state != 1)) {
                String nodeName = new String(bb, 0, blength);
                if (sensitInforSet.contains(nodeName)) {
                    skip = true;
                    state = 2;
                } else {
                    skip = false;
                    state = 0;
                }
                blength = 0;
            }
            if (state == 1) {
                bb[blength++] = b;
                continue;
            }
            if (state != 2 || !skip) continue;
            int b1 = b & 0xFF;
            if (b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b1 > 128 && b1 < 254 || b1 > 64 && b1 < 254 || SPECIAL_VALUE_CHAR.indexOf(b) > -1) {
                bytes[index] = 42;
                erase = true;
                continue;
            }
            if (START_VALUE_CHAR.indexOf(b) > -1 && !erase) {
                erase = true;
                continue;
            }
            if (!erase || IGNORE_VALUE_CHAR.indexOf(b) != -1) continue;
            skip = false;
            erase = false;
            state = 0;
        }
        return new String(bytes);
    }
}

