/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtil;
import cn.com.yusys.yusp.commons.web.rest.exception.YuspCommonException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(String srcRootDir, File file, ZipOutputStream zos) throws Exception {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            int bufferLen = 1024;
            byte[] data = new byte[bufferLen];
            String subPath = file.getAbsolutePath();
            int index = subPath.indexOf(srcRootDir);
            if (index != -1) {
                subPath = subPath.substring(srcRootDir.length() + File.separator.length());
            }
            ZipEntry entry = new ZipEntry(subPath);
            zos.putNextEntry(entry);
            BufferedInputStream bis = null;
            try {
                int count;
                bis = new BufferedInputStream(new FileInputStream(file));
                while ((count = bis.read(data, 0, bufferLen)) != -1) {
                    zos.write(data, 0, count);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    zos.closeEntry();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            File[] childFileList = file.listFiles();
            for (int n = 0; n < childFileList.length; ++n) {
                ZipUtil.zip(srcRootDir, childFileList[n], zos);
            }
        }
    }

    public static void zip(String srcPath, String zipPath, String zipFileName) throws YuspCommonException {
        String zipFilePath;
        File zipFile;
        if (StringUtils.isEmpty((CharSequence)srcPath) || StringUtils.isEmpty((CharSequence)zipPath) || StringUtils.isEmpty((CharSequence)zipFileName)) {
            throw new YuspCommonException("PARAMETER IS NULL", new Object[0]);
        }
        File srcFile = new File(srcPath);
        if (srcFile.isDirectory() && zipPath.indexOf(srcPath) != -1) {
            throw new YuspCommonException("INVALID_PARAMETER,zipPath must not be the child directory of srcPath.", new Object[0]);
        }
        File zipDir = new File(zipPath);
        if (!zipDir.exists() || !zipDir.isDirectory()) {
            zipDir.mkdirs();
        }
        if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
            SecurityManager securityManager = new SecurityManager();
            securityManager.checkDelete(zipFilePath);
            try {
                Files.delete(zipFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Failed to delete file");
                e.printStackTrace();
            }
        }
        try (CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
             ZipOutputStream zos = new ZipOutputStream(cos);){
            int index;
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipUtil.zip(srcRootDir, srcFile, zos);
            zos.flush();
        }
        catch (Exception e) {
            throw new YuspCommonException("File compression failed", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(String zipFilePath, String unzipFilePath, boolean includeZipFileName) throws Exception {
        File unzipFileDir;
        if (StringUtils.isEmpty((CharSequence)zipFilePath) || StringUtils.isEmpty((CharSequence)unzipFilePath)) {
            throw new YuspCommonException("PARAMETER IS NULL", new Object[0]);
        }
        File zipFile = new File(zipFilePath);
        if (includeZipFileName) {
            String fileName = zipFile.getName();
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            unzipFilePath = unzipFilePath + File.separator + fileName;
        }
        if (!(unzipFileDir = new File(unzipFilePath)).exists() || !unzipFileDir.isDirectory()) {
            unzipFileDir.mkdirs();
        }
        ZipEntry entry = null;
        String entryFilePath = null;
        String entryDirPath = null;
        File entryFile = null;
        File entryDir = null;
        int index = 0;
        int count = 0;
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                entryFilePath = unzipFilePath + File.separator + entry.getName();
                index = entryFilePath.lastIndexOf(File.separator);
                entryDirPath = index != -1 ? entryFilePath.substring(0, index) : "";
                entryDir = new File(entryDirPath);
                if (!entryDir.exists() || !entryDir.isDirectory()) {
                    entryDir.mkdirs();
                }
                if ((entryFile = new File(entryFilePath)).exists()) {
                    SecurityManager securityManager = new SecurityManager();
                    securityManager.checkDelete(entryFilePath);
                    Files.delete(entryFile.toPath());
                }
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(entryFile));
                    Throwable throwable = null;
                    try {
                        BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(entry));
                        Throwable throwable2 = null;
                        try {
                            while ((count = bis.read(buffer, 0, bufferSize)) != -1) {
                                bos.write(buffer, 0, count);
                            }
                            bos.flush();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (bis == null) continue;
                            if (throwable2 != null) {
                                try {
                                    bis.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            bis.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Exception e) {
                    throw new YuspCommonException("File decompression failed", e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new YuspCommonException("File decompression failed", e);
        }
    }

    public static void compressZip(String needZipPath, String targetPath, String fileName) throws Exception {
        String targetFile = StringUtil.builder(100, targetPath, File.separator, fileName);
        Files.deleteIfExists(Paths.get(targetFile, new String[0]));
        ZipOutputStream zipOutput = null;
        try {
            zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
            File srcFile = new File(needZipPath);
            ZipUtil.compressZip(zipOutput, srcFile, srcFile.getName());
            zipOutput.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zipOutput != null) {
                zipOutput.closeEntry();
                zipOutput.close();
            }
        }
    }

    private static void compressZip(ZipOutputStream zipOutput, File file, String base) throws Exception {
        if (file.isDirectory()) {
            File[] listFiles;
            for (File fi : listFiles = file.listFiles()) {
                if (fi.isDirectory()) {
                    ZipUtil.compressZip(zipOutput, fi, base + "/" + fi.getName());
                    continue;
                }
                ZipUtil.zip(zipOutput, fi, base);
            }
        } else {
            ZipUtil.zip(zipOutput, file, base);
        }
    }

    public static void zip(ZipOutputStream zipOutput, File file, String base) throws Exception {
        ZipEntry zEntry = new ZipEntry(base + File.separator + file.getName());
        zipOutput.putNextEntry(zEntry);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                zipOutput.write(buffer, 0, read);
            }
        }
    }
}

