/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ip;

import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class CloudIpEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private String ipProperty = "eureka.instance.ip-address";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.containsProperty(this.ipProperty)) {
            String ipAddress = environment.getProperty(this.ipProperty);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("spring.cloud.client.ip-address", ipAddress);
            MapPropertySource propertySource = new MapPropertySource("eurekaInstanceIp", map);
            environment.getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    public int getOrder() {
        return -2147483640;
    }
}

