/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String PATTERN_DEFAULT = "yyyy-MM-dd";
    public static final String PATTERN_DAYPATH = "yyyy\\MM\\dd\\";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_TIME_COMPACT = "HHmmss";
    public static final String PATTERN_DATETIME_COMPACT = "yyyyMMddHHmmss";
    public static final String PATTERN_DATETIME_COMPACT_SSS = "yyyyMMddHHmmssSSS";
    public static final String PATTERN_DATE_COMPACT = "yyyyMMdd";
    public static final String PATTERN_DATESHORT = "yyMMdd";
    public static final String PATTERN_YEARMONTH = "yyyyMM";
    public static final String[] MONTHS_STRING = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    private DateUtil() {
    }

    public static final int getCurrYear() {
        return DateUtil.getYear(new Date());
    }

    public static final int getYear(Date date) {
        return DateUtil.get(date, 1);
    }

    public static final int getCurrMonth() {
        return DateUtil.getMonth(new Date());
    }

    public static final int getMonth(Date date) {
        return DateUtil.get(date, 2) + 1;
    }

    public static final int getCurrMonthDay() {
        return DateUtil.getMonthDay(new Date());
    }

    public static final int getMonthDay(Date date) {
        return DateUtil.get(date, 5);
    }

    public static final int getCurrYearDay() {
        return DateUtil.getYearDay(new Date());
    }

    public static final int getYearDay(Date date) {
        return DateUtil.get(date, 6);
    }

    public static final int getDayHour(Date date) {
        return DateUtil.get(date, 11);
    }

    public static final int getCurrDayHour() {
        return DateUtil.getDayHour(new Date());
    }

    public static final int getCurrMinute() {
        return DateUtil.getMinute(new Date());
    }

    public static final int getMinute(Date date) {
        return DateUtil.get(date, 12);
    }

    public static final int getCurrSecond() {
        return DateUtil.getSecond(new Date());
    }

    public static final int getSecond(Date date) {
        return DateUtil.get(date, 13);
    }

    public static final int get(Date date, int field) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static final Date addYear(int amount) {
        return DateUtil.addYear(new Date(0L), amount);
    }

    public static final Date addYear(Date date, int amount) {
        return DateUtil.add(date, 1, amount);
    }

    public static final String addYear(String date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addYear(DateUtil.parseDate(date, pattern), amount), pattern);
    }

    public static final String addYear(Date date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addYear(date, amount), pattern);
    }

    public static final Date addMonth(int amount) {
        return DateUtil.addMonth(new Date(0L), amount);
    }

    public static final Date addMonth(Date date, int amount) {
        return DateUtil.add(date, 2, amount);
    }

    public static final String addMonth(String date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addMonth(DateUtil.parseDate(date, pattern), amount), pattern);
    }

    public static final String addMonth(Date date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addMonth(date, amount), pattern);
    }

    public static final Date addDay(int amount) {
        return DateUtil.addDay(new Date(0L), amount);
    }

    public static final Date addDay(Date date, int amount) {
        return DateUtil.add(date, 5, amount);
    }

    public static final String addDay(String date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addDay(DateUtil.parseDate(date, pattern), amount), pattern);
    }

    public static final String addDay(Date date, String pattern, int amount) {
        return DateUtil.formatDate(DateUtil.addDay(date, amount), pattern);
    }

    public static final Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static final String formatDate(String pattern) {
        return DateUtil.formatDate(new Date(), pattern);
    }

    public static final String formatDate(Date date, String pattern) {
        return Objects.nonNull(date) ? new SimpleDateFormat(pattern, Locale.CHINA).format(date) : null;
    }

    public static final String formatDateByDef() {
        return DateUtil.formatDate(PATTERN_DEFAULT);
    }

    public static final String formatDateByDef(Date date) {
        return DateUtil.formatDate(date, PATTERN_DEFAULT);
    }

    public static final String formatDateTimeByDef() {
        return DateUtil.formatDate(PATTERN_DATETIME);
    }

    public static final String formatDateTimeByDef(Date date) {
        return DateUtil.formatDate(date, PATTERN_DATETIME);
    }

    public static final Date parseDate(String date, String pattern) {
        try {
            return StringUtil.isNotEmpty(date) ? new SimpleDateFormat(pattern).parse(date) : null;
        }
        catch (Exception e) {
            logger.warn("\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38[{}][{}],msg:[{}].", new Object[]{date, pattern, e.getMessage()});
            return null;
        }
    }

    public static final Date parseDateByDef(String date) {
        return DateUtil.parseDate(date, PATTERN_DEFAULT);
    }

    public static final Date parseDateTimeByDef(String date) {
        return DateUtil.parseDate(date, PATTERN_DATETIME);
    }

    public static final int getMonthsByTwoDates(Date startDate, Date endDate) {
        int month = 0;
        Calendar start = Calendar.getInstance(Locale.CHINA);
        Calendar end = Calendar.getInstance(Locale.CHINA);
        start.setTime(startDate);
        end.setTime(endDate);
        month = (end.get(1) - start.get(1)) * 12 + end.get(2) - start.get(2);
        start.add(2, month);
        return start.after(end) ? month - 1 : month;
    }

    public static final int getMonthsByTwoDates(String startDate, String endDate, String pattern) {
        return DateUtil.getMonthsByTwoDates(startDate, pattern, endDate, pattern);
    }

    public static final int getMonthsByTwoDates(String startDate, String startPattern, String endDate, String endPattern) {
        return DateUtil.getMonthsByTwoDates(DateUtil.parseDate(startDate, startPattern), DateUtil.parseDate(endDate, endPattern));
    }

    public static final int getMonthsByTwoDatesDef(String startDate, String endDate) {
        return DateUtil.getMonthsByTwoDates(startDate, endDate, PATTERN_DEFAULT);
    }

    public static final int getDaysByTwoDates(Date startDate, Date endDate) {
        if (Objects.isNull(startDate)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
        }
        if (Objects.isNull(endDate)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
        }
        return (int)((startDate.getTime() - endDate.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static final int getDaysByTwoDates(String startDate, String endDate, String pattern) {
        return DateUtil.getDaysByTwoDates(startDate, pattern, endDate, pattern);
    }

    public static final int getDaysByTwoDates(String startDate, String startPattern, String endDate, String endPattern) {
        return DateUtil.getDaysByTwoDates(DateUtil.parseDate(startDate, startPattern), DateUtil.parseDate(endDate, endPattern));
    }

    public static final int getDaysByTwoDatesDef(String startDate, String endDate) {
        return DateUtil.getDaysByTwoDates(startDate, endDate, PATTERN_DEFAULT);
    }

    public static final boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static final boolean isLeapYear(String year) {
        return StringUtil.isNotEmpty(year) ? DateUtil.isLeapYear(Integer.valueOf(year)) : false;
    }

    public static final String getYesterday(String date) throws Exception {
        return DateUtil.getYesterday(date, PATTERN_DEFAULT);
    }

    public static final String getYesterday(Date date) throws Exception {
        return DateUtil.formatDate(DateUtil.getYesterday(date, PATTERN_DEFAULT), PATTERN_DEFAULT);
    }

    public static final String getYesterday(String date, String pattern) throws Exception {
        return DateUtil.addDay(date, pattern, -1);
    }

    public static final Date getYesterday(Date date, String pattern) throws Exception {
        return DateUtil.addDay(date, -1);
    }

    public static final String getTomorrow(String date) throws Exception {
        return DateUtil.getTomorrow(date, PATTERN_DEFAULT);
    }

    public static final String getTomorrow(Date date) throws Exception {
        return DateUtil.formatDate(DateUtil.getTomorrow(date, PATTERN_DEFAULT), PATTERN_DEFAULT);
    }

    public static final String getTomorrow(String date, String pattern) throws Exception {
        return DateUtil.addDay(date, pattern, 1);
    }

    public static final Date getTomorrow(Date date, String pattern) throws Exception {
        return DateUtil.addDay(date, 1);
    }

    public static final int getEndMonthOfQuarter(int month) {
        return ((month - 1) / 3 + 1) * 3;
    }

    public static final int getEndMonthOfQuarter(String month) {
        return DateUtil.getEndMonthOfQuarter(Integer.valueOf(month));
    }

    public static final String getCurrDateStr() {
        return DateUtil.formatDateByDef();
    }

    public static final String getCurrDateTimeStr() {
        return DateUtil.formatDateTimeByDef();
    }

    public static final String getCurrTime() {
        return DateUtil.formatDate(PATTERN_TIME);
    }

    public static final String getTimeStampByPattern(String pattern) {
        return DateUtil.formatDate(pattern);
    }

    public static final String getCurrStringMonth() {
        return DateUtil.getStringMonth(DateUtil.getCurrMonth() - 1);
    }

    public static final String getStringMonth(Date date) {
        return DateUtil.getStringMonth(DateUtil.getMonth(date) - 1);
    }

    public static final String getStringMonth(int month) {
        return MONTHS_STRING[month];
    }

    public static final String getStringMonth(String month) {
        return DateUtil.getStringMonth(Integer.valueOf(month));
    }

    public static final String bZeroMonth(int month) {
        return month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
    }

    public static int getMonthTotalDays(int year, int month) {
        int days = 1;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                days = 31;
                break;
            }
            case 2: {
                days = DateUtil.isLeapYear(year) ? 29 : 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                days = 30;
            }
        }
        return days;
    }

    public static final String formatDate8To10(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDateByDef(DateUtil.parseDate(date, PATTERN_DATE_COMPACT)) : null;
    }

    public static final String formatDate10To8(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDate(DateUtil.parseDateByDef(date), PATTERN_DATE_COMPACT) : null;
    }

    public static final String formatDateTime14To19(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDate(DateUtil.parseDate(date, PATTERN_DATETIME_COMPACT), PATTERN_DATETIME) : null;
    }

    public static final String formatDateTime19To14(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDate(DateUtil.parseDate(date, PATTERN_DATETIME), PATTERN_DATETIME_COMPACT) : null;
    }

    public static final String formatTime6To8(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDate(DateUtil.parseDate(date, PATTERN_TIME_COMPACT), PATTERN_TIME) : null;
    }

    public static final String formatTime8To6(String date) {
        return StringUtil.isNotEmpty(date) ? DateUtil.formatDate(DateUtil.parseDate(date, PATTERN_TIME), PATTERN_TIME_COMPACT) : null;
    }

    public static final boolean checkDate(String dateStr) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher matcher = pattern.matcher(dateStr);
        return matcher.matches();
    }

    public static final String getStartDateByMonths(Date endDate, int months) {
        return DateUtil.formatDateByDef(DateUtil.addMonth(endDate, 0 - months));
    }

    public static final String getStartDateByMonths(String endDate, int months) {
        return DateUtil.getStartDateByMonths(DateUtil.parseDateByDef(endDate), months);
    }

    public static final String getStartDateByMonths(String endDate, String pattern, int months) {
        return DateUtil.formatDate(DateUtil.addMonth(DateUtil.parseDate(endDate, pattern), 0 - months), pattern);
    }

    public static final Date object2Date(Object object, String pattern) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Calendar) {
            Calendar cal = (Calendar)object;
            date = cal.getTime();
        } else if (object instanceof String) {
            String str = String.valueOf(object);
            date = DateUtil.parseDate(str, pattern);
        }
        return date;
    }

    public static final Date getCurrDate() {
        return new Date();
    }

    public static final Timestamp getCurrTimestamp() {
        return new Timestamp(DateUtil.getCurrDate().getTime());
    }
}

