/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.executor.ExceptionHandlingAsyncTaskExecutor;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@EnableScheduling
@ConditionalOnProperty(name={"application.async.enabled"}, havingValue="true")
public class AsyncAutoConfiguration
implements AsyncConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(AsyncAutoConfiguration.class);
    private final ApplicationProperties applicationProperties;

    public AsyncAutoConfiguration(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Bean(name={"taskExecutor"})
    @ConditionalOnMissingBean
    public Executor taskExecutor() {
        logger.debug("Creating Async Task Executor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.applicationProperties.getAsync().getCorePoolSize());
        executor.setMaxPoolSize(this.applicationProperties.getAsync().getMaxPoolSize());
        executor.setQueueCapacity(this.applicationProperties.getAsync().getQueueCapacity());
        executor.setThreadNamePrefix("microservice-Executor-");
        logger.info("\u81ea\u52a8\u914d\u7f6e>> \u7ebf\u7a0b\u6c60\u914d\u7f6e\u5b8c\u6210");
        return new ExceptionHandlingAsyncTaskExecutor((AsyncTaskExecutor)executor);
    }

    public Executor getAsyncExecutor() {
        return null;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }
}

