/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@ConditionalOnProperty(name={"application.filter.cors.enabled"}, havingValue="true")
@ConditionalOnMissingBean(value={CorsFilter.class})
public class CorsAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationProperties properties;

    public CorsAutoConfiguration(ApplicationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = this.properties.getCors();
        if (config.getAllowedOrigins() != null && !config.getAllowedOrigins().isEmpty()) {
            source.registerCorsConfiguration("/api/**", config);
            source.registerCorsConfiguration("/v2/api-docs", config);
            source.registerCorsConfiguration("/oauth/**", config);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public FilterRegistrationBean corsFilterBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.corsFilter(), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        this.log.info("\u81ea\u52a8\u914d\u7f6e>> \u8de8\u57df\u914d\u7f6e\u5b8c\u6210 -> order [{}]", (Object)Integer.MIN_VALUE);
        return bean;
    }
}

