/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.NumberUtil;
import cn.com.yusys.yusp.commons.util.SM4;
import cn.com.yusys.yusp.commons.util.SM4Context;
import cn.com.yusys.yusp.commons.web.rest.exception.YuspCommonException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class SM4Util {
    private static final String PATTERN = "\\s*|\t|\r|\n";

    public static String encryptData_ECB(String secretKey, String data, String enCoding, boolean hexString) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? NumberUtil.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new YuspCommonException("SM4\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String decryptData_ECB(String secretKey, String data, String enCoding, boolean hexString) throws YuspCommonException {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? NumberUtil.hexToByte(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64((String)data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new YuspCommonException("SM4\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String encryptData_CBC(String secretKey, String iv, String data, String enCoding, boolean hexString) throws YuspCommonException {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = NumberUtil.hexToByte(secretKey);
                ivBytes = NumberUtil.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, data.getBytes(enCoding));
            String cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile(PATTERN);
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            throw new YuspCommonException("SM4\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String decryptData_CBC(String secretKey, String iv, String data, String enCoding, boolean hexString) throws YuspCommonException {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = NumberUtil.hexToByte(secretKey);
                ivBytes = NumberUtil.hexToByte(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)data));
            return new String(decrypted, enCoding);
        }
        catch (Exception e) {
            throw new YuspCommonException("SM4\u89e3\u5bc6\u5931\u8d25", e);
        }
    }
}

