/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class AppStartMessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(AppStartMessageUtil.class);

    private AppStartMessageUtil() {
    }

    public static String updServiceStartMessage(Environment env) {
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        String serviceName = env.getProperty("spring.application.name");
        String port = env.getProperty("server.port");
        String ip = "Unkown";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("\u83b7\u53d6\u7ed1\u5b9aIP\u4fe1\u606f\u5f02\u5e38,\u5c06\u4f7f\u7528\u7f3a\u7701IP\u914d\u7f6e[{}]", (Object)ip);
            e.printStackTrace();
        }
        String[] profiles = env.getActiveProfiles();
        String configServerStatus = env.getProperty("configserver.status");
        return AppStartMessageUtil.updServiceStartMessage(serviceName, protocol, port, ip, profiles, configServerStatus);
    }

    public static String updServiceStartMessage(String serviceName, String protocol, String port, String ip, String[] profiles, String configServerStatus) {
        String msg = "\n----------------------------------------------------------\n\tApplication '{0}' is running! Access URLs:\n\t  Local: \t\t{1}://localhost:{2}\n\tExternal: \t{1}://{3}:{2}\n\tProfile(s): \t{4}\n----------------------------------------------------------\n\tConfig Server: \t{5}\n----------------------------------------------------------";
        configServerStatus = configServerStatus == null ? "Not found or not setup for this application" : configServerStatus;
        msg = MessageFormat.format(msg, serviceName, protocol, port, ip, Arrays.toString(profiles), configServerStatus);
        return msg;
    }
}

