/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.exception.YuspException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESUtil {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String AES_CIPHER_ALGORITHM = "AES";
    private static final Logger logger = LoggerFactory.getLogger(AESUtil.class);

    public static final String encrypt(String content, String key) {
        return AESUtil.encrypt(content, StandardCharsets.UTF_8.name(), key);
    }

    public static final String encrypt(String content, String charset, String key) {
        try {
            return Base64.encodeBase64String((byte[])AESUtil.encrypt(content.getBytes(charset), key));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final byte[] encrypt(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, AESUtil.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final String encryptAes(String content, String key) {
        return AESUtil.encryptAes(content, StandardCharsets.UTF_8.name(), key);
    }

    public static final String encryptAes(String content, String charset, String key) {
        try {
            return Base64.encodeBase64String((byte[])AESUtil.encryptAes(content.getBytes(charset), key));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final byte[] encryptAes(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, AESUtil.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final String decrypt(String content, String key) {
        return AESUtil.decrypt(content, StandardCharsets.UTF_8.name(), key);
    }

    public static final byte[] decrypt(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AESUtil.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final String decrypt(String content, String charset, String key) {
        try {
            return new String(AESUtil.decrypt(Base64.decodeBase64((String)content), key), charset);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new YuspException(e.getMessage(), e);
        }
    }

    public static final String decryptAes(String content, String key) {
        return AESUtil.decryptAes(content, StandardCharsets.UTF_8.name(), key);
    }

    public static final String decryptAes(String content, String charset, String key) {
        try {
            return new String(AESUtil.decryptAes(Base64.decodeBase64((String)content), key), charset);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    public static final byte[] decryptAes(byte[] content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, AESUtil.getSecretKey(key));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }

    private static final SecretKeySpec getSecretKey(String key) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance("AES");
            kg.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), "AES");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new YuspException(ex.getMessage(), ex);
        }
    }
}

