/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper;

import cn.com.yusys.yusp.commons.util.StringUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryModel {
    protected static final Logger log = LoggerFactory.getLogger(QueryModel.class);
    private static final JavaType condMapType = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    @ApiModelProperty(value="condition", dataType="String")
    private Map<String, Object> condition = new HashMap<String, Object>();
    private int page;
    private int size = 10;
    private String sort;
    private String formatedOrderBy;
    @ApiModelProperty(hidden=true)
    private String dataAuth;

    public Map<String, Object> getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        ObjectMapper jsonObj = new ObjectMapper();
        try {
            this.condition = (Map)jsonObj.readValue(condition, condMapType);
        }
        catch (JsonParseException e) {
            log.error("\u5c06\u67e5\u8be2\u6761\u4ef6condition\u8f6c\u6362\u4e3amap\u683c\u5f0f\u51fa\u9519", (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.error("\u5c06\u67e5\u8be2\u6761\u4ef6condition\u8f6c\u6362\u4e3amap\u683c\u5f0f\u51fa\u9519", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u5c06\u67e5\u8be2\u6761\u4ef6condition\u8f6c\u6362\u4e3amap\u683c\u5f0f\u51fa\u9519", (Throwable)e);
        }
    }

    public void addCondition(String key, Object value) {
        this.condition.put(key, value);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getSort() {
        return this.formatedOrderBy;
    }

    public void setSort(String sort) {
        this.sort = sort;
        this.formateOrderBy(this.sort);
    }

    private void formateOrderBy(String orderBy) {
        String[] orders;
        if (orderBy == null || "".equals(orderBy.trim())) {
            return;
        }
        StringBuilder formatedOrderBy = new StringBuilder();
        for (String order : orders = orderBy.split(",")) {
            String type;
            String field;
            String[] items = order.trim().split("\\s+|\\t+");
            if (items.length > 2) {
                log.error("orderBy[" + orderBy + "]\u5b57\u6bb5\u4e0d\u5408\u6cd5,\u4e0d\u8fdb\u884c\u62fc\u63a5");
                return;
            }
            if (items.length >= 1 && ("and".equalsIgnoreCase((field = items[0]).trim()) || "or".equalsIgnoreCase(field.trim()))) {
                log.error("orderBy[" + orderBy + "]\u5b57\u6bb5\u4e0d\u5408\u6cd5,\u4e0d\u8fdb\u884c\u62fc\u63a5");
                return;
            }
            if (items.length >= 2 && !"asc".equalsIgnoreCase(type = items[1]) && !"desc".equals(type)) {
                log.error("orderBy[" + orderBy + "]\u5b57\u6bb5\u4e0d\u5408\u6cd5,\u4e0d\u8fdb\u884c\u62fc\u63a5");
                return;
            }
            formatedOrderBy.append(StringUtil.hump2Underline(items[0]));
            if (items.length > 1) {
                formatedOrderBy.append(" " + items[1]);
            }
            formatedOrderBy.append(",");
        }
        String newOrderBy = formatedOrderBy.toString();
        if (newOrderBy.endsWith(",")) {
            newOrderBy = newOrderBy.substring(0, newOrderBy.length() - 1);
        }
        this.formatedOrderBy = newOrderBy;
    }

    public String getDataAuth() {
        return this.dataAuth;
    }

    public void setDataAuth(String dataAuth) {
        this.dataAuth = dataAuth;
    }
}

