/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.license;

import cn.com.yusys.license.LicenseManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public final class ApplicationLicenseListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private final Logger logger = Logger.getLogger("licenseValidate-0429");
    private static AtomicInteger cur = new AtomicInteger(0);
    private final String bootstrap = "org.springframework.cloud.bootstrap.BootstrapApplicationListener";
    private Environment env;
    private String licenseModel = "PRO";
    private String licenseFile;
    private String licenseContext;
    private LicenseManager lManager = LicenseManager.getInstance();

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (this.isBootStrap((Environment)event.getEnvironment()) && cur.get() == 0) {
            cur.incrementAndGet();
        } else if (!this.validateLicense((Environment)event.getEnvironment())) {
            System.exit(0);
        }
    }

    boolean isBootStrap(Environment env) {
        return ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.BootstrapApplicationListener", null) && (Boolean)env.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true) != false;
    }

    private boolean validateLicense(Environment env) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(consoleHandler);
        this.env = env;
        boolean check = true;
        try {
            this.setLicenseConfig();
            this.logger.info("license\u6388\u6743\u6210\u529f:" + this.lManager.initialize());
        }
        catch (Throwable e) {
            this.logger.severe("license\u6821\u9a8c\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f:" + e.getMessage() + System.getProperty("line.separator"));
            check = false;
        }
        return check;
    }

    private void setLicenseConfig() {
        String licenseMacFile = "";
        this.licenseModel = this.env.getProperty("license.licenseModel") == null ? this.licenseModel : this.env.getProperty("license.licenseModel");
        this.licenseContext = this.env.getProperty("license.licenseContext");
        this.licenseFile = this.env.getProperty("license.licenseFile");
        licenseMacFile = this.env.getProperty("license.licenseMacFile");
        this.lManager.setLicenseModel(this.licenseModel);
        InputStream inputStream = null;
        if (this.licenseContext != null && !"".equals(this.licenseContext)) {
            inputStream = this.getLicContextInputStream(this.licenseContext);
        } else if (StringUtils.isNotEmpty((CharSequence)this.licenseFile)) {
            inputStream = this.getLicFileInputStream(this.licenseFile);
        } else {
            throw new RuntimeException("License\u6587\u4ef6:" + this.licenseFile + "\u8bfb\u53d6\u5f02\u5e38!!!");
        }
        this.lManager.setMacFile(licenseMacFile);
        this.lManager.setInputStream(inputStream);
    }

    private InputStream getLicContextInputStream(String licenseContext) {
        return new ByteArrayInputStream(licenseContext.getBytes());
    }

    private InputStream getLicFileInputStream(String licenseFile) {
        InputStream inputStream;
        File tf = new File(licenseFile);
        if (tf.exists()) {
            try {
                inputStream = new FileInputStream(tf);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("License\u6587\u4ef6:" + licenseFile + "\u8bfb\u53d6\u5f02\u5e38!!!");
            }
        }
        try {
            ClassPathResource resource = new ClassPathResource(licenseFile);
            inputStream = resource.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("License\u6587\u4ef6:" + licenseFile + "\u4e0d\u5b58\u5728!!!");
        }
        return inputStream;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

