/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    public static final char CHAR_ZERROR = '0';
    private static final String CHAR_SPACE = " ";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    private StringUtil() {
    }

    public static final boolean isEmpty(CharSequence cs) {
        return StringUtils.isEmpty((CharSequence)cs);
    }

    public static final boolean isNotEmpty(CharSequence cs) {
        return StringUtils.isNotEmpty((CharSequence)cs);
    }

    public static final boolean isBlank(CharSequence cs) {
        return StringUtils.isBlank((CharSequence)cs);
    }

    public static final boolean isNotBlank(CharSequence cs) {
        return StringUtils.isNotBlank((CharSequence)cs);
    }

    public static final boolean isStrEmpty(CharSequence cs) {
        return StringUtil.isEmpty(cs) || "null".equals(cs);
    }

    public static final boolean isStrNotEmpty(CharSequence cs) {
        return StringUtil.isNotEmpty(cs) && !"null".equals(cs);
    }

    public static final String substring(String str, int len) {
        return StringUtil.substring(str, 0, len);
    }

    public static final String substring(String str, int startIdx, int len) {
        if (len <= 0 || startIdx < 0 || StringUtil.isEmpty(str)) {
            return "";
        }
        if (len > str.length() || len - startIdx > str.length()) {
            return str;
        }
        return str.substring(startIdx, startIdx + len);
    }

    public static final String[] split(String str, String regex) {
        if (StringUtil.isEmpty(str)) {
            return new String[0];
        }
        return str.split(regex, -1);
    }

    public static final String replaceObjNull(Object object) {
        return Objects.nonNull(object) ? object.toString() : "";
    }

    public static final String replaceNullByObj(Object object) {
        return StringUtil.replaceObjNull(object);
    }

    public static final String concat(String[] strArray, String str) {
        return StringUtil.concat(strArray, str, false);
    }

    public static final String concat(String[] strArray, String str, boolean isReturnNull) {
        if (Objects.nonNull(strArray) && strArray.length > 0) {
            str = StringUtil.replaceObjNull(str);
            StringBuffer sb = new StringBuffer(strArray.length * 8);
            for (int i = 0; i < strArray.length; ++i) {
                if (StringUtil.isEmpty(strArray[i])) {
                    if (!isReturnNull) continue;
                    sb.append(StringUtil.replaceObjNull(strArray[i])).append(str);
                    continue;
                }
                sb.append(strArray[i]).append(str);
            }
            String returnStr = sb.toString();
            return StringUtil.substring(returnStr, returnStr.length() - 1);
        }
        return "";
    }

    public static final String concat(Collection<String> collections, String str) {
        return StringUtil.concat(collections, str, false);
    }

    public static final String concat(Collection<String> collections, String str, boolean isReturnNull) {
        if (Objects.isNull(collections)) {
            return "";
        }
        String[] strArray = collections.toArray(new String[collections.size()]);
        return StringUtil.concat(strArray, str, isReturnNull);
    }

    public static final String fill(char c, int length) {
        return StringUtil.fill(Character.toString(c), length);
    }

    public static final String fill(CharSequence cs, int length) {
        return StringUtil.fill(cs, length, true);
    }

    public static final String fill(CharSequence cs, int length, boolean isCutout) {
        if (length < 0) {
            return "";
        }
        int actLength = (int)Math.ceil((double)length / (double)cs.length());
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < actLength; ++i) {
            sb.append(cs);
        }
        return isCutout ? StringUtil.substring(sb.toString(), length) : sb.toString();
    }

    public static final String fill(String source, char c, int len) {
        return StringUtil.fill(source, c, len, 2);
    }

    public static final String fill(String source, char c, int len, int align) {
        return StringUtil.fill(source, Character.toString(c), len, align);
    }

    public static final String fill(String source, int len) {
        return StringUtil.fill(source, len, 2);
    }

    public static final String fill(String source, int len, int align) {
        return StringUtil.fill(source, CHAR_SPACE, len, align);
    }

    public static final String fill(String source, String str, int length, int align) {
        if (source == null || str == null) {
            return source;
        }
        if (source.length() > length) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        String fillStr = StringUtil.fill(str, length - source.getBytes().length);
        switch (align) {
            case 0: {
                buffer.append(fillStr).append(source);
                break;
            }
            case 1: {
                int centerIdx = source.length() / 2;
                buffer.append(StringUtil.substring(source, centerIdx)).append(fillStr).append(StringUtil.substring(source, centerIdx, source.length() - centerIdx));
                break;
            }
            case 2: {
                buffer.append(source).append(fillStr);
                break;
            }
            default: {
                buffer.append(source);
            }
        }
        return buffer.toString();
    }

    public static final boolean equals(String str1, String str2) {
        return StringUtil.equals(str1, str2, false);
    }

    public static final boolean equals(String str1, String str2, boolean ignoreCase) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null) {
            return ignoreCase ? str1.equalsIgnoreCase(str2) : str1.equals(str2);
        }
        return false;
    }

    public static final boolean contains(String[] strArray, String str) {
        return StringUtil.contains(strArray, str, false);
    }

    public static final boolean contains(String[] strArray, String str, boolean ignoreCase) {
        if (Objects.nonNull(strArray) && strArray.length > 0) {
            return Arrays.stream(strArray).anyMatch(s -> StringUtil.equals(s, str, ignoreCase));
        }
        return Objects.isNull(str);
    }

    public static final boolean contains(Collection<String> collections, String str) {
        return collections.contains(str);
    }

    public static final boolean contains(Collection<String> collections, String str, boolean ignoreCase) {
        if (Objects.isNull(collections)) {
            return false;
        }
        if (ignoreCase) {
            String[] strArray = collections.toArray(new String[collections.size()]);
            return StringUtil.contains(strArray, str, true);
        }
        return collections.contains(str);
    }

    public static final boolean isDoubleByte(char c) {
        return c >>> 8 != 0;
    }

    public static final boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u0391-\uffe5]+$");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String toFixLength(String str, int length) {
        if (str == null || length <= 0) {
            return "";
        }
        if (str.getBytes().length <= length) {
            return str;
        }
        StringBuffer buff = new StringBuffer();
        int index = 0;
        length -= 3;
        while (length > 0) {
            char c = str.charAt(index);
            length -= c < '\u0080' ? 1 : 2;
            buff.append(c);
            ++index;
        }
        buff.append("...");
        return buff.toString();
    }

    public static final boolean isLetter(String str) {
        if (str == null || str.length() < 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\w\\.-_]*");
        return pattern.matcher(str).matches();
    }

    public static final boolean isEmail(String email) {
        if (email == null || email.length() < 1 || email.length() > 256) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
        return pattern.matcher(email).matches();
    }

    public static final String trim(String str) {
        return StringUtil.isEmpty(str) ? str : str.trim();
    }

    public static final String upperCase(String str) {
        return StringUtils.upperCase((String)str);
    }

    public static final String lowerCase(String str) {
        return StringUtils.lowerCase((String)str);
    }

    public static final String byte2String(byte[] data) {
        return StringUtil.byte2String(data, false);
    }

    public static final String byte2String(byte[] data, boolean lowerCase) {
        if (data == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String tmpStr = Integer.toHexString(data[i] & 0xFF);
            tmpStr = StringUtils.leftPad((String)tmpStr, (int)2, (char)'0');
            buffer.append(tmpStr);
        }
        return lowerCase ? buffer.toString() : StringUtil.upperCase(buffer.toString());
    }

    public static final byte[] escString2Byte(String strData) throws NumberFormatException {
        byte[] srcData = strData.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int dataLength = srcData.length;
        for (int i = 0; i < dataLength; ++i) {
            if (srcData[i] == 48 && dataLength >= i + 4 && (srcData[i + 1] == 120 || srcData[i + 1] == 88)) {
                baos.write((byte)Integer.parseInt(new String(srcData, i + 2, 2), 16));
                i += 3;
                continue;
            }
            if (srcData[i] == 92) {
                if (i + 1 < dataLength) {
                    switch (srcData[i + 1]) {
                        case 114: {
                            baos.write(13);
                            break;
                        }
                        case 116: {
                            baos.write(9);
                            break;
                        }
                        case 110: {
                            baos.write(10);
                            break;
                        }
                        case 98: {
                            baos.write(8);
                            break;
                        }
                        case 102: {
                            baos.write(12);
                            break;
                        }
                        case 39: {
                            baos.write(39);
                            break;
                        }
                        case 34: {
                            baos.write(34);
                            break;
                        }
                        case 92: {
                            baos.write(92);
                            break;
                        }
                        case 48: {
                            baos.write(0);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff1a[" + strData + "]");
                        }
                    }
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff1a[" + strData + "]");
            }
            baos.write(srcData[i]);
        }
        return baos.toByteArray();
    }

    public static final String exception2String(Exception e) {
        if (e == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(os));
        byte[] msg = os.toByteArray();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(msg);
    }

    public static final String getBlankStr(char c, int length) {
        return StringUtil.getBlankStr(Character.toString(c), length);
    }

    public static final String getBlankStr(int length) {
        return StringUtil.getBlankStr(CHAR_SPACE, length);
    }

    public static final String getBlankStr(String str, int length) {
        return StringUtil.getBlankStr(str, length, false);
    }

    public static final String getBlankStr(String str, int length, boolean isCutout) {
        if (StringUtil.isEmpty(str)) {
            str = CHAR_SPACE;
        }
        return StringUtil.fill((CharSequence)str, length, isCutout);
    }

    public static final String toString(Object obj) {
        return Objects.isNull(obj) ? (String)obj : (obj.getClass().isArray() ? (obj instanceof byte[] ? new String((byte[])obj) : Arrays.toString((Object[])obj)) : obj.toString());
    }

    public static final String getUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    public static final String replaceNRT(String str) {
        return StringUtil.isNotEmpty(str) ? Pattern.compile("\n*|\t|\r").matcher(str.replaceAll("  ", "")).replaceAll("") : null;
    }

    public static final String hump2Underline(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                buffer.append("_");
            }
            buffer.append(Character.valueOf(str.charAt(i)));
        }
        String rtnStr = StringUtil.lowerCase(buffer.toString());
        return rtnStr.startsWith("_") ? rtnStr.substring(1) : rtnStr;
    }

    public static final String underline2Hump(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuffer tmpStr = new StringBuffer("");
        tmpStr.append(str.substring(0, 1));
        str = str.substring(1);
        while (str.indexOf("_") > 0) {
            tmpStr.append(str.substring(0, str.indexOf("_")));
            if (str.substring(str.indexOf("_")).equals("_")) {
                str = "";
                continue;
            }
            str = str.substring(str.indexOf("_") + 1, str.indexOf("_") + 2).toUpperCase() + str.substring(str.indexOf("_") + 2);
        }
        tmpStr.append(str);
        return tmpStr.toString();
    }

    public static final String rightFillZero(int sz) {
        return sz < 10 ? "0" + String.valueOf(sz) : String.valueOf(sz);
    }

    public static final String stringEncode(String str, String srcCharset, String targetCharset) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        try {
            return new String(str.getBytes(srcCharset), targetCharset);
        }
        catch (Exception exception) {
            return str;
        }
    }

    public static final Map<String, String> string2Map(String mapStr) {
        String[] entrys;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entrys = StringUtil.split(mapStr, ",")) {
            String[] strs = StringUtil.split(StringUtil.trim(entry), "=");
            if (strs.length <= 1) continue;
            map.put(strs[0].trim(), strs[1].trim());
        }
        return map;
    }

    public static final byte[] escapeStringToCharArray(byte[] str) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        block10: for (int i = 0; i < str.length; ++i) {
            switch (str[i]) {
                case 10: {
                    bout.write(92);
                    bout.write(110);
                    continue block10;
                }
                case 9: {
                    bout.write(92);
                    bout.write(116);
                    continue block10;
                }
                case 13: {
                    bout.write(92);
                    bout.write(114);
                    continue block10;
                }
                case 12: {
                    bout.write(92);
                    bout.write(102);
                    continue block10;
                }
                case 0: {
                    bout.write(92);
                    bout.write(48);
                    continue block10;
                }
                case 34: {
                    bout.write(92);
                    bout.write(34);
                    continue block10;
                }
                case 8: {
                    bout.write(92);
                    bout.write(98);
                    continue block10;
                }
                case 92: {
                    bout.write(92);
                    bout.write(92);
                    continue block10;
                }
                default: {
                    bout.write(str[i]);
                }
            }
        }
        return bout.toByteArray();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char toLowerAscii(char c) {
        if (StringUtil.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }
}

