/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.KeyStoreUtil;
import cn.com.yusys.yusp.commons.util.RSAUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SHA1WithRSASign {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String sign(byte[] content, String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyf.generatePrivate(priPKCS8);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initSign(priKey);
        signature.update(content);
        byte[] signed = signature.sign();
        return Base64.encodeBase64String((byte[])signed);
    }

    public static boolean doCheck(byte[] content, String sign, String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodedKey = Base64.decodeBase64((String)publicKey);
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initVerify(pubKey);
        signature.update(content);
        boolean bverify = signature.verify(Base64.decodeBase64((String)sign));
        return bverify;
    }

    public static String[] getGenKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = null;
        keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        String privateKeyString = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        return new String[]{publicKeyString, privateKeyString};
    }

    public static String encryptData(byte[] data, String keyStorePathString, String keyStorePwd, String keyPwd, String alias) throws Exception {
        PrivateKey privateKey = KeyStoreUtil.getPrivateKeyFromJks(keyStorePathString, keyStorePwd, keyPwd, alias);
        String encryptedData = SHA1WithRSASign.encryptByPrivateKey(data, privateKey);
        return encryptedData;
    }

    public static String signData(byte[] data, String keyStorePathString, String keyStorePwd, String keyPwd, String alias) throws Exception {
        PrivateKey privateKey = KeyStoreUtil.getPrivateKeyFromJks(keyStorePathString, keyStorePwd, keyPwd, alias);
        String signedData = SHA1WithRSASign.signByPrivateKey(data, privateKey);
        return signedData;
    }

    public static byte[] decryptData(String signedData, String encryptedData, String cerPath) throws Exception {
        PublicKey publicKey = KeyStoreUtil.getPublicKeyFromCert(cerPath);
        return SHA1WithRSASign.verifyData(signedData, encryptedData, publicKey);
    }

    public static String encryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        byte[] encodedData = RSAUtils.encryptByPrivateKey(data, privateKey);
        return Base64.encodeBase64String((byte[])encodedData);
    }

    public static byte[] decryptByPublicKey(String data, PublicKey publicKey) throws Exception {
        byte[] decodedData = Base64.decodeBase64((String)data);
        byte[] encodedData = RSAUtils.decryptByPublicKey(decodedData, publicKey);
        return encodedData;
    }

    public static String signByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        byte[] signedData = RSAUtils.signByPrivateKey(data, privateKey);
        return Base64.encodeBase64String((byte[])signedData);
    }

    public static boolean verifyByPublicKey(byte[] data, String signData, PublicKey publicKey) throws Exception, UnsupportedEncodingException {
        byte[] decodedData = Base64.decodeBase64((String)signData);
        boolean flag = RSAUtils.verifyByPublicKey(data, decodedData, publicKey);
        return flag;
    }

    public static byte[] verifyData(String signedData, String encryptedData, PublicKey publicKey) throws Exception, UnsupportedEncodingException {
        boolean flag;
        byte[] decryptedData = SHA1WithRSASign.decryptByPublicKey(encryptedData, publicKey);
        if (signedData != null && !(flag = SHA1WithRSASign.verifyByPublicKey(decryptedData, signedData, publicKey))) {
            throw new Exception("\u6570\u636e\u9a8c\u7b7e\u5931\u8d25");
        }
        return decryptedData;
    }

    public static final String bytesToHexStr(byte[] bcd) {
        StringBuffer s = new StringBuffer(bcd.length * 2);
        for (int i = 0; i < bcd.length; ++i) {
            s.append(bcdLookup[bcd[i] >>> 4 & 0xF]);
            s.append(bcdLookup[bcd[i] & 0xF]);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        try {
            String[] keyPair = SHA1WithRSASign.getGenKeyPair();
            String publicKey = keyPair[0];
            String privateKey = keyPair[1];
            byte[] content = "test123".getBytes("utf-8");
            System.out.println("publicKey : " + publicKey);
            System.out.println("privateKey : " + privateKey);
            String signStr = SHA1WithRSASign.sign(content, privateKey);
            System.out.println("signStr === " + signStr);
            boolean success = SHA1WithRSASign.doCheck(content, signStr, publicKey);
            if (success) {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u901a\u8fc7");
            } else {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

