/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.CommonUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public final class NumberUtil {
    public static String[] rmbNumbers = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u4e24", "\u5eff", "\u5345", "\u25cb"};
    public static String[] bigNumbers = new String[]{"\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u4fe9", "\u5eff", "\u5345", "\u96f6"};
    public static Long[] tonumbers = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 2L, 2L, 3L, 0L};
    public static String[] rmbMult = new String[]{"\u4ebf", "\u4e07", "\u5343", "\u767e", "\u5341"};
    public static String[] bigRmbMult = new String[]{"\u5104", "\u842c", "\u4edf", "\u4f70", "\u62fe"};
    public static Long[] toMult = new Long[]{100000000L, 10000L, 1000L, 100L, 10L};
    public static final String[] RMBDW = new String[]{"\u5143", "\u5706"};
    public static final String[] DECIMALDW = new String[]{"\u89d2", "\u5206"};
    private static final int DEF_DIV_SCALE = 10;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] chineseAmt = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static char[] units = new char[]{'\u62fe', '\u4f70', '\u4edf'};
    private static char[] chineseUnits = new char[]{'\u5143', '\u4e07', '\u4ebf', '\u5146'};
    private static char[] smallUnits = new char[]{'\u5206', '\u89d2'};
    private static final BigInteger radix = new BigInteger("10");
    private static final char ZEROCHAR = '\u96f6';

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = 0xFF & bytes[0];
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        return NumberUtil.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        String ret = "";
        for (int i = 0; i < bytes.length; ++i) {
            ret = ret + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return upperCase ? ret.toUpperCase() : ret;
    }

    public static byte[] hexToByte(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = (byte)byteint;
            ++i;
            ++j;
        }
        return b;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        return NumberUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return NumberUtil.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return NumberUtil.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return NumberUtil.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(NumberUtil.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = NumberUtil.toDigit(data[j], j) << 4;
            f |= NumberUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String stringToAsciiString(String content) {
        String result = "";
        int max = content.length();
        for (int i = 0; i < max; ++i) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result = result + b;
        }
        return result;
    }

    public static String hexStringToString(String hexString, int encodeType) {
        String result = "";
        int max = hexString.length() / encodeType;
        for (int i = 0; i < max; ++i) {
            char c = (char)NumberUtil.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result = result + c;
        }
        return result;
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result = (int)((double)result + Math.pow(16.0, max - i) * (double)algorism);
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        String result = "";
        int max = hex.length();
        block18: for (int i = 0; i < max; ++i) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result = result + "0000";
                    continue block18;
                }
                case '1': {
                    result = result + "0001";
                    continue block18;
                }
                case '2': {
                    result = result + "0010";
                    continue block18;
                }
                case '3': {
                    result = result + "0011";
                    continue block18;
                }
                case '4': {
                    result = result + "0100";
                    continue block18;
                }
                case '5': {
                    result = result + "0101";
                    continue block18;
                }
                case '6': {
                    result = result + "0110";
                    continue block18;
                }
                case '7': {
                    result = result + "0111";
                    continue block18;
                }
                case '8': {
                    result = result + "1000";
                    continue block18;
                }
                case '9': {
                    result = result + "1001";
                    continue block18;
                }
                case 'A': {
                    result = result + "1010";
                    continue block18;
                }
                case 'B': {
                    result = result + "1011";
                    continue block18;
                }
                case 'C': {
                    result = result + "1100";
                    continue block18;
                }
                case 'D': {
                    result = result + "1101";
                    continue block18;
                }
                case 'E': {
                    result = result + "1110";
                    continue block18;
                }
                case 'F': {
                    result = result + "1111";
                }
            }
        }
        return result;
    }

    public static String asciiStringToString(String content) {
        String result = "";
        int length = content.length() / 2;
        for (int i = 0; i < length; ++i) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = NumberUtil.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = result + d;
        }
        return result;
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return NumberUtil.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        String result = "";
        int length = bytearray.length;
        for (int i = 0; i < length; ++i) {
            char temp = (char)bytearray[i];
            result = result + temp;
        }
        return result;
    }

    public static int binaryToAlgorism(String binary) {
        int max = binary.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result = (int)((double)result + Math.pow(2.0, max - i) * (double)algorism);
        }
        return result;
    }

    public static String algorismToHEXString(int algorism) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        String temp = "";
        for (int i = 0; i < maxLength - str.length(); ++i) {
            temp = "0" + temp;
        }
        str = (temp + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u786e\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570\u6216\u96f6");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static String rmbBig2Small(String money) {
        int index = money.indexOf(RMBDW[0]) > 0 ? money.indexOf(RMBDW[0]) : money.indexOf(RMBDW[1]);
        boolean isDecim = false;
        if (index == -1) {
            int n = index = money.indexOf(DECIMALDW[0]) > 0 ? money.indexOf(DECIMALDW[0]) : money.indexOf(DECIMALDW[1]);
            if (index == -1) {
                index = money.length();
            } else {
                --index;
                isDecim = true;
            }
        }
        String intPart = money.substring(0, index);
        String decimalPart = "";
        if (index + 1 < money.length()) {
            if (isDecim) {
                --index;
            }
            decimalPart = money.substring(index + 1);
        }
        String dp = NumberUtil.decimalBigToSmall(decimalPart);
        String ret = NumberUtil.intBigToSmall(intPart);
        ret = ret + "." + dp;
        return ret;
    }

    private static String decimalBigToSmall(String money) {
        if (money.length() == 0) {
            return "00";
        }
        StringBuilder sb = new StringBuilder();
        int index = money.indexOf(DECIMALDW[0]);
        String tmp = null;
        if (index > 0) {
            tmp = money.substring(0, index);
            sb.append(NumberUtil.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        index = money.indexOf(DECIMALDW[1]);
        if (index > 0) {
            tmp = money.substring(index - 1, index);
            sb.append(NumberUtil.getNumByBig(tmp));
        } else {
            sb.append(0);
        }
        return sb.toString();
    }

    private static String intBigToSmall(String money) {
        Long number = 0L;
        for (int i = 0; i < rmbMult.length; ++i) {
            int index;
            int n = index = money.lastIndexOf(rmbMult[i]) == -1 ? money.lastIndexOf(bigRmbMult[i]) : money.lastIndexOf(rmbMult[i]);
            if (index < 0) continue;
            String storeMult = money.substring(0, index);
            money = money.substring(index + 1);
            number = (storeMult == null || storeMult.length() <= 0) && toMult[i].intValue() == 10 ? Long.valueOf(number + toMult[i]) : Long.valueOf(number + toMult[i] * NumberUtil.getPrexNum(storeMult));
        }
        number = number + NumberUtil.getNumByBig(money);
        return number.toString();
    }

    private static Long getPrexNum(String storeMult) {
        Long result = 0L;
        for (int i = 0; i < rmbMult.length; ++i) {
            int index;
            int n = index = storeMult.lastIndexOf(rmbMult[i]) == -1 ? storeMult.lastIndexOf(bigRmbMult[i]) : storeMult.lastIndexOf(rmbMult[i]);
            if (index < 0) continue;
            String storeMult2 = storeMult.substring(0, index);
            storeMult = storeMult.substring(index + 1);
            if ((storeMult2 == null || storeMult2.length() <= 0) && toMult[i].intValue() == 10) {
                result = result + toMult[i];
                continue;
            }
            if (storeMult2 == null) continue;
            result = result + NumberUtil.getNumByBig(storeMult2) * toMult[i];
        }
        if (storeMult != null && storeMult.length() > 0) {
            result = result + NumberUtil.getNumByBig(storeMult);
        }
        return result;
    }

    private static Long getNumByBig(String big) {
        Long result = 0L;
        for (int j = 0; j < rmbNumbers.length; ++j) {
            big = big.replaceAll(rmbNumbers[j], tonumbers[j].toString());
            big = big.replaceAll(bigNumbers[j], tonumbers[j].toString());
        }
        try {
            result = Long.valueOf(big);
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    private static String formatInt(BigInteger num) {
        if (num.equals(BigInteger.ZERO)) {
            return "\u96f6\u5143";
        }
        if (num.toString().length() > 16) {
            throw new RuntimeException("too max num:" + num);
        }
        StringBuffer result = new StringBuffer("");
        int i = 0;
        char preChar = '\u0000';
        while (num.compareTo(BigInteger.ZERO) > 0) {
            StringBuffer tmp = new StringBuffer();
            BigInteger rest = num.mod(radix);
            num = num.divide(radix);
            if (rest.equals(BigInteger.ZERO) && i % 4 != 0 && preChar != '\u96f6' && CommonUtil.exists(chineseAmt, Character.valueOf(preChar))) {
                tmp.append('\u96f6');
            } else if (!rest.equals(BigInteger.ZERO)) {
                tmp.append(chineseAmt[rest.intValue()]);
                if (i % 4 != 0) {
                    tmp.append(units[i % 4 - 1]);
                }
            }
            if (i % 4 == 0) {
                if (i / 4 > 0 && CommonUtil.exists(chineseUnits, Character.valueOf(result.charAt(0)))) {
                    result.delete(0, 1);
                }
                tmp.append(chineseUnits[i / 4]);
            }
            preChar = tmp.length() > 0 ? tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    private static String formatSmall(int small) {
        if (small > 100) {
            throw new RuntimeException("too small");
        }
        StringBuffer result = new StringBuffer("");
        char preChar = '\u0000';
        int i = 0;
        while (small > 0) {
            StringBuffer tmp = new StringBuffer();
            int rest = small % 10;
            small /= 10;
            if (rest == 0 && preChar != '\u96f6' && CommonUtil.exists(chineseAmt, Character.valueOf(preChar))) {
                tmp.append('\u96f6');
            } else if (rest != 0) {
                tmp.append(chineseAmt[rest]);
                tmp.append(smallUnits[i]);
            }
            preChar = tmp.length() > 0 ? (char)tmp.charAt(0) : (char)'\u0000';
            ++i;
            result.insert(0, tmp);
        }
        return result.toString();
    }

    public static String rmbSmall2Big(double num) {
        DecimalFormat df = new DecimalFormat("#.00");
        String input = df.format(num);
        StringBuffer sb = new StringBuffer();
        int index = input.indexOf(46);
        if (index != -1) {
            if (index != 0) {
                sb.append(NumberUtil.formatInt(new BigInteger(input.substring(0, index))));
                if (sb.indexOf(RMBDW[0]) == -1) {
                    sb.append(RMBDW[0]);
                }
            }
            sb.append(NumberUtil.formatSmall(Integer.parseInt(input.substring(index + 1))));
        }
        return sb.toString();
    }

    public static final boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final Integer toInteger(String str) {
        return NumberUtil.toInteger(str, null);
    }

    public static final Integer toInteger(String str, Integer defVal) {
        return NumberUtil.isInteger(str) ? Integer.valueOf(str) : defVal;
    }

    public static final Integer toInteger(Object object) {
        return NumberUtil.toInteger(object, null);
    }

    public static final Integer toInteger(Object object, Integer defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtil.toInteger(str, defVal);
    }

    public static final boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final Double toDouble(String str) {
        return NumberUtil.toDouble(str, null);
    }

    public static final Double toDouble(String str, Double defVal) {
        return NumberUtil.isDouble(str) ? Double.valueOf(str) : defVal;
    }

    public static final Double toDouble(Object object) {
        return NumberUtil.toDouble(object, null);
    }

    public static final Double toDouble(Object object, Double defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtil.toDouble(str, defVal);
    }

    public static final String formatAmt(String str) {
        return NumberUtil.formatAmt(str, "###,###.00");
    }

    public static final String formatAmt(String str, String pattern) {
        if (StringUtil.isNotEmpty(str)) {
            try {
                return new DecimalFormat(pattern).format(Double.valueOf(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String formatAmt(Number number) {
        return NumberUtil.formatAmt(number.toString());
    }

    public static final String formatAmt(Number number, String pattern) {
        return NumberUtil.formatAmt(number.toString(), pattern);
    }

    public static final boolean isOddNumber(int a) {
        return (a & 1) == 1;
    }

    public static final boolean isEvenNumber(int a) {
        return (a & 1) == 0;
    }

    public static final int getAverageValue(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static final boolean is2NSquare(int x) {
        return (x & x - 1) == 0 && x != 0;
    }

    public static final boolean isBigDecimal(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final BigDecimal toBigDecimal(String str) {
        return NumberUtil.isBigDecimal(str) ? new BigDecimal(str) : null;
    }

    public static final BigDecimal toBigDecimal(String str, BigDecimal defVal) {
        return NumberUtil.isBigDecimal(str) ? new BigDecimal(str) : defVal;
    }

    public static final BigDecimal toBigDecimal(String str, String defVal) {
        return NumberUtil.toBigDecimal(str, new BigDecimal(defVal));
    }

    public static final BigDecimal toBigDecimal(String str, Number defVal) {
        return NumberUtil.toBigDecimal(str, defVal.toString());
    }

    public static final boolean isNumeric(String str) {
        return Pattern.compile("[0-9]*").matcher(str).matches();
    }

    public static final boolean isFloat(String str) {
        try {
            Float.parseFloat(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final Float toFloat(String str) {
        return NumberUtil.toFloat(str, null);
    }

    public static final Float toFloat(String str, Float defVal) {
        return NumberUtil.isFloat(str) ? Float.valueOf(str) : defVal;
    }

    public static final Float toFloat(Object object) {
        return NumberUtil.toFloat(object, null);
    }

    public static final Float toFloat(Object object, Float defVal) {
        String str = StringUtil.replaceObjNull(object);
        return NumberUtil.toFloat(str, defVal);
    }

    public static final BigDecimal divide(Number n1, Number n2, int scale) {
        return BigDecimal.valueOf(n1.doubleValue()).divide(BigDecimal.valueOf(n2.doubleValue())).setScale(scale, 4);
    }
}

