/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.filter;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssAndSQLFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(XssAndSQLFilter.class);
    protected String encoding = null;
    protected FilterConfig filterConfig = null;
    private static Pattern invalidInputPattern = null;
    private static Pattern XSSURL = null;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.requestEncodingFilter(request);
        boolean directFlag = false;
        directFlag = this.safeProtectFilter(request, response);
        if (directFlag) {
            try {
                logger.debug("Request contains illegal characters!");
                request.setAttribute("forwardFlag", (Object)"true");
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.sendError(500, "illegal request parameter from yusp filter");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        chain.doFilter(request, response);
    }

    public void requestEncodingFilter(ServletRequest request) throws IOException, ServletException {
        String encoding;
        if (request.getCharacterEncoding() == null && (encoding = this.selectEncoding(request)) != null) {
            String charset = request.getCharacterEncoding();
            if (charset != null) {
                if (charset.toUpperCase().indexOf("UTF-8") != -1) {
                    request.setCharacterEncoding("UTF-8");
                } else {
                    request.setCharacterEncoding(encoding);
                }
            } else {
                request.setCharacterEncoding(encoding);
            }
        }
    }

    public boolean safeProtectFilter(ServletRequest request, ServletResponse response) throws IOException {
        String pName = null;
        String pValue = null;
        Perl5Matcher matcher = new Perl5Matcher();
        String flag = (String)request.getAttribute("forwardFlag");
        if ("true".equals(flag)) {
            return false;
        }
        if (XSSURL != null) {
            HttpServletRequest httprequest = (HttpServletRequest)request;
            String uri = httprequest.getRequestURI();
            if (matcher.contains(uri = URLDecoder.decode(uri, "utf-8").toUpperCase(), XSSURL)) {
                return true;
            }
        }
        if (invalidInputPattern != null) {
            Enumeration allParam = request.getParameterNames();
            while (allParam.hasMoreElements()) {
                pName = (String)allParam.nextElement();
                pValue = request.getParameter(pName);
                if (pValue == null || !matcher.contains(pValue = pValue.toUpperCase(), invalidInputPattern)) continue;
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }

    static {
        Perl5Compiler myCompiler = new Perl5Compiler();
        try {
            invalidInputPattern = myCompiler.compile("<[\\s\\x00]*SCRIPT|SELECT\\s|INSERT\\s|DELETE\\s|UPDATE\\s|DROP\\s|<!--|-->|<FRAME|<IFRAME|<FRAMESET|<NOFRAME|<PLAINTEXT|<A\\s|<LINK|<MAP|<BGSOUND|<IMG|<FORM|<INPUT|<SELECT|<OPTION|<TEXTAREA|<APPLET|<OBJECT|<EMBED|<NOSCRIPT|<STYLE|ALERT[\\s\\x00]*\\(");
            XSSURL = myCompiler.compile("<[\\s\\x00]*SCRIPT|<TEXTAREA|<APPLET|<OBJECT|<EMBED|<NOSCRIPT|<STYLE|ALERT[\\s\\x00]*\\(");
        }
        catch (Exception err) {
            invalidInputPattern = null;
            XSSURL = null;
            err.printStackTrace();
            System.out.println("\n\n\nWarning:InvalidInputPattern compile error\n\n\n");
        }
    }
}

