/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.filter;

import cn.com.yusys.yusp.commons.dto.DataContr;
import cn.com.yusys.yusp.commons.dto.User;
import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import cn.com.yusys.yusp.commons.security.SecurityUtils;
import cn.com.yusys.yusp.commons.service.UserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class DataAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DataAuthFilter.class);
    public static final String UTF8 = "UTF-8";
    private AntPathMatcher matcher = new AntPathMatcher();
    private UrlPathHelper pathHelper = new UrlPathHelper();
    @Autowired
    private UserService userCacheService;
    @Value(value="${application.web.ignore-urls}")
    private String ignoreUrlStrs = null;
    private List<String> ignoreUrls;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("Create access permission interceptor!");
        if (null == this.ignoreUrlStrs) {
            return;
        }
        this.ignoreUrls = Arrays.asList(this.ignoreUrlStrs.split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestUri = this.pathHelper.getLookupPathForRequest(request);
        if (log.isDebugEnabled()) {
            log.debug("DataAuthFilter enter utl:{}", (Object)requestUri);
        }
        boolean result = false;
        if (null != this.ignoreUrls) {
            result = this.ignoreUrls.stream().anyMatch(ctrl -> this.matcher.match(ctrl, requestUri));
        }
        if (!result) {
            String accessToken = SecurityUtils.getCurrentUserToken();
            if (null == accessToken) {
                log.warn("Token [{}] is empty, recordset permission is not valid", (Object)accessToken);
            } else {
                String loginCode = this.userCacheService.getUserCode(accessToken);
                if (log.isDebugEnabled()) {
                    log.debug("loginCode:{};token:{}", (Object)loginCode, (Object)accessToken);
                }
                if (null == loginCode) {
                    log.error("User [{}] or token [{}] is empty, unable to get basic user information, and recordset permission is not valid", (Object)loginCode, (Object)accessToken);
                } else {
                    User userInfo = this.userCacheService.getUserInfo(loginCode, null, accessToken);
                    if (userInfo == null) {
                        log.error("Failed to query session information of user [{}], token [{}], invalid recordset permission", (Object)loginCode, (Object)accessToken);
                    } else {
                        this.addDataAuthInfo(loginCode, null, accessToken, userInfo, requestUri);
                    }
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
        this.cleanDataAuthInfo();
    }

    public void destroy() {
    }

    private void cleanDataAuthInfo() {
        DataAuthHandler.dataAuthTemplate.remove();
        DataAuthHandler.dataAuthParams.remove();
    }

    private void addDataAuthInfo(String loginCode, String sysId, String accessToken, User userInfo, String requestUri) {
        List dataCtrlList = this.userCacheService.getDataAuth(loginCode, sysId, accessToken);
        if (dataCtrlList != null && !dataCtrlList.isEmpty()) {
            List matchDataCtrlList = dataCtrlList.stream().filter(data -> this.matcher.match(data.getContrUrl(), requestUri)).collect(Collectors.toList());
            DataContr matchDataCtrl = null;
            if (matchDataCtrlList == null || matchDataCtrlList.size() == 0) {
                List defaultDataCtrl;
                if (log.isDebugEnabled()) {
                    log.debug("The control point {} accessed by user [{}] uses the default template", (Object)loginCode, (Object)requestUri);
                }
                if ((defaultDataCtrl = dataCtrlList.stream().filter(data -> "*".equals(data.getContrId())).collect(Collectors.toList())) != null && defaultDataCtrl.size() > 0) {
                    matchDataCtrl = (DataContr)defaultDataCtrl.get(0);
                }
            } else if (matchDataCtrlList.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("The control point {} accessed by user [{}] uses specific templates, there are [{}] specific templates", new Object[]{loginCode, requestUri, matchDataCtrlList.size()});
                }
                matchDataCtrl = matchDataCtrlList.stream().min(Comparator.comparing(DataContr::getPriority)).orElseGet(() -> {
                    log.warn("Dataset is empty");
                    return null;
                });
            }
            if (matchDataCtrl != null) {
                String dataAuthTemplate = matchDataCtrl.getSqlString();
                log.info("Data permission template: {}, data permission parameter: {}", (Object)dataAuthTemplate, (Object)userInfo);
                DataAuthHandler.dataAuthTemplate.set(dataAuthTemplate);
                DataAuthHandler.dataAuthParams.set(this.getAuthParams(userInfo));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("There is no data permission template for the role of user [{}]", (Object)loginCode);
        }
    }

    private Map<String, Object> getAuthParams(User userInfo) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            dataMap.put("_userCode", userInfo.getLoginCode());
            dataMap.put("_orgCode", userInfo.getOrg().getCode());
            log.debug("The data template parameter that user[{}] used is {}", (Object)userInfo.getLoginCode(), dataMap);
        }
        catch (Exception e) {
            log.error("Exception in getting data permission template", (Throwable)e);
            e.printStackTrace();
        }
        return dataMap;
    }
}

