/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.FiltersAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.XssAndSQLFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"application.filter.xss.enabled"}, havingValue="true")
@AutoConfigureAfter(value={FiltersAutoConfiguration.class})
public class XSSAndSqlAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XSSAndSqlAutoConfiguration.class);

    @Bean
    public FilterRegistrationBean xssAndSqlFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssAndSQLFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        registration.setDispatcherTypes(dispatcherTypes);
        log.info("Auto configuration >> anti XSS attack SQL injection  filter configuration completed");
        return registration;
    }
}

