/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.FiltersAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.FileUploadChkFilter;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"application.filter.fileupload.enabled"}, havingValue="true")
@AutoConfigureAfter(value={FiltersAutoConfiguration.class})
public class FileChkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FileChkAutoConfiguration.class);
    @Value(value="${application.filter.fileupload.access-file-type:null}")
    private String accessFileType = null;

    @Bean
    public FileUploadChkFilter fileUploadFilter() {
        log.info("Auto configuration >> prevent malicious file upload filter configuration completed");
        String[] accessFileTypeArray = StringUtil.split((String)this.accessFileType, (String)",");
        ArrayList<String> accessFileTypeList = new ArrayList<String>();
        Collections.addAll(accessFileTypeList, accessFileTypeArray);
        return new FileUploadChkFilter(accessFileTypeList);
    }
}

