/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.aop.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.commons.aop.dataauth.handler.DefaultDataAuthParamHander;
import cn.com.yusys.yusp.commons.config.CacheAutoConfiguration;
import cn.com.yusys.yusp.commons.config.FiltersAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.DataAuthFilter;
import cn.com.yusys.yusp.commons.service.UserService;
import javax.servlet.Filter;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"application.filter.dataauth.enabled"}, matchIfMissing=false)
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnBean(value={UserService.class})
@AutoConfigureAfter(value={FiltersAutoConfiguration.class, CacheAutoConfiguration.class})
public class DataAuthAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Integer FILTER_ORDER_DATAAUTH = 97;

    @Bean
    public DataAuthFilter dataAuthFilter() {
        this.log.info("Auto configuration >> recordset permission filter configuration completed");
        return new DataAuthFilter();
    }

    @Bean
    public FilterRegistrationBean dataAuthFilterBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.dataAuthFilter(), new ServletRegistrationBean[0]);
        bean.setOrder(FILTER_ORDER_DATAAUTH.intValue());
        return bean;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataAuthParamHander dataAuthParamHander() {
        return new DefaultDataAuthParamHander();
    }
}

