/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.property.crypt.DecryptPropertyService;
import cn.com.yusys.yusp.commons.property.crypt.DesDecryptPropertyService;
import cn.com.yusys.yusp.commons.property.crypt.EncryptionPropertyResolver;
import cn.com.yusys.yusp.commons.property.crypt.RsaDecryptPropertyService;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"application.decrypt.enabled"}, havingValue="true")
public class CryptPropertyAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CryptPropertyAutoConfiguration.class);

    @Bean(name={"encryptablePropertyResolver"})
    public EncryptablePropertyResolver encryptablePropertyResolver() {
        logger.info("Auto configuration >>  CryptPropertyAutoConfiguration completed");
        return new EncryptionPropertyResolver();
    }

    @Bean
    @ConditionalOnProperty(name={"application.decrypt.type"}, havingValue="RSA")
    public DecryptPropertyService rsaDecryptPropertyService() {
        logger.info("Auto configuration >> RAS based properties enncryption and decryption bean loading");
        return new RsaDecryptPropertyService();
    }

    @Bean
    @ConditionalOnProperty(name={"application.decrypt.type"}, havingValue="DES")
    public DecryptPropertyService desDecryptPropertyService() {
        logger.info("Auto configuration >> DES based properties enncryption and decryption bean loading");
        return new DesDecryptPropertyService();
    }
}

