/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.apm.SpringEnvironmentConfigurationSource;
import cn.com.yusys.yusp.commons.config.ApmAutoConfiguration;
import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import co.elastic.apm.configuration.PrefixingConfigurationSourceWrapper;
import co.elastic.apm.impl.ElasticApmTracer;
import co.elastic.apm.servlet.ApmFilter;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.shaded.stagemonitor.configuration.source.ConfigurationSource;
import co.elastic.apm.shaded.stagemonitor.configuration.source.EnvironmentVariableConfigurationSource;
import co.elastic.apm.shaded.stagemonitor.configuration.source.SystemPropertyConfigurationSource;
import co.elastic.apm.spring.webmvc.ApmHandlerInterceptor;
import java.util.ServiceLoader;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@AutoConfigureAfter(value={ApmAutoConfiguration.class})
public class ApmConfigMvcConfig
implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(ApmConfigMvcConfig.class);
    @Value(value="${spring.application.name}")
    String applicationName;
    ApplicationProperties applicationProperties;

    public ApmConfigMvcConfig(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringEnvironmentConfigurationSource springEnvironmentConfigurationSource() {
        return new SpringEnvironmentConfigurationSource();
    }

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean apmFilterRegistration() {
        logger.info("Auto configuration >>Init APM filter for:{}", (Object)this.applicationName);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        ConfigurationRegistry registry = ConfigurationRegistry.builder().addConfigSource((ConfigurationSource)new PrefixingConfigurationSourceWrapper((ConfigurationSource)new SystemPropertyConfigurationSource(), "elastic.apm.")).addConfigSource((ConfigurationSource)new PrefixingConfigurationSourceWrapper((ConfigurationSource)new EnvironmentVariableConfigurationSource(), "ELASTIC_APM_")).addConfigSource((ConfigurationSource)this.springEnvironmentConfigurationSource()).optionProviders(ServiceLoader.load(ConfigurationOptionProvider.class, ElasticApmTracer.class.getClassLoader())).failOnMissingRequiredValues(true).build();
        ApmFilter apmFilter = new ApmFilter(ElasticApmTracer.builder().configurationRegistry(registry).build());
        registration.setFilter((Filter)apmFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("apmFilter");
        registration.setOrder(1);
        return registration;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ApmHandlerInterceptor());
    }
}

