/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.CacheAutoConfiguration;
import cn.com.yusys.yusp.commons.config.FiltersAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.AccessFilter;
import cn.com.yusys.yusp.commons.service.UserService;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"application.filter.access.enabled"}, havingValue="true")
@ConditionalOnBean(value={UserService.class})
@AutoConfigureAfter(value={FiltersAutoConfiguration.class, CacheAutoConfiguration.class})
public class AccessConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Integer FILTER_ORDER_ACCESS = 98;

    @Bean
    public AccessFilter accessFilter() {
        this.log.info("Auto configuration >> control point permission verification configuration completed");
        return new AccessFilter();
    }

    @Bean
    public FilterRegistrationBean accessFilterBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.accessFilter(), new ServletRegistrationBean[0]);
        bean.setOrder(FILTER_ORDER_ACCESS.intValue());
        return bean;
    }
}

