/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.rest.errors;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.commons.util.StringUtil;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@ConditionalOnProperty(name={"application.extrans.enabled"}, matchIfMissing=true)
public class ExceptionTranslator {
    private final Logger logger = LoggerFactory.getLogger(ExceptionTranslator.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResultDto handlerMyException(MethodArgumentNotValidException ex) {
        this.logger.error("MethodArgumentNotValidException \uff0cMessage:{}", (Object)ex.getMessage());
        List errors = ex.getBindingResult().getFieldErrors();
        StringBuilder message = new StringBuilder();
        for (FieldError error : errors) {
            message.append(error.getField() + ":" + error.getDefaultMessage() + "  ");
        }
        ResultDto dto = new ResultDto(503, message.toString(), "error");
        return dto;
    }

    @ExceptionHandler(value={ConcurrencyFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ResultDto processConcurrencyError(ConcurrencyFailureException ex) {
        ResultDto dto = new ResultDto(505, ex.getMessage(), "error");
        return dto;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public ResultDto processMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        return new ResultDto(504, ex.getMessage(), "error");
    }

    @ExceptionHandler(value={YuspException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResultDto processBusiException(YuspException ex) {
        ResultDto dto = StringUtil.isNumeric((CharSequence)ex.getCode()) ? new ResultDto(Integer.parseInt(ex.getCode()), ex.getMsg(), ex.getLevel()) : new ResultDto(500, "[" + ex.getCode() + "]" + ex.getMsg(), ex.getLevel());
        return dto;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResultDto processPkError(DuplicateKeyException ex) {
        this.logger.error("DuplicateKeyException Advice\uff0cMessage:{}", (Object)ex.getMessage());
        ResultDto dto = new ResultDto(506, "\u6570\u636e\u9879\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", "error");
        return dto;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultDto processRuntimeException(Exception ex) {
        this.logger.error("Exception Advice\uff0cCode:{}\uff0cMessage:{}", (Object)HttpStatus.INTERNAL_SERVER_ERROR, (Object)ex.getMessage());
        ex.printStackTrace();
        ResultDto errorDto = new ResultDto(500, ex.getMessage(), "error");
        return errorDto;
    }
}

