/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.service.UserService;
import cn.com.yusys.yusp.commons.service.impl.UserServiceCacheImpl;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@EnableCaching
@ConditionalOnClass(value={RedisConnectionFactory.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cache.type"}, havingValue="redis")
public class CacheAutoConfiguration {
    @Value(value="${application.cache.ttl:720}")
    private int ttl;
    private static final Logger logger = LoggerFactory.getLogger(CacheAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"application.cache.user.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={UserService.class})
    public UserService userCacheService() {
        logger.info("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\uff0c\u52a0\u8f7dUserCacheServiceCacheImpl\uff0c\u57fa\u4e8e\u7f13\u5b58");
        return new UserServiceCacheImpl();
    }

    @Bean
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public CacheManager cacheManager(RedisConnectionFactory factory) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)).entryTtl(Duration.ofMinutes(this.ttl));
        logger.info("\u81ea\u52a8\u914d\u7f6e>> \u7f13\u5b58\u5e8f\u5217\u5316\u914d\u7f6e\u5b8c\u6210");
        return RedisCacheManager.builder((RedisConnectionFactory)factory).cacheDefaults(cacheConfiguration).build();
    }
}

