/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import co.elastic.apm.servlet.ApmFilter;
import co.elastic.apm.spring.webmvc.ApmHandlerInterceptor;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnClass(value={ApmFilter.class, ApmHandlerInterceptor.class, WebMvcConfigurer.class})
@ConditionalOnProperty(name={"application.apm.enabled"}, havingValue="true")
public class ApmAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApmAutoConfiguration.class);

    @Configuration
    public class ApmConfigMvcConfig
    implements WebMvcConfigurer {
        @Value(value="${spring.application.name}")
        String applicationName;
        ApplicationProperties applicationProperties;

        public ApmConfigMvcConfig(ApplicationProperties applicationProperties) {
            this.applicationProperties = applicationProperties;
        }

        public void initApmConfig() {
            System.setProperty("elastic.apm.service_name", this.applicationName);
            System.setProperty("elastic.apm.server_url", this.applicationProperties.getApm().getServerUrl());
            System.setProperty("elastic.apm.application_packages", this.applicationProperties.getApm().getApplicationPackages());
        }

        @Bean
        public FilterRegistrationBean apmFilterRegistration() {
            logger.info("Init APM filter for:{}", (Object)this.applicationName);
            this.initApmConfig();
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new ApmFilter());
            registration.addUrlPatterns(new String[]{"/*"});
            registration.setName("apmFilter");
            registration.setOrder(1);
            return registration;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new ApmHandlerInterceptor());
        }
    }
}

