/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.aop.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.commons.aop.dataauth.handler.DefaultDataAuthParamHander;
import cn.com.yusys.yusp.commons.config.CacheAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.AccessFilter;
import cn.com.yusys.yusp.commons.filter.DataAuthFilter;
import cn.com.yusys.yusp.commons.filter.FileUploadChkFilter;
import cn.com.yusys.yusp.commons.filter.XssAndSQLFilter;
import cn.com.yusys.yusp.commons.service.UserService;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureAfter(value={CacheAutoConfiguration.class})
public class FiltersAutoConfiguration {
    public static final Integer FILTER_ORDER_XSS = 100;
    public static final Integer FILTER_ORDER_UPLOAD = 99;
    public static final Integer FILTER_ORDER_ACCESS = 98;
    public static final Integer FILTER_ORDER_DATAAUTH = 97;
    public static final Integer FILTER_ORDER_SERVICEAUTH = 96;
    private static final Logger log = LoggerFactory.getLogger(FiltersAutoConfiguration.class);

    @Configuration
    @ConditionalOnProperty(name={"application.filter.access.enabled"}, havingValue="true")
    @ConditionalOnBean(value={UserService.class})
    public class AccessConfiguration {
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        @Bean
        public AccessFilter accessFilter() {
            this.log.info("Auto configuration >> control point permission verification configuration completed");
            return new AccessFilter();
        }

        @Bean
        public FilterRegistrationBean accessFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.accessFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(FILTER_ORDER_ACCESS.intValue());
            return bean;
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.dataauth.enabled"}, matchIfMissing=false)
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    @ConditionalOnBean(value={UserService.class})
    public class DataAuthAutoConfiguration {
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        @Bean
        public DataAuthFilter dataAuthFilter() {
            this.log.info("Auto configuration >> recordset permission filter configuration completed");
            return new DataAuthFilter();
        }

        @Bean
        public FilterRegistrationBean dataAuthFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.dataAuthFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(FILTER_ORDER_DATAAUTH.intValue());
            return bean;
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAuthParamHander dataAuthParamHander() {
            return new DefaultDataAuthParamHander();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.fileupload.enabled"}, havingValue="true")
    public class FileChkAutoConfiguration {
        @Value(value="${application.filter.fileupload.access-file-type:null}")
        private String accessFileType = null;

        @Bean
        public FileUploadChkFilter fileUploadFilter() {
            log.info("Auto configuration >> prevent malicious file upload filter configuration completed");
            String[] accessFileTypeArray = StringUtil.split((String)this.accessFileType, (String)",");
            ArrayList<String> accessFileTypeList = new ArrayList<String>();
            Collections.addAll(accessFileTypeList, accessFileTypeArray);
            return new FileUploadChkFilter(accessFileTypeList);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.xss.enabled"}, havingValue="true")
    public class XSSAndSqlAutoConfiguration {
        @Bean
        public FilterRegistrationBean xssAndSqlFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new XssAndSQLFilter());
            registration.addUrlPatterns(new String[]{"/*"});
            EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
            registration.setDispatcherTypes(dispatcherTypes);
            log.info("Auto configuration >> anti XSS attack SQL injection  filter configuration completed");
            return registration;
        }
    }
}

