/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.property.crypt.DecryptPropertyService;
import cn.com.yusys.yusp.commons.property.crypt.DesDecryptPropertyService;
import cn.com.yusys.yusp.commons.property.crypt.EncryptionPropertyResolver;
import cn.com.yusys.yusp.commons.property.crypt.RsaDecryptPropertyService;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"application.decrypt.enabled"}, havingValue="true")
public class CryptPropertyAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CryptPropertyAutoConfiguration.class);

    @Bean(name={"encryptablePropertyResolver"})
    public EncryptablePropertyResolver encryptablePropertyResolver() {
        logger.info("\u81ea\u52a8\u914d\u7f6e>> CryptPropertyAutoConfiguration\u914d\u7f6e\u5b8c\u6210");
        return new EncryptionPropertyResolver();
    }

    @Bean
    @ConditionalOnProperty(name={"application.decrypt.type"}, havingValue="RSA")
    public DecryptPropertyService rsaDecryptPropertyService() {
        logger.info("\u81ea\u52a8\u914d\u7f6e>> \u57fa\u4e8eRAS\u7684\u5c5e\u6027\u52a0\u89e3\u5bc6Bean\u52a0\u8f7d");
        return new RsaDecryptPropertyService();
    }

    @Bean
    @ConditionalOnProperty(name={"application.decrypt.type"}, havingValue="DES")
    public DecryptPropertyService desDecryptPropertyService() {
        logger.info("\u81ea\u52a8\u914d\u7f6e>> \u57fa\u4e8eDES\u7684\u5c5e\u6027\u52a0\u89e3\u5bc6Bean\u52a0\u8f7d");
        return new DesDecryptPropertyService();
    }
}

