/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.security;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String OAUTH2_BEARER_TYPE = "Bearer";
    public static final String OAUTH2_AUTHORIZATION = "Authorization";
    public static final String ACCESS_TOKEN = "access_token";

    private SecurityUtils() {
    }

    public static String getCurrentUserToken() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String header = SecurityUtils.extractOauth2Token(request);
        if (log.isDebugEnabled()) {
            log.debug("\u4ecerequest\u5934\u4fe1\u606f\u83b7\u53d6token\u4e3a:[{}]", (Object)header);
        }
        return header;
    }

    public static String extractOauth2Token(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(OAUTH2_AUTHORIZATION);
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith(OAUTH2_BEARER_TYPE.toLowerCase())) continue;
            String authHeaderValue = value.substring(OAUTH2_BEARER_TYPE.length()).trim();
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        if (request.getParameter(ACCESS_TOKEN) != null) {
            return request.getParameter(ACCESS_TOKEN);
        }
        return null;
    }

    public static String getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        String userName = null;
        if (authentication != null) {
            if (authentication.getPrincipal() instanceof UserDetails) {
                UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
                userName = springSecurityUser.getUsername();
            } else if (authentication.getPrincipal() instanceof String) {
                userName = (String)authentication.getPrincipal();
            }
        }
        return userName;
    }

    public static boolean isAuthenticated() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            return authentication.getAuthorities().stream().noneMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_ANONYMOUS"));
        }
        return false;
    }

    public static boolean isCurrentUserInRole(String authority) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            return authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals(authority));
        }
        return false;
    }
}

