/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.filter;

import cn.com.yusys.yusp.commons.util.CommonUtil;
import cn.com.yusys.yusp.commons.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class FileUploadChkFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FileUploadChkFilter.class);
    private List<String> defaultFileTypes = Arrays.asList("docx", "doc", "xlsx", "xls", "txt", "jpg", "png", "pdf", "zip", "rar");

    public FileUploadChkFilter(List<String> fileType) {
        if (CommonUtil.nonNullOrEmpty(fileType) && fileType.size() == 1 && StringUtil.isStrNotEmpty((CharSequence)fileType.get(0))) {
            this.defaultFileTypes = Arrays.asList(fileType.get(0).split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        log.debug("\u914d\u7f6e\u7684\u6587\u4ef6\u767d\u540d\u5355\u4e3a:{}", this.defaultFileTypes);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        StandardServletMultipartResolver multipartResolver = new StandardServletMultipartResolver();
        if (log.isDebugEnabled()) {
            log.debug("\u8fdb\u5165\u6587\u4ef6\u4e0a\u4f20\u8fc7\u6ee4");
        }
        if (multipartResolver.isMultipart(request)) {
            if (log.isDebugEnabled()) {
                log.debug("\u6587\u4ef6\u4e0a\u4f20url\uff1a" + request.getRequestURI());
            }
            MultipartHttpServletRequest multiRequest = multipartResolver.resolveMultipart(request);
            Iterator iter = multiRequest.getFileNames();
            Map files = multiRequest.getFileMap();
            for (String key : files.keySet()) {
                String fileName = ((MultipartFile)files.get(key)).getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (!this.defaultFileTypes.contains(suffix.toLowerCase())) {
                    log.debug("\u975e\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20url\uff1a" + request.getRequestURI());
                    response.sendError(500, "error file type from yusp filter");
                    return;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("\u5408\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20url\uff1a" + request.getRequestURI());
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

